/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages.value;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LastRequestType
implements Comparable<LastRequestType> {
    public static final LastRequestType NONE = new LastRequestType(0, "none");
    public static final LastRequestType TIME_OF_INITIAL_TGT = new LastRequestType(1, "time of initial ticket");
    public static final LastRequestType TIME_OF_INITIAL_REQ = new LastRequestType(2, "time of initial request");
    public static final LastRequestType TIME_OF_NEWEST_TGT = new LastRequestType(3, "time of newest ticket");
    public static final LastRequestType TIME_OF_LAST_RENEWAL = new LastRequestType(4, "time of last renewal");
    public static final LastRequestType TIME_OF_LAST_REQ = new LastRequestType(5, "time of last request");
    public static final LastRequestType TIME_OF_PASSWORD_EXP = new LastRequestType(6, "time of password expiration");
    private static final LastRequestType[] values = new LastRequestType[]{NONE, TIME_OF_INITIAL_TGT, TIME_OF_INITIAL_REQ, TIME_OF_NEWEST_TGT, TIME_OF_LAST_RENEWAL, TIME_OF_LAST_REQ, TIME_OF_PASSWORD_EXP};
    public static final List<LastRequestType> VALUES = Collections.unmodifiableList(Arrays.asList(values));
    private final String name;
    private final int ordinal;

    private LastRequestType(int ordinal, String name) {
        this.ordinal = ordinal;
        this.name = name;
    }

    public static LastRequestType getTypeByOrdinal(int type) {
        for (int ii = 0; ii < values.length; ++ii) {
            if (LastRequestType.values[ii].ordinal != type) continue;
            return values[ii];
        }
        return NONE;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public int compareTo(LastRequestType that) {
        return this.ordinal - that.ordinal;
    }

    public String toString() {
        return this.name + " (" + this.ordinal + ")";
    }
}

