/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.store;

import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.spi.InitialContextFactory;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.core.configuration.ConfigurationException;
import org.apache.directory.server.kerberos.shared.store.PrincipalStore;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.server.kerberos.shared.store.operations.AddPrincipal;
import org.apache.directory.server.kerberos.shared.store.operations.ChangePassword;
import org.apache.directory.server.kerberos.shared.store.operations.DeletePrincipal;
import org.apache.directory.server.kerberos.shared.store.operations.GetAllPrincipals;
import org.apache.directory.server.kerberos.shared.store.operations.GetPrincipal;
import org.apache.directory.server.protocol.shared.ServiceConfiguration;
import org.apache.directory.server.protocol.shared.store.ContextOperation;

class SingleBaseSearch
implements PrincipalStore {
    private DirContext ctx;

    SingleBaseSearch(ServiceConfiguration config, InitialContextFactory factory) {
        Hashtable<String, String> env = new Hashtable<String, String>(config.toJndiEnvironment());
        env.put("java.naming.factory.initial", config.getInitialContextFactory());
        env.put("java.naming.provider.url", config.getEntryBaseDn());
        try {
            this.ctx = (DirContext)factory.getInitialContext(env);
        }
        catch (NamingException ne) {
            String message = "Failed to get initial context " + (String)env.get("java.naming.provider.url");
            throw new ConfigurationException(message, (Throwable)ne);
        }
    }

    public String addPrincipal(PrincipalStoreEntry entry) throws Exception {
        return (String)this.execute(new AddPrincipal(entry));
    }

    public String deletePrincipal(KerberosPrincipal principal) throws Exception {
        return (String)this.execute(new DeletePrincipal(principal));
    }

    public PrincipalStoreEntry[] getAllPrincipals(String realm) throws Exception {
        return (PrincipalStoreEntry[])this.execute(new GetAllPrincipals());
    }

    public PrincipalStoreEntry getPrincipal(KerberosPrincipal principal) throws Exception {
        return (PrincipalStoreEntry)this.execute(new GetPrincipal(principal));
    }

    public String changePassword(KerberosPrincipal principal, KerberosKey newKey) throws Exception {
        return (String)this.execute(new ChangePassword(principal, newKey));
    }

    private Object execute(ContextOperation operation) throws Exception {
        return operation.execute(this.ctx, null);
    }
}

