/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.directory.server.kerberos.shared.io.encoder.AuthorizationDataEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.Encoder;
import org.apache.directory.server.kerberos.shared.io.encoder.EncoderFactory;
import org.apache.directory.server.kerberos.shared.io.encoder.EncryptionKeyEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.HostAddressesEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.KerberosTimeEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.PrincipalNameEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.TransitedEncodingEncoder;
import org.apache.directory.server.kerberos.shared.messages.Encodable;
import org.apache.directory.server.kerberos.shared.messages.components.EncTicketPart;
import org.apache.directory.shared.asn1.der.ASN1OutputStream;
import org.apache.directory.shared.asn1.der.DERApplicationSpecific;
import org.apache.directory.shared.asn1.der.DERBitString;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERGeneralString;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class EncTicketPartEncoder
implements Encoder,
EncoderFactory {
    private static final int APPLICATION_CODE = 3;

    public byte[] encode(Encodable ticketPart) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream aos = new ASN1OutputStream((OutputStream)baos);
        DERSequence ticketSequence = this.encodeInitialSequence((EncTicketPart)ticketPart);
        aos.writeObject((Object)DERApplicationSpecific.valueOf((int)3, (DEREncodable)ticketSequence));
        aos.close();
        return baos.toByteArray();
    }

    public Encoder getEncoder() {
        return new EncTicketPartEncoder();
    }

    public DERSequence encodeInitialSequence(EncTicketPart ticketPart) {
        DERSequence sequence = new DERSequence();
        sequence.add((DEREncodable)new DERTaggedObject(0, (DEREncodable)new DERBitString(ticketPart.getFlags().getBytes())));
        sequence.add((DEREncodable)new DERTaggedObject(1, (DEREncodable)EncryptionKeyEncoder.encode(ticketPart.getSessionKey())));
        sequence.add((DEREncodable)new DERTaggedObject(2, (DEREncodable)DERGeneralString.valueOf((String)ticketPart.getClientRealm().toString())));
        sequence.add((DEREncodable)new DERTaggedObject(3, (DEREncodable)PrincipalNameEncoder.encode(ticketPart.getClientPrincipal())));
        sequence.add((DEREncodable)new DERTaggedObject(4, (DEREncodable)TransitedEncodingEncoder.encode(ticketPart.getTransitedEncoding())));
        sequence.add((DEREncodable)new DERTaggedObject(5, (DEREncodable)KerberosTimeEncoder.encode(ticketPart.getAuthTime())));
        if (ticketPart.getStartTime() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(6, (DEREncodable)KerberosTimeEncoder.encode(ticketPart.getStartTime())));
        }
        sequence.add((DEREncodable)new DERTaggedObject(7, (DEREncodable)KerberosTimeEncoder.encode(ticketPart.getEndTime())));
        if (ticketPart.getRenewTill() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(8, (DEREncodable)KerberosTimeEncoder.encode(ticketPart.getRenewTill())));
        }
        if (ticketPart.getClientAddresses() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(9, (DEREncodable)HostAddressesEncoder.encodeSequence(ticketPart.getClientAddresses())));
        }
        if (ticketPart.getAuthorizationData() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(10, (DEREncodable)AuthorizationDataEncoder.encode(ticketPart.getAuthorizationData())));
        }
        return sequence;
    }
}

