/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.directory.server.kerberos.shared.io.encoder.Encoder;
import org.apache.directory.server.kerberos.shared.io.encoder.EncoderFactory;
import org.apache.directory.server.kerberos.shared.io.encoder.EncryptionKeyEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.KerberosTimeEncoder;
import org.apache.directory.server.kerberos.shared.messages.Encodable;
import org.apache.directory.server.kerberos.shared.messages.components.EncApRepPart;
import org.apache.directory.shared.asn1.der.ASN1OutputStream;
import org.apache.directory.shared.asn1.der.DERApplicationSpecific;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class EncApRepPartEncoder
implements Encoder,
EncoderFactory {
    public static final int APPLICATION_CODE = 27;

    public Encoder getEncoder() {
        return new EncApRepPartEncoder();
    }

    public byte[] encode(Encodable apRepPart) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream aos = new ASN1OutputStream((OutputStream)baos);
        DERSequence privPartSequence = this.encodeApRepPartSequence((EncApRepPart)apRepPart);
        aos.writeObject((Object)DERApplicationSpecific.valueOf((int)27, (DEREncodable)privPartSequence));
        aos.close();
        return baos.toByteArray();
    }

    private DERSequence encodeApRepPartSequence(EncApRepPart message) {
        DERSequence sequence = new DERSequence();
        sequence.add((DEREncodable)new DERTaggedObject(0, (DEREncodable)KerberosTimeEncoder.encode(message.getClientTime())));
        sequence.add((DEREncodable)new DERTaggedObject(1, (DEREncodable)DERInteger.valueOf((int)message.getClientMicroSecond())));
        if (message.getSubSessionKey() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(2, (DEREncodable)EncryptionKeyEncoder.encode(message.getSubSessionKey())));
        }
        if (message.getSequenceNumber() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(3, (DEREncodable)DERInteger.valueOf((int)message.getSequenceNumber())));
        }
        return sequence;
    }
}

