/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.directory.server.core.partition.impl.btree.IndexRecord;
import org.apache.directory.server.core.partition.impl.btree.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexEnumeration
implements NamingEnumeration<IndexRecord> {
    private final Pattern re;
    private final IndexRecord tmp = new IndexRecord();
    private final IndexRecord returned = new IndexRecord();
    private final IndexRecord prefetched = new IndexRecord();
    private final boolean swapKeyVal;
    private final NamingEnumeration<Tuple> underlying;
    private boolean hasMore = true;

    public IndexEnumeration(NamingEnumeration<Tuple> list) throws NamingException {
        this(list, false, null);
    }

    public IndexEnumeration(NamingEnumeration<Tuple> list, boolean swapKeyVal) throws NamingException {
        this(list, swapKeyVal, null);
    }

    public IndexEnumeration(NamingEnumeration<Tuple> list, boolean swapKeyVal, Pattern regex) throws NamingException {
        this.re = regex;
        this.underlying = list;
        this.swapKeyVal = swapKeyVal;
        if (!this.underlying.hasMore()) {
            this.hasMore = false;
            return;
        }
        this.prefetch();
    }

    @Override
    public IndexRecord next() throws NamingException {
        this.returned.copy(this.prefetched);
        this.prefetch();
        return this.returned;
    }

    @Override
    public IndexRecord nextElement() {
        try {
            return this.next();
        }
        catch (NamingException ne) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public boolean hasMore() {
        return this.hasMore;
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMore;
    }

    @Override
    public void close() throws NamingException {
        this.hasMore = false;
        this.underlying.close();
    }

    private void prefetch() throws NamingException {
        while (this.underlying.hasMore()) {
            Tuple tuple = this.underlying.next();
            if (this.swapKeyVal) {
                this.tmp.setSwapped(tuple, null);
            } else {
                this.tmp.setTuple(tuple, null);
            }
            if (null != this.re && !this.re.matcher((String)this.tmp.getIndexKey()).matches()) continue;
            this.prefetched.copy(this.tmp);
            return;
        }
        this.hasMore = false;
    }
}

