/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.shared;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExceptionHelper {
    public static final String STACK_TRACE_PROPERTY = "org.apache.chemistry.opencmis.stacktrace.disable";
    private static final boolean sendStackTrace = System.getProperty("org.apache.chemistry.opencmis.stacktrace.disable") == null;

    private ExceptionHelper() {
    }

    public static String getStacktraceAsString(Throwable t) {
        if (!sendStackTrace || t == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static Node getStacktraceAsNode(Throwable t) {
        try {
            String st = ExceptionHelper.getStacktraceAsString(t);
            if (st != null) {
                DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
                Document doc = docBuilder.newDocument();
                Element node = doc.createElementNS("http://chemistry.apache.org/opencmis/exception", "stacktrace");
                doc.appendChild(node);
                node.appendChild(doc.createTextNode(st));
                return node;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

