/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.math.BigInteger;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.TypeCache;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.impl.browser.BrowserBindingUtils;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class NavigationService {
    private NavigationService() {
    }

    public static void getChildren(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BigInteger skipCount;
        BigInteger maxItems;
        Boolean includePathSegment;
        String renditionFilter;
        IncludeRelationships includeRelationships;
        Boolean includeAllowableActions;
        String orderBy;
        String filter;
        String folderId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        ObjectInFolderList children = service.getChildren(repositoryId, folderId, filter = HttpUtils.getStringParameter(request, "filter"), orderBy = HttpUtils.getStringParameter(request, "orderBy"), includeAllowableActions = HttpUtils.getBooleanParameter(request, "includeAllowableActions"), includeRelationships = HttpUtils.getEnumParameter(request, "includeRelationships", IncludeRelationships.class), renditionFilter = HttpUtils.getStringParameter(request, "renditionFilter"), includePathSegment = HttpUtils.getBooleanParameter(request, "includePathSegment"), maxItems = HttpUtils.getBigIntegerParameter(request, "maxItems"), skipCount = HttpUtils.getBigIntegerParameter(request, "skipCount"), null);
        if (children == null) {
            throw new CmisRuntimeException("Children are null!");
        }
        TypeCache typeCache = new TypeCache(repositoryId, service);
        JSONObject jsonChildren = JSONConverter.convert((ObjectInFolderList)children, (TypeCache)typeCache);
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonChildren, request, response);
    }

    public static void getDescendants(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Boolean includePathSegment;
        String renditionFilter;
        IncludeRelationships includeRelationships;
        Boolean includeAllowableActions;
        String filter;
        BigInteger depth;
        String folderId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        List descendants = service.getDescendants(repositoryId, folderId, depth = HttpUtils.getBigIntegerParameter(request, "depth"), filter = HttpUtils.getStringParameter(request, "filter"), includeAllowableActions = HttpUtils.getBooleanParameter(request, "includeAllowableActions"), includeRelationships = HttpUtils.getEnumParameter(request, "includeRelationships", IncludeRelationships.class), renditionFilter = HttpUtils.getStringParameter(request, "renditionFilter"), includePathSegment = HttpUtils.getBooleanParameter(request, "includePathSegment"), null);
        if (descendants == null) {
            throw new CmisRuntimeException("Descendants are null!");
        }
        TypeCache typeCache = new TypeCache(repositoryId, service);
        JSONArray jsonDescendants = new JSONArray();
        for (ObjectInFolderContainer descendant : descendants) {
            jsonDescendants.add((Object)JSONConverter.convert((ObjectInFolderContainer)descendant, (TypeCache)typeCache));
        }
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonDescendants, request, response);
    }

    public static void getFolderTree(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Boolean includePathSegment;
        String renditionFilter;
        IncludeRelationships includeRelationships;
        Boolean includeAllowableActions;
        String filter;
        BigInteger depth;
        String folderId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        List folderTree = service.getFolderTree(repositoryId, folderId, depth = HttpUtils.getBigIntegerParameter(request, "depth"), filter = HttpUtils.getStringParameter(request, "filter"), includeAllowableActions = HttpUtils.getBooleanParameter(request, "includeAllowableActions"), includeRelationships = HttpUtils.getEnumParameter(request, "includeRelationships", IncludeRelationships.class), renditionFilter = HttpUtils.getStringParameter(request, "renditionFilter"), includePathSegment = HttpUtils.getBooleanParameter(request, "includePathSegment"), null);
        if (folderTree == null) {
            throw new CmisRuntimeException("Folder Tree are null!");
        }
        TypeCache typeCache = new TypeCache(repositoryId, service);
        JSONArray jsonDescendants = new JSONArray();
        for (ObjectInFolderContainer descendant : folderTree) {
            jsonDescendants.add((Object)JSONConverter.convert((ObjectInFolderContainer)descendant, (TypeCache)typeCache));
        }
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonDescendants, request, response);
    }

    public static void getFolderParent(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String filter;
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        ObjectData parent = service.getFolderParent(repositoryId, objectId, filter = HttpUtils.getStringParameter(request, "filter"), null);
        if (parent == null) {
            throw new CmisRuntimeException("Parent is null!");
        }
        TypeCache typeCache = new TypeCache(repositoryId, service);
        JSONObject jsonObject = JSONConverter.convert((ObjectData)parent, (TypeCache)typeCache);
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonObject, request, response);
    }

    public static void getObjectParents(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Boolean includeRelativePathSegment;
        String renditionFilter;
        IncludeRelationships includeRelationships;
        Boolean includeAllowableActions;
        String filter;
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        List parents = service.getObjectParents(repositoryId, objectId, filter = HttpUtils.getStringParameter(request, "filter"), includeAllowableActions = HttpUtils.getBooleanParameter(request, "includeAllowableActions"), includeRelationships = HttpUtils.getEnumParameter(request, "includeRelationships", IncludeRelationships.class), renditionFilter = HttpUtils.getStringParameter(request, "renditionFilter"), includeRelativePathSegment = HttpUtils.getBooleanParameter(request, "includeRelativePathSegment"), null);
        if (parents == null) {
            throw new CmisRuntimeException("Parents are null!");
        }
        TypeCache typeCache = new TypeCache(repositoryId, service);
        JSONArray jsonParents = new JSONArray();
        for (ObjectParentData parent : parents) {
            jsonParents.add((Object)JSONConverter.convert((ObjectParentData)parent, (TypeCache)typeCache));
        }
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonParents, request, response);
    }

    public static void getCheckedOutDocs(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BigInteger skipCount;
        BigInteger maxItems;
        String renditionFilter;
        IncludeRelationships includeRelationships;
        Boolean includeAllowableActions;
        String orderBy;
        String filter;
        String folderId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        ObjectList checkedout = service.getCheckedOutDocs(repositoryId, folderId, filter = HttpUtils.getStringParameter(request, "filter"), orderBy = HttpUtils.getStringParameter(request, "orderBy"), includeAllowableActions = HttpUtils.getBooleanParameter(request, "includeAllowableActions"), includeRelationships = HttpUtils.getEnumParameter(request, "includeRelationships", IncludeRelationships.class), renditionFilter = HttpUtils.getStringParameter(request, "renditionFilter"), maxItems = HttpUtils.getBigIntegerParameter(request, "maxItems"), skipCount = HttpUtils.getBigIntegerParameter(request, "skipCount"), null);
        if (checkedout == null) {
            throw new CmisRuntimeException("Checked out list is null!");
        }
        TypeCache typeCache = new TypeCache(repositoryId, service);
        JSONObject jsonCheckedOut = JSONConverter.convert((ObjectList)checkedout, (TypeCache)typeCache);
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonCheckedOut, request, response);
    }
}

