/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.atompub;

import java.io.OutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public abstract class XMLDocumentBase {
    public static final String PREFIX_ATOM = "atom";
    public static final String PREFIX_CMIS = "cmis";
    public static final String PREFIX_RESTATOM = "cmisra";
    public static final String PREFIX_APP = "app";
    public static final String PREFIX_XSI = "xsi";
    private XMLStreamWriter writer;

    public void setNamespaces() throws XMLStreamException {
        this.writer.setPrefix(PREFIX_ATOM, "http://www.w3.org/2005/Atom");
        this.writer.setPrefix(PREFIX_CMIS, "http://docs.oasis-open.org/ns/cmis/core/200908/");
        this.writer.setPrefix(PREFIX_RESTATOM, "http://docs.oasis-open.org/ns/cmis/restatom/200908/");
        this.writer.setPrefix(PREFIX_APP, "http://www.w3.org/2007/app");
        this.writer.setPrefix(PREFIX_XSI, "http://www.w3.org/2001/XMLSchema-instance");
    }

    public void writeNamespace(String namespaceUri) throws XMLStreamException {
        this.writer.writeNamespace(this.writer.getPrefix(namespaceUri), namespaceUri);
    }

    public void startDocument(OutputStream out) throws XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        this.writer = factory.createXMLStreamWriter(out, "UTF-8");
        this.writer.writeStartDocument("UTF-8", "1.0");
        this.setNamespaces();
    }

    public void endDocument() throws XMLStreamException {
        if (this.writer == null) {
            return;
        }
        this.writer.writeEndDocument();
        this.writer.close();
    }

    public XMLStreamWriter getWriter() {
        return this.writer;
    }

    protected void setWriter(XMLStreamWriter writer) {
        this.writer = writer;
    }
}

