/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.RoutesBuilderLoader;
import org.apache.camel.spi.RoutesLoader;
import org.apache.camel.support.ResolverHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;

public class DefaultRoutesLoader
extends ServiceSupport
implements RoutesLoader {
    public static final String ROUTES_LOADER_KEY_PREFIX = "routes-builder-loader-";
    private final Map<String, RoutesBuilderLoader> loaders;
    private CamelContext camelContext;

    public DefaultRoutesLoader() {
        this(null);
    }

    public DefaultRoutesLoader(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.loaders = new ConcurrentHashMap<String, RoutesBuilderLoader>();
    }

    public void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService(this.loaders.values());
        this.loaders.clear();
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Collection<RoutesBuilder> findRoutesBuilders(Collection<Resource> resources) throws Exception {
        ArrayList<RoutesBuilder> answer = new ArrayList<RoutesBuilder>(resources.size());
        for (Resource resource : resources) {
            String extension = FileUtil.onlyExt((String)resource.getLocation(), (boolean)false);
            if (ObjectHelper.isEmpty((Object)extension)) {
                throw new IllegalArgumentException("Unable to determine file extension for resource: " + resource.getLocation());
            }
            RoutesBuilderLoader loader = this.getRoutesLoader(extension);
            if (loader == null) {
                throw new IllegalArgumentException("Cannot find RoutesBuilderLoader in classpath supporting file extension: " + extension);
            }
            answer.add(loader.loadRoutesBuilder(resource));
        }
        return answer;
    }

    private RoutesBuilderLoader getRoutesLoader(String extension) throws Exception {
        RoutesBuilderLoader answer = (RoutesBuilderLoader)this.getCamelContext().getRegistry().lookupByNameAndType(ROUTES_LOADER_KEY_PREFIX + extension, RoutesBuilderLoader.class);
        if (answer == null) {
            answer = this.loaders.computeIfAbsent(extension, this::resolveService);
        }
        return answer;
    }

    private RoutesBuilderLoader resolveService(String extension) {
        FactoryFinder finder;
        ExtendedCamelContext ecc = (ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class);
        RoutesBuilderLoader answer = ResolverHelper.resolveService((CamelContext)ecc, (FactoryFinder)(finder = ecc.getBootstrapFactoryFinder("META-INF/services/org/apache/camel/routes-loader/")), (String)extension, RoutesBuilderLoader.class).orElse(null);
        if (answer != null) {
            CamelContextAware.trySetCamelContext((Object)answer, (CamelContext)this.getCamelContext());
            ServiceHelper.startService((Object)answer);
        }
        return answer;
    }
}

