/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.discovery;

import java.util.Map;
import org.jolokia.Version;
import org.jolokia.config.ConfigKey;
import org.jolokia.config.Configuration;
import org.jolokia.discovery.AbstractDiscoveryMessage;
import org.jolokia.util.NetworkUtil;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentDetails {
    private String serverVendor;
    private String serverProduct;
    private String serverVersion;
    private String url;
    private Boolean secured;
    private String agentVersion;
    private String agentId;
    private String agentDescription;
    private boolean sealed;

    public AgentDetails(String pAgentId) {
        this.agentVersion = Version.getAgentVersion();
        this.agentId = pAgentId;
        if (this.agentId == null) {
            throw new IllegalArgumentException("No agent id given");
        }
        this.sealed = false;
    }

    public AgentDetails(Configuration pConfig) {
        this(NetworkUtil.replaceExpression(pConfig.get(ConfigKey.AGENT_ID)));
        this.agentDescription = pConfig.get(ConfigKey.AGENT_DESCRIPTION);
    }

    public AgentDetails(Map<AbstractDiscoveryMessage.Payload, Object> pMsgData) {
        this.serverVendor = (String)pMsgData.get((Object)AbstractDiscoveryMessage.Payload.SERVER_VENDOR);
        this.serverProduct = (String)pMsgData.get((Object)AbstractDiscoveryMessage.Payload.SERVER_PRODUCT);
        this.serverVersion = (String)pMsgData.get((Object)AbstractDiscoveryMessage.Payload.SERVER_VERSION);
        this.url = (String)pMsgData.get((Object)AbstractDiscoveryMessage.Payload.URL);
        if (pMsgData.containsKey((Object)AbstractDiscoveryMessage.Payload.SECURED)) {
            this.secured = (Boolean)pMsgData.get((Object)AbstractDiscoveryMessage.Payload.SECURED);
        }
        this.agentVersion = (String)pMsgData.get((Object)AbstractDiscoveryMessage.Payload.AGENT_VERSION);
        this.agentDescription = (String)pMsgData.get((Object)AbstractDiscoveryMessage.Payload.AGENT_DESCRIPTION);
        this.agentId = (String)pMsgData.get((Object)AbstractDiscoveryMessage.Payload.AGENT_ID);
        if (this.agentId == null) {
            throw new IllegalArgumentException("No agent id given");
        }
        this.sealed = true;
    }

    public void setServerInfo(String pVendor, String pProduct, String pVersion) {
        this.checkSeal();
        this.serverVendor = pVendor;
        this.serverProduct = pProduct;
        this.serverVersion = pVersion;
    }

    public void setUrl(String pUrl) {
        this.checkSeal();
        this.url = pUrl;
    }

    public void setSecured(Boolean pSecured) {
        this.checkSeal();
        this.secured = pSecured;
    }

    private void checkSeal() {
        if (this.sealed) {
            throw new IllegalStateException("Cannot update agent details because it is already initialized and sealed");
        }
    }

    public boolean isInitRequired() {
        return !this.sealed && (this.isUrlMissing() || this.isSecuredMissing());
    }

    public boolean isUrlMissing() {
        return this.url == null;
    }

    public boolean isSecuredMissing() {
        return this.secured == null;
    }

    public void seal() {
        this.sealed = true;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public JSONObject toJSONObject() {
        JSONObject resp = new JSONObject();
        this.add(resp, AbstractDiscoveryMessage.Payload.URL, this.url);
        if (this.secured != null) {
            this.add(resp, AbstractDiscoveryMessage.Payload.SECURED, this.secured);
        }
        this.add(resp, AbstractDiscoveryMessage.Payload.SERVER_VENDOR, this.serverVendor);
        this.add(resp, AbstractDiscoveryMessage.Payload.SERVER_PRODUCT, this.serverProduct);
        this.add(resp, AbstractDiscoveryMessage.Payload.SERVER_VERSION, this.serverVersion);
        this.add(resp, AbstractDiscoveryMessage.Payload.AGENT_VERSION, this.agentVersion);
        this.add(resp, AbstractDiscoveryMessage.Payload.AGENT_ID, this.agentId);
        this.add(resp, AbstractDiscoveryMessage.Payload.AGENT_DESCRIPTION, this.agentDescription);
        return resp;
    }

    public String toString() {
        return "AgentDetails{" + this.toJSONObject().toJSONString() + "}";
    }

    private void add(JSONObject pResp, AbstractDiscoveryMessage.Payload pKey, Object pValue) {
        if (pValue != null) {
            pResp.put((Object)pKey.toString().toLowerCase(), pValue);
        }
    }
}

