/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.zookeeper.client;

import java.util.List;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.linkedin.util.io.PathUtils;
import org.linkedin.zookeeper.client.IZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractZooKeeper
implements IZooKeeper {
    public static final String MODULE = AbstractZooKeeper.class.getName();
    public static final Logger log = LoggerFactory.getLogger((String)MODULE);
    private final String _chroot;

    public AbstractZooKeeper() {
        this(null);
    }

    public AbstractZooKeeper(String chroot) {
        this._chroot = chroot;
    }

    public static String adjustPath(String path, String chroot) {
        if (chroot != null) {
            path = PathUtils.addPaths((String)chroot, (String)path);
        }
        path = PathUtils.removeTrailingSlash((String)path);
        path = PathUtils.addLeadingSlash((String)path);
        return path;
    }

    protected String adjustPath(String path) {
        return AbstractZooKeeper.adjustPath(path, this._chroot);
    }

    @Override
    public void addAuthInfo(String scheme, byte[] auth) {
        this.getZk().addAuthInfo(scheme, auth);
    }

    protected abstract IZooKeeper getZk();

    @Override
    public void close() throws InterruptedException {
        this.getZk().close();
    }

    @Override
    public String create(String path, byte[] data, List<ACL> acl, CreateMode createMode) throws KeeperException, InterruptedException {
        return this.getZk().create(this.adjustPath(path), data, acl, createMode);
    }

    @Override
    public void create(String path, byte[] data, List<ACL> acl, CreateMode createMode, AsyncCallback.StringCallback cb, Object ctx) {
        this.getZk().create(this.adjustPath(path), data, acl, createMode, cb, ctx);
    }

    @Override
    public void delete(String path, int version) throws KeeperException, InterruptedException {
        this.getZk().delete(this.adjustPath(path), version);
    }

    @Override
    public void delete(String path, int version, AsyncCallback.VoidCallback cb, Object ctx) {
        this.getZk().delete(this.adjustPath(path), version, cb, ctx);
    }

    @Override
    public Stat exists(String path, boolean watch) throws KeeperException, InterruptedException {
        return this.getZk().exists(this.adjustPath(path), watch);
    }

    @Override
    public void exists(String path, boolean watch, AsyncCallback.StatCallback cb, Object ctx) {
        this.getZk().exists(this.adjustPath(path), watch, cb, ctx);
    }

    @Override
    public Stat exists(String path, Watcher watcher) throws KeeperException, InterruptedException {
        return this.getZk().exists(this.adjustPath(path), watcher);
    }

    @Override
    public void exists(String path, Watcher watcher, AsyncCallback.StatCallback cb, Object ctx) {
        this.getZk().exists(this.adjustPath(path), watcher, cb, ctx);
    }

    @Override
    public List<ACL> getACL(String path, Stat stat) throws KeeperException, InterruptedException {
        return this.getZk().getACL(this.adjustPath(path), stat);
    }

    @Override
    public void getACL(String path, Stat stat, AsyncCallback.ACLCallback cb, Object ctx) {
        this.getZk().getACL(this.adjustPath(path), stat, cb, ctx);
    }

    @Override
    public List<String> getChildren(String path, boolean watch) throws KeeperException, InterruptedException {
        return this.getZk().getChildren(this.adjustPath(path), watch);
    }

    @Override
    public void getChildren(String path, boolean watch, AsyncCallback.ChildrenCallback cb, Object ctx) {
        this.getZk().getChildren(this.adjustPath(path), watch, cb, ctx);
    }

    @Override
    public List<String> getChildren(String path, Watcher watcher) throws KeeperException, InterruptedException {
        return this.getZk().getChildren(this.adjustPath(path), watcher);
    }

    @Override
    public void getChildren(String path, Watcher watcher, AsyncCallback.ChildrenCallback cb, Object ctx) {
        this.getZk().getChildren(this.adjustPath(path), watcher, cb, ctx);
    }

    @Override
    public void getData(String path, boolean watch, AsyncCallback.DataCallback cb, Object ctx) {
        this.getZk().getData(this.adjustPath(path), watch, cb, ctx);
    }

    @Override
    public byte[] getData(String path, boolean watch, Stat stat) throws KeeperException, InterruptedException {
        return this.getZk().getData(this.adjustPath(path), watch, stat);
    }

    @Override
    public void getData(String path, Watcher watcher, AsyncCallback.DataCallback cb, Object ctx) {
        this.getZk().getData(this.adjustPath(path), watcher, cb, ctx);
    }

    @Override
    public byte[] getData(String path, Watcher watcher, Stat stat) throws KeeperException, InterruptedException {
        return this.getZk().getData(this.adjustPath(path), watcher, stat);
    }

    @Override
    public long getSessionId() {
        return this.getZk().getSessionId();
    }

    @Override
    public byte[] getSessionPasswd() {
        return this.getZk().getSessionPasswd();
    }

    @Override
    public ZooKeeper.States getState() {
        return this.getZk().getState();
    }

    @Override
    public void register(Watcher watcher) {
        this.getZk().register(watcher);
    }

    @Override
    public Stat setACL(String path, List<ACL> acl, int version) throws KeeperException, InterruptedException {
        return this.getZk().setACL(this.adjustPath(path), acl, version);
    }

    @Override
    public void setACL(String path, List<ACL> acl, int version, AsyncCallback.StatCallback cb, Object ctx) {
        this.getZk().setACL(this.adjustPath(path), acl, version, cb, ctx);
    }

    @Override
    public Stat setData(String path, byte[] data, int version) throws KeeperException, InterruptedException {
        return this.getZk().setData(this.adjustPath(path), data, version);
    }

    @Override
    public void setData(String path, byte[] data, int version, AsyncCallback.StatCallback cb, Object ctx) {
        this.getZk().setData(this.adjustPath(path), data, version, cb, ctx);
    }

    @Override
    public void sync(String path, AsyncCallback.VoidCallback cb, Object ctx) {
        this.getZk().sync(this.adjustPath(path), cb, ctx);
    }

    @Override
    public void getChildren(String path, boolean watch, AsyncCallback.Children2Callback cb, Object ctx) {
        this.getZk().getChildren(this.adjustPath(path), watch, cb, ctx);
    }

    @Override
    public int getSessionTimeout() {
        return this.getZk().getSessionTimeout();
    }

    @Override
    public List<String> getChildren(String path, Watcher watcher, Stat stat) throws KeeperException, InterruptedException {
        return this.getZk().getChildren(this.adjustPath(path), watcher, stat);
    }

    @Override
    public List<String> getChildren(String path, boolean watch, Stat stat) throws KeeperException, InterruptedException {
        return this.getZk().getChildren(this.adjustPath(path), watch, stat);
    }

    @Override
    public void getChildren(String path, Watcher watcher, AsyncCallback.Children2Callback cb, Object ctx) {
        this.getZk().getChildren(this.adjustPath(path), watcher, cb, ctx);
    }
}

