/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.user;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.springframework.messaging.simp.user.UserSessionRegistry;
import org.springframework.util.Assert;

public class DefaultUserSessionRegistry
implements UserSessionRegistry {
    private final ConcurrentMap<String, Set<String>> userSessionIds = new ConcurrentHashMap<String, Set<String>>();
    private final Object lock = new Object();

    @Override
    public Set<String> getSessionIds(String user) {
        Set<String> set = (Set<String>)this.userSessionIds.get(user);
        return set != null ? set : Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerSessionId(String user, String sessionId) {
        Assert.notNull(user, "User must not be null");
        Assert.notNull(sessionId, "Session ID must not be null");
        Object object = this.lock;
        synchronized (object) {
            CopyOnWriteArraySet<String> set = (CopyOnWriteArraySet<String>)this.userSessionIds.get(user);
            if (set == null) {
                set = new CopyOnWriteArraySet<String>();
                this.userSessionIds.put(user, set);
            }
            set.add(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterSessionId(String userName, String sessionId) {
        Assert.notNull(userName, "User Name must not be null");
        Assert.notNull(sessionId, "Session ID must not be null");
        Object object = this.lock;
        synchronized (object) {
            Set set = (Set)this.userSessionIds.get(userName);
            if (set != null && set.remove(sessionId) && set.isEmpty()) {
                this.userSessionIds.remove(userName);
            }
        }
    }
}

