/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.support.converter;

import javax.jms.JMSException;
import javax.jms.Session;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jms.support.JmsHeaderMapper;
import org.springframework.jms.support.SimpleJmsHeaderMapper;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.SimpleMessageConverter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;

public class MessagingMessageConverter
implements MessageConverter,
InitializingBean {
    private MessageConverter payloadConverter;
    private JmsHeaderMapper headerMapper;

    public MessagingMessageConverter() {
        this(new SimpleMessageConverter(), new SimpleJmsHeaderMapper());
    }

    public MessagingMessageConverter(MessageConverter payloadConverter, JmsHeaderMapper headerMapper) {
        Assert.notNull(payloadConverter, "PayloadConverter must not be null");
        Assert.notNull(headerMapper, "HeaderMapper must not be null");
        this.payloadConverter = payloadConverter;
        this.headerMapper = headerMapper;
    }

    public void setPayloadConverter(MessageConverter payloadConverter) {
        this.payloadConverter = payloadConverter;
    }

    public void setHeaderMapper(JmsHeaderMapper headerMapper) {
        this.headerMapper = headerMapper;
    }

    @Override
    public void afterPropertiesSet() {
        Assert.notNull(this.payloadConverter, "Property 'payloadConverter' is required");
        Assert.notNull(this.headerMapper, "Property 'headerMapper' is required");
    }

    @Override
    public javax.jms.Message toMessage(Object object, Session session) throws JMSException, MessageConversionException {
        if (!(object instanceof Message)) {
            throw new IllegalArgumentException("Could not convert [" + object + "] - only [" + Message.class.getName() + "] is handled by this converter");
        }
        Message input = (Message)object;
        javax.jms.Message reply = this.payloadConverter.toMessage(input.getPayload(), session);
        this.headerMapper.fromHeaders(input.getHeaders(), reply);
        return reply;
    }

    @Override
    public Object fromMessage(javax.jms.Message message) throws JMSException, MessageConversionException {
        if (message == null) {
            return null;
        }
        MessageHeaders mappedHeaders = this.headerMapper.toHeaders(message);
        Object convertedObject = this.extractPayload(message);
        MessageBuilder<Object> builder = convertedObject instanceof Message ? MessageBuilder.fromMessage((Message)convertedObject) : MessageBuilder.withPayload(convertedObject);
        return builder.copyHeadersIfAbsent(mappedHeaders).build();
    }

    protected Object extractPayload(javax.jms.Message message) throws JMSException {
        return this.payloadConverter.fromMessage(message);
    }
}

