/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.lang;

import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.jvnet.jaxb2_commons.lang.DefaultEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBEqualsStrategy
extends DefaultEqualsStrategy {
    public static EqualsStrategy INSTANCE = new JAXBEqualsStrategy();

    @Override
    protected boolean equalsInternal(ObjectLocator leftLocator, ObjectLocator rightLocator, Object lhs, Object rhs) {
        if (lhs instanceof JAXBElement && rhs instanceof JAXBElement) {
            JAXBElement left = (JAXBElement)lhs;
            JAXBElement right = (JAXBElement)rhs;
            return this.equalsInternal(leftLocator, rightLocator, left, right);
        }
        if (lhs instanceof List && rhs instanceof List) {
            List left = (List)lhs;
            List right = (List)rhs;
            return this.equalsInternal(leftLocator, rightLocator, left, right);
        }
        return super.equalsInternal(leftLocator, rightLocator, lhs, rhs);
    }

    protected boolean equalsInternal(ObjectLocator leftLocator, ObjectLocator rightLocator, List<?> left, List<?> right) {
        Iterator<?> e1 = left.iterator();
        Iterator<?> e2 = right.iterator();
        int index = 0;
        while (e1.hasNext() && e2.hasNext()) {
            Object o1 = e1.next();
            Object o2 = e2.next();
            if (!(o1 != null ? this.equals((ObjectLocator)LocatorUtils.item(leftLocator, index, o1), (ObjectLocator)LocatorUtils.item(rightLocator, index, o2), o1, o2) : o2 == null)) {
                return false;
            }
            ++index;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    protected boolean equalsInternal(ObjectLocator leftLocator, ObjectLocator rightLocator, JAXBElement<?> left, JAXBElement<?> right) {
        return this.equals((ObjectLocator)LocatorUtils.property(leftLocator, "name", left.getName()), (ObjectLocator)LocatorUtils.property(rightLocator, "name", right.getName()), left.getName(), right.getName()) && this.equals((ObjectLocator)LocatorUtils.property(leftLocator, "value", left.getValue()), (ObjectLocator)LocatorUtils.property(rightLocator, "name", right.getValue()), left.getValue(), right.getValue());
    }
}

