/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jms.pool;

import jakarta.jms.JMSException;
import jakarta.jms.MessageProducer;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.Session;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;

public class SessionHolder {
    private final Session session;
    private volatile MessageProducer producer;
    private volatile TopicPublisher publisher;
    private volatile QueueSender sender;

    public SessionHolder(Session session) {
        this.session = session;
    }

    public void close() throws JMSException {
        try {
            this.session.close();
        }
        finally {
            this.producer = null;
            this.publisher = null;
            this.sender = null;
        }
    }

    public Session getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageProducer getOrCreateProducer() throws JMSException {
        if (this.producer == null) {
            SessionHolder sessionHolder = this;
            synchronized (sessionHolder) {
                if (this.producer == null) {
                    this.producer = this.session.createProducer(null);
                }
            }
        }
        return this.producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicPublisher getOrCreatePublisher() throws JMSException {
        if (this.publisher == null) {
            SessionHolder sessionHolder = this;
            synchronized (sessionHolder) {
                if (this.publisher == null) {
                    this.publisher = ((TopicSession)this.session).createPublisher(null);
                }
            }
        }
        return this.publisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueSender getOrCreateSender() throws JMSException {
        if (this.sender == null) {
            SessionHolder sessionHolder = this;
            synchronized (sessionHolder) {
                if (this.sender == null) {
                    this.sender = ((QueueSession)this.session).createSender(null);
                }
            }
        }
        return this.sender;
    }

    public String toString() {
        return this.session.toString();
    }
}

