/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.maven.plugin.andromdapp.eclipse;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.andromda.core.common.ResourceUtils;
import org.andromda.maven.plugin.andromdapp.eclipse.EclipseWriter;
import org.andromda.maven.plugin.andromdapp.eclipse.OrArtifactFilter;
import org.andromda.maven.plugin.andromdapp.eclipse.Variable;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class ClasspathWriter
extends EclipseWriter {
    private static final String VAR_PREFIX = "var:";
    private static final String DRIVE_PATTERN = ".*:";

    public ClasspathWriter(MavenProject project, Log logger) {
        super(project, logger);
    }

    public void write(List<MavenProject> projects, String repositoryVariableName, ArtifactFactory artifactFactory, ArtifactResolver artifactResolver, ArtifactRepository localRepository, ArtifactMetadataSource artifactMetadataSource, Set<String> classpathArtifactTypes, List<ArtifactRepository> remoteRepositories, boolean resolveTransitiveDependencies, Variable[] variables, String merge) throws Exception {
        String rootDirectory = ResourceUtils.normalizePath((String)this.project.getBasedir().toString());
        File classpathFile = new File(rootDirectory, ".classpath");
        FileWriter fileWriter = new FileWriter(classpathFile);
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)fileWriter);
        writer.startElement("classpath");
        LinkedHashSet<String> projectArtifactIds = new LinkedHashSet<String>();
        for (MavenProject project : projects) {
            Artifact projectArtifact = artifactFactory.createArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion(), null, project.getPackaging());
            projectArtifactIds.add(projectArtifact.getId());
        }
        this.writeSourceRoots(this.project, rootDirectory, (XMLWriter)writer);
        LinkedHashSet<Artifact> allArtifacts = new LinkedHashSet<Artifact>(this.project.createArtifacts(artifactFactory, null, null));
        for (MavenProject project : projects) {
            this.writeSourceRoots(project, rootDirectory, (XMLWriter)writer);
            Set artifacts = project.createArtifacts(artifactFactory, null, null);
            for (Artifact artifact : artifacts) {
                if (!projectArtifactIds.contains(artifact.getId()) && !project.getGroupId().equals(artifact.getGroupId())) {
                    artifactResolver.resolve(artifact, project.getRemoteArtifactRepositories(), localRepository);
                    allArtifacts.add(artifact);
                    continue;
                }
                allArtifacts.add(artifact);
            }
        }
        for (MavenProject project : projects) {
            Artifact projectArtifact = project.getArtifact();
            if (projectArtifact == null) continue;
            Iterator artifactIterator = allArtifacts.iterator();
            while (artifactIterator.hasNext()) {
                Artifact artifact;
                artifact = (Artifact)artifactIterator.next();
                String projectId = projectArtifact.getArtifactId();
                String projectGroupId = projectArtifact.getGroupId();
                String artifactId = artifact.getArtifactId();
                String groupId = artifact.getGroupId();
                if (!artifactId.equals(projectId) || !groupId.equals(projectGroupId)) continue;
                artifactIterator.remove();
            }
        }
        if (resolveTransitiveDependencies) {
            Artifact rootProjectArtifact = artifactFactory.createArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), null, this.project.getPackaging());
            OrArtifactFilter filter = new OrArtifactFilter();
            filter.add((ArtifactFilter)new ScopeArtifactFilter("compile"));
            filter.add((ArtifactFilter)new ScopeArtifactFilter("provided"));
            filter.add((ArtifactFilter)new ScopeArtifactFilter("test"));
            ArtifactResolutionResult result = artifactResolver.resolveTransitively(allArtifacts, rootProjectArtifact, localRepository, remoteRepositories, artifactMetadataSource, (ArtifactFilter)filter);
            allArtifacts.clear();
            allArtifacts.addAll(result.getArtifacts());
        }
        ArrayList<String> artifactPathList = new ArrayList<String>();
        for (Artifact artifact : allArtifacts) {
            if (!classpathArtifactTypes.contains(artifact.getType())) continue;
            File artifactFile = artifact.getFile();
            String artifactPath = ResourceUtils.normalizePath((String)artifactFile.toString());
            String path = StringUtils.replace((String)artifactPath, (String)ResourceUtils.normalizePath((String)localRepository.getBasedir()), (String)(VAR_PREFIX + repositoryVariableName));
            if (path.equals(artifactPath) && variables != null) {
                for (Variable variable : variables) {
                    String name = StringUtils.trimToEmpty((String)variable.getName());
                    String value = StringUtils.trimToEmpty((String)variable.getValue());
                    path = StringUtils.replace((String)path, (String)value, (String)(VAR_PREFIX + name));
                }
            }
            artifactPathList.add(path);
        }
        Collections.sort(artifactPathList);
        LinkedHashSet artifactPaths = new LinkedHashSet(artifactPathList);
        for (String path : artifactPaths) {
            if (path.startsWith(VAR_PREFIX)) {
                this.writeClasspathEntry((XMLWriter)writer, "var", path.split(VAR_PREFIX)[1]);
                continue;
            }
            if (path.startsWith(rootDirectory)) {
                path = StringUtils.replace((String)path, (String)(rootDirectory + '/'), (String)"");
            }
            this.writeClasspathEntry((XMLWriter)writer, "lib", path);
        }
        this.writeClasspathEntry((XMLWriter)writer, "con", "org.eclipse.jdt.launching.JRE_CONTAINER");
        String outputPath = StringUtils.replace((String)ResourceUtils.normalizePath((String)this.project.getBuild().getOutputDirectory()), (String)rootDirectory, (String)"");
        if (outputPath.startsWith("/")) {
            outputPath = outputPath.substring(1, outputPath.length());
        }
        this.writeClasspathEntry((XMLWriter)writer, "output", outputPath);
        if (StringUtils.isNotBlank((String)merge)) {
            writer.writeMarkup(merge);
        }
        writer.endElement();
        this.logger.info((CharSequence)("Classpath file written --> '" + classpathFile + '\''));
        IOUtil.close((Writer)fileWriter);
    }

    private void writeSourceRoots(MavenProject project, String rootDirectory, XMLWriter writer) {
        rootDirectory = rootDirectory.replaceFirst(DRIVE_PATTERN, "");
        Iterator sourceIterator = project.getCompileSourceRoots().iterator();
        while (sourceIterator.hasNext()) {
            String sourceRootPath;
            String sourceRoot = ResourceUtils.normalizePath((String)((String)sourceIterator.next())).replaceFirst(DRIVE_PATTERN, "");
            if (!new File(sourceRoot).isDirectory() || !(sourceRootPath = StringUtils.replace((String)sourceRoot, (String)rootDirectory, (String)"")).startsWith("/")) continue;
            sourceRootPath = sourceRootPath.substring(1, sourceRootPath.length());
            this.writeClasspathEntry(writer, "src", sourceRootPath);
        }
    }

    private void writeClasspathEntry(XMLWriter writer, String kind, String path) {
        writer.startElement("classpathentry");
        writer.addAttribute("kind", kind);
        writer.addAttribute("path", path);
        writer.endElement();
    }
}

