/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.maven.plugin.andromdapp;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.andromda.core.common.ResourceUtils;
import org.andromda.maven.plugin.andromdapp.eclipse.ClasspathWriter;
import org.andromda.maven.plugin.andromdapp.eclipse.ProjectWriter;
import org.andromda.maven.plugin.andromdapp.eclipse.Variable;
import org.andromda.maven.plugin.andromdapp.utils.ProjectUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class EclipseMojo
extends AbstractMojo {
    private MavenSession session;
    private MavenProject project;
    private static final String POM_FILE_NAME = "pom.xml";
    private String[] includes = new String[]{"*/**/pom.xml"};
    private String excludePoms;
    private String[] excludes = new String[0];
    private MavenProjectBuilder projectBuilder;
    private String repositoryVariableName = "M2_REPO";
    private ArtifactFactory artifactFactory;
    private ArtifactResolver artifactResolver;
    protected ArtifactRepository localRepository;
    protected Variable[] variables;
    private ArtifactMetadataSource artifactMetadataSource;
    private Set<String> classpathArtifactTypes = new LinkedHashSet<String>(Arrays.asList("jar", "ejb"));
    private boolean resolveTransitiveDependencies = true;
    private String classpathMerge;
    private boolean skipProcessing = false;
    private List<MavenProject> projects = new ArrayList<MavenProject>();
    private static final String MULTI_SOURCE_PLUGIN_ARTIFACT_ID = "build-helper-maven-plugin";
    private MavenProject rootProject;

    public void execute() throws MojoExecutionException {
        if (!this.skipProcessing) {
            try {
                MavenProject rootProject = this.getRootProject();
                ProjectWriter projectWriter = new ProjectWriter(rootProject, this.getLog());
                projectWriter.write();
                Map<MavenProject, Collection<String>> originalCompileSourceRoots = this.collectProjectCompileSourceRoots();
                List<MavenProject> projects = this.collectProjects();
                this.processCompileSourceRoots(projects);
                ClasspathWriter classpathWriter = new ClasspathWriter(rootProject, this.getLog());
                classpathWriter.write(projects, this.repositoryVariableName, this.artifactFactory, this.artifactResolver, this.localRepository, this.artifactMetadataSource, this.classpathArtifactTypes, this.project.getRemoteArtifactRepositories(), this.resolveTransitiveDependencies, this.variables, this.classpathMerge);
                for (MavenProject project : projects) {
                    project.getCompileSourceRoots().clear();
                    project.getCompileSourceRoots().addAll(originalCompileSourceRoots.get(project));
                }
            }
            catch (Throwable throwable) {
                throw new MojoExecutionException("Error creating eclipse configuration", throwable);
            }
        }
    }

    private Map<MavenProject, Collection<String>> collectProjectCompileSourceRoots() throws Exception {
        LinkedHashMap<MavenProject, Collection<String>> sourceRoots = new LinkedHashMap<MavenProject, Collection<String>>();
        for (MavenProject project : this.collectProjects()) {
            sourceRoots.put(project, new ArrayList(project.getCompileSourceRoots()));
        }
        return sourceRoots;
    }

    private List<MavenProject> collectProjects() throws Exception {
        if (this.projects.isEmpty()) {
            List<File> poms = this.getPoms();
            for (File pom : poms) {
                try {
                    MavenProject project = ProjectUtils.getProject(this.projectBuilder, this.session, pom, this.getLog());
                    if (project != null) {
                        this.getLog().info((CharSequence)("found project " + project.getId()));
                        this.projects.add(project);
                        continue;
                    }
                    if (!this.getLog().isWarnEnabled()) continue;
                    this.getLog().warn((CharSequence)("Could not load project from pom: " + pom + " - ignoring"));
                }
                catch (ProjectBuildingException exception) {
                    throw new MojoExecutionException("Error loading " + pom, (Exception)((Object)exception));
                }
            }
        }
        return this.projects;
    }

    private void processCompileSourceRoots(List<MavenProject> projects) throws Exception {
        for (MavenProject project : projects) {
            LinkedHashSet<String> compileSourceRoots = new LinkedHashSet<String>(project.getCompileSourceRoots());
            compileSourceRoots.addAll(this.getExtraSourceDirectories(project));
            String testSourceDirectory = project.getBuild().getTestSourceDirectory();
            if (StringUtils.isNotBlank((String)testSourceDirectory)) {
                compileSourceRoots.add(testSourceDirectory);
            }
            project.getCompileSourceRoots().clear();
            project.getCompileSourceRoots().addAll(compileSourceRoots);
        }
    }

    private List<String> getExtraSourceDirectories(MavenProject project) {
        PluginManagement pluginManagement;
        ArrayList<String> sourceDirectories = new ArrayList<String>();
        Build build = project.getBuild();
        if (build != null && (pluginManagement = build.getPluginManagement()) != null && !pluginManagement.getPlugins().isEmpty()) {
            int childCount;
            Xpp3Dom directories;
            Xpp3Dom configuration;
            Plugin multiSourcePlugin = null;
            for (Plugin plugin : pluginManagement.getPlugins()) {
                if (!MULTI_SOURCE_PLUGIN_ARTIFACT_ID.equals(plugin.getArtifactId())) continue;
                multiSourcePlugin = plugin;
                break;
            }
            if ((configuration = this.getConfiguration(multiSourcePlugin)) != null && configuration.getChildCount() > 0 && (directories = configuration.getChild(0)) != null && (childCount = directories.getChildCount()) > 0) {
                String baseDirectory = ResourceUtils.normalizePath((String)(ObjectUtils.toString((Object)project.getBasedir()) + '/'));
                Xpp3Dom[] children = directories.getChildren();
                for (int ctr = 0; ctr < childCount; ++ctr) {
                    String directoryValue;
                    Xpp3Dom child = children[ctr];
                    if (child == null || (directoryValue = ResourceUtils.normalizePath((String)child.getValue())) == null) continue;
                    if (!directoryValue.startsWith(baseDirectory)) {
                        directoryValue = ResourceUtils.normalizePath((String)(baseDirectory + directoryValue.trim()));
                    }
                    sourceDirectories.add(directoryValue);
                }
            }
        }
        return sourceDirectories;
    }

    private Xpp3Dom getConfiguration(Plugin plugin) {
        Xpp3Dom configuration = null;
        if (plugin != null) {
            if (plugin.getConfiguration() != null) {
                configuration = (Xpp3Dom)plugin.getConfiguration();
            } else {
                List executions = plugin.getExecutions();
                if (executions != null && !executions.isEmpty()) {
                    PluginExecution execution = (PluginExecution)plugin.getExecutions().iterator().next();
                    configuration = (Xpp3Dom)execution.getConfiguration();
                }
            }
        }
        return configuration;
    }

    private MavenProject getRootProject() throws MojoExecutionException, ArtifactResolutionException, ArtifactNotFoundException {
        if (this.rootProject == null) {
            MavenProject firstParent = this.project.getParent();
            File rootFile = this.project.getFile();
            if (firstParent != null && firstParent.getFile() != null) {
                this.rootProject = firstParent;
                rootFile = new File(rootFile.getParentFile().getParentFile(), POM_FILE_NAME);
                while (this.rootProject.getParent() != null && this.rootProject.getParent().getFile() != null) {
                    this.rootProject = this.rootProject.getParent();
                    rootFile = new File(rootFile.getParentFile().getParentFile(), POM_FILE_NAME);
                }
                if (this.rootProject != null && this.rootProject.getFile() == null && rootFile.exists()) {
                    this.rootProject.setFile(rootFile);
                }
            } else {
                this.rootProject = this.project;
            }
        }
        return this.rootProject;
    }

    private List<File> getPoms() throws Exception {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.getRootProject().getBasedir());
        scanner.setIncludes(this.includes);
        ArrayList<String> excludes = new ArrayList<String>(Arrays.asList(this.excludes));
        if (this.excludePoms != null) {
            excludes.addAll(Arrays.asList(this.excludePoms.split(",")));
        }
        scanner.setExcludes(excludes.toArray(new String[excludes.size()]));
        scanner.scan();
        ArrayList<File> poms = new ArrayList<File>();
        for (int ctr = 0; ctr < scanner.getIncludedFiles().length; ++ctr) {
            File file = new File(this.getRootProject().getBasedir(), scanner.getIncludedFiles()[ctr]);
            if (!file.exists()) continue;
            poms.add(file);
        }
        return poms;
    }
}

