/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.java;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;

public class JavaUtils {
    public static final char NAMESPACE_DELIMITER = '.';
    private static FastDateFormat df = FastDateFormat.getInstance((String)"MM/dd/yyyy HH:mm:ssZ");

    public static String reversePackage(String packageName) {
        return StringUtils.reverseDelimited((String)packageName, (char)'.');
    }

    public static String getDate(String format) {
        if (df == null || !format.equals(df.getPattern())) {
            df = FastDateFormat.getInstance((String)format);
        }
        return df.format(new Date());
    }

    public static String getDate() {
        return df.format(new Date());
    }

    public static String getJDKVersion() {
        String version = "1.6";
        String classVersion = System.getProperty("java.class.version", "44.0");
        if ("50.0".compareTo(classVersion) > 0 && "49.0".compareTo(classVersion) <= 0) {
            version = "1.5";
        } else if ("52.0".compareTo(classVersion) > 0 && "51.0".compareTo(classVersion) <= 0) {
            version = "1.7";
        } else if ("49.0".compareTo(classVersion) > 0 && "48.0".compareTo(classVersion) <= 0) {
            version = "1.4";
        } else if ("48.0".compareTo(classVersion) > 0 && "47.0".compareTo(classVersion) <= 0) {
            version = "1.3";
        } else if ("47.0".compareTo(classVersion) > 0 && "46.0".compareTo(classVersion) <= 0) {
            version = "1.2";
        } else if ("46.0".compareTo(classVersion) > 0 && "45.0".compareTo(classVersion) <= 0) {
            version = "1.2";
        }
        return version;
    }
}

