/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.hibernate.metafacades;

import org.andromda.cartridges.hibernate.HibernateProfile;
import org.andromda.cartridges.hibernate.metafacades.HibernateAssociationLogic;
import org.apache.commons.lang.StringUtils;

public class HibernateAssociationLogicImpl
extends HibernateAssociationLogic {
    private static final long serialVersionUID = 34L;
    private static final String HIBERNATE_ASSOCIATION_CACHE = "hibernateAssociationCache";

    public HibernateAssociationLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    @Override
    protected String handleGetHibernateCacheType() {
        String cacheType = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_ASSOCIATION_CACHE);
        if (StringUtils.isBlank((String)cacheType)) {
            cacheType = String.valueOf(this.getConfiguredProperty(HIBERNATE_ASSOCIATION_CACHE));
        }
        return StringUtils.trimToEmpty((String)cacheType);
    }

    @Override
    protected int handleGetEhCacheMaxElementsInMemory() {
        String maxElements = null;
        maxElements = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_EHCACHE_MAX_ELEMENTS);
        if (StringUtils.isBlank((String)maxElements)) {
            maxElements = (String)this.getConfiguredProperty("ehCacheMaxElementsInMemory");
        }
        return Integer.parseInt(maxElements);
    }

    @Override
    protected boolean handleIsEhCacheEternal() {
        String eternal = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_EHCACHE_ETERNAL);
        if (StringUtils.isBlank((String)eternal)) {
            eternal = (String)this.getConfiguredProperty("ehCacheEternal");
        }
        return Boolean.valueOf(eternal);
    }

    @Override
    protected int handleGetEhCacheTimeToIdleSeconds() {
        String timeToIdle = null;
        timeToIdle = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_EHCACHE_TIME_TO_IDLE);
        if (StringUtils.isBlank((String)timeToIdle)) {
            timeToIdle = (String)this.getConfiguredProperty("ehCacheTimeToIdleSeconds");
        }
        return Integer.parseInt(timeToIdle);
    }

    @Override
    protected int handleGetEhCacheTimeToLiveSeconds() {
        String timeToLive = null;
        timeToLive = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_EHCACHE_TIME_TO_LIVE);
        if (StringUtils.isBlank((String)timeToLive)) {
            timeToLive = (String)this.getConfiguredProperty("ehCacheTimeToLiveSeconds");
        }
        return Integer.parseInt(timeToLive);
    }

    @Override
    protected boolean handleIsEhCacheOverflowToDisk() {
        String eternal = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_EHCACHE_OVERFLOW_TO_DISK);
        if (StringUtils.isBlank((String)eternal)) {
            eternal = (String)this.getConfiguredProperty("ehCacheOverflowToDisk");
        }
        return Boolean.valueOf(eternal);
    }

    @Override
    protected boolean handleIsHibernateCacheDistributed() {
        String distributed = (String)this.getConfiguredProperty("hibernateEnableDistributedCache");
        boolean distributedCachingEnabled = Boolean.valueOf(StringUtils.trimToEmpty((String)distributed));
        if (distributedCachingEnabled) {
            String entityCacheDistributed = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_ASSOCIATIONCACHE_DISTRIBUTED);
            return Boolean.valueOf(StringUtils.trimToEmpty((String)entityCacheDistributed));
        }
        return false;
    }
}

