package com.formos.tapestry.testify.internal;

import org.apache.tapestry5.internal.services.ComponentClassCache;
import org.apache.tapestry5.internal.services.DefaultInjectionProvider;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.services.MasterObjectProvider;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.services.transform.InjectionProvider2;

/**
 * An {@link InjectionProvider2} that replaces the usual default provider.
 */
public class TestifyDefaultInjectionProvider implements InjectionProvider2 {
    private final DefaultInjectionProvider defaultInjectionProvider;

    public TestifyDefaultInjectionProvider(MasterObjectProvider masterObjectProvider, ObjectLocator locator, ComponentClassCache classCache) {
        defaultInjectionProvider = new DefaultInjectionProvider(masterObjectProvider, locator, classCache);
    }

    public boolean provideInjection(PlasticField field, ObjectLocator locator, MutableComponentModel componentModel) {
    	if (ForComponentsInjectionProvider.canHandle(field)) {
    		return false;
    	} else {
    		return defaultInjectionProvider.provideInjection(field, locator, componentModel);
    	}
    }
}
