/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xpath;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionResolver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.xpath.XPathFunctionCall;

public class XPathFunctionLibrary
implements FunctionLibrary {
    private XPathFunctionResolver resolver;

    public void setXPathFunctionResolver(XPathFunctionResolver resolver) {
        this.resolver = resolver;
    }

    public XPathFunctionResolver getXPathFunctionResolver() {
        return this.resolver;
    }

    @Override
    public Expression bind(SymbolicName.F functionName, Expression[] staticArgs, StaticContext env, List<String> reasons) {
        if (this.resolver == null) {
            return null;
        }
        StructuredQName qn = functionName.getComponentName();
        QName name = new QName(qn.getURI(), qn.getLocalPart());
        XPathFunction function = this.resolver.resolveFunction(name, functionName.getArity());
        if (function == null) {
            return null;
        }
        XPathFunctionCall fc = new XPathFunctionCall(qn, function);
        fc.setArguments(staticArgs);
        return fc;
    }

    @Override
    public boolean isAvailable(SymbolicName.F functionName) {
        return this.resolver != null && this.resolver.resolveFunction(new QName(functionName.getComponentName().getURI(), functionName.getComponentName().getLocalPart()), functionName.getArity()) != null;
    }

    @Override
    public FunctionLibrary copy() {
        XPathFunctionLibrary xfl = new XPathFunctionLibrary();
        xfl.resolver = this.resolver;
        return xfl;
    }
}

