/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.DocumentOrderIterator;
import net.sf.saxon.expr.sort.LocalOrderComparer;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.trans.KeyDefinitionSet;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class Idref
extends SystemFunction {
    @Override
    public int getSpecialProperties(Expression[] arguments) {
        int prop = 25296896;
        if (this.getArity() == 1 || arguments[1].hasSpecialProperty(65536)) {
            prop |= 0x10000;
        }
        return prop;
    }

    public static SequenceIterator<NodeInfo> getIdrefMultiple(TreeInfo doc, SequenceIterator<StringValue> keys, XPathContext context) throws XPathException {
        IdrefMappingFunction map = new IdrefMappingFunction();
        map.document = doc;
        map.keyContext = context;
        map.keyManager = context.getController().getExecutable().getTopLevelPackage().getKeyManager();
        map.keySet = map.keyManager.getKeyDefinitionSet(StandardNames.getStructuredQName(562));
        MappingIterator<StringValue, NodeInfo> allValues = new MappingIterator<StringValue, NodeInfo>(keys, map);
        return new DocumentOrderIterator(allValues, LocalOrderComparer.getInstance());
    }

    @Override
    public Sequence<?> call(XPathContext context, Sequence[] arguments) throws XPathException {
        NodeInfo start = arguments.length == 1 ? this.getContextNode(context) : (NodeInfo)arguments[1].head();
        NodeInfo arg2 = start.getRoot();
        if (arg2.getNodeKind() != 9) {
            throw new XPathException("In the idref() function, the tree being searched must be one whose root is a document node", "FODC0001", context);
        }
        return SequenceTool.toLazySequence(Idref.getIdrefMultiple(arg2.getTreeInfo(), arguments[0].iterate(), context));
    }

    private static class IdrefMappingFunction
    implements MappingFunction<StringValue, NodeInfo> {
        public TreeInfo document;
        public XPathContext keyContext;
        public KeyManager keyManager;
        public KeyDefinitionSet keySet;

        private IdrefMappingFunction() {
        }

        @Override
        public SequenceIterator<NodeInfo> map(StringValue item) throws XPathException {
            return this.keyManager.selectByKey(this.keySet, this.document, item, this.keyContext);
        }
    }
}

