/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import proguard.io.DataEntry;
import proguard.io.DataEntryWriter;
import proguard.io.Finisher;

public class DirectoryWriter
implements DataEntryWriter {
    private final File baseFile;
    private final boolean isFile;
    private File currentFile;
    private OutputStream currentOutputStream;
    private Finisher currentFinisher;

    public DirectoryWriter(File baseFile, boolean isFile) {
        this.baseFile = baseFile;
        this.isFile = isFile;
    }

    public boolean createDirectory(DataEntry dataEntry) throws IOException {
        File directory;
        if (!this.isFile && this.currentFile != null) {
            this.closeEntry();
        }
        if (!(directory = this.getFile(dataEntry)).exists() && !directory.mkdirs()) {
            throw new IOException("Can't create directory [" + directory.getPath() + "]");
        }
        return true;
    }

    public OutputStream getOutputStream(DataEntry dataEntry) throws IOException {
        return this.getOutputStream(dataEntry, null);
    }

    public OutputStream getOutputStream(DataEntry dataEntry, Finisher finisher) throws IOException {
        File file = this.getFile(dataEntry);
        if (!this.isFile && this.currentFile != null && !this.currentFile.equals(file)) {
            this.closeEntry();
        }
        if (this.currentOutputStream == null) {
            File parentDirectory = file.getParentFile();
            if (parentDirectory != null && !parentDirectory.exists() && !parentDirectory.mkdirs()) {
                throw new IOException("Can't create directory [" + parentDirectory.getPath() + "]");
            }
            this.currentOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            this.currentFinisher = finisher;
            this.currentFile = file;
        }
        return this.currentOutputStream;
    }

    public void close() throws IOException {
        this.closeEntry();
    }

    private File getFile(DataEntry dataEntry) {
        return this.isFile ? this.baseFile : new File(this.baseFile, dataEntry.getName().replace('/', File.separatorChar));
    }

    private void closeEntry() throws IOException {
        if (this.currentOutputStream != null) {
            if (this.currentFinisher != null) {
                this.currentFinisher.finish();
                this.currentFinisher = null;
            }
            this.currentOutputStream.close();
            this.currentOutputStream = null;
            this.currentFile = null;
        }
    }
}

