/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.editor.CodeAttributeComposer;
import proguard.classfile.editor.ConstantAdder;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;

public class InstructionAdder
extends SimplifiedVisitor
implements InstructionVisitor {
    private final ConstantAdder constantAdder;
    private final CodeAttributeComposer codeAttributeComposer;

    public InstructionAdder(ProgramClass targetClass, CodeAttributeComposer targetComposer) {
        this.constantAdder = new ConstantAdder(targetClass);
        this.codeAttributeComposer = targetComposer;
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        this.codeAttributeComposer.appendInstruction(offset, instruction);
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        ConstantInstruction newConstantInstruction = new ConstantInstruction(constantInstruction.opcode, this.constantAdder.addConstant(clazz, constantInstruction.constantIndex), constantInstruction.constant);
        this.codeAttributeComposer.appendInstruction(offset, newConstantInstruction);
    }
}

