/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.mask;

import ch.qos.logback.core.spi.LifeCycle;
import com.fasterxml.jackson.core.JsonGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.logstash.logback.decorate.JsonGeneratorDecorator;
import net.logstash.logback.mask.FieldMasker;
import net.logstash.logback.mask.FieldNameBasedFieldMasker;
import net.logstash.logback.mask.MaskingJsonGenerator;
import net.logstash.logback.mask.PathBasedFieldMasker;
import net.logstash.logback.mask.RegexValueMasker;
import net.logstash.logback.mask.ValueMasker;
import net.logstash.logback.util.StringUtils;

public class MaskingJsonGeneratorDecorator
implements JsonGeneratorDecorator,
LifeCycle {
    private final PathMask pathsWithDefaultMask = new PathMask();
    private final List<PathMaskSupplier> pathMaskSuppliers = new ArrayList<PathMaskSupplier>();
    private final List<FieldMasker> fieldMaskers = new ArrayList<FieldMasker>();
    private final ValueMask valuesWithDefaultMask = new ValueMask();
    private final List<ValueMaskSupplier> valueMaskSuppliers = new ArrayList<ValueMaskSupplier>();
    private final List<ValueMasker> valueMaskers = new ArrayList<ValueMasker>();
    private JsonGeneratorDecorator delegate;
    private boolean started;

    public synchronized boolean isStarted() {
        return this.started;
    }

    public synchronized void start() {
        if (!this.started) {
            List<FieldMasker> effectiveFieldMaskers = this.getEffectiveFieldMaskers();
            List<ValueMasker> effectiveValueMaskers = this.getEffectiveValueMaskers();
            this.delegate = effectiveFieldMaskers.isEmpty() && effectiveValueMaskers.isEmpty() ? generator -> generator : generator -> new MaskingJsonGenerator(generator, effectiveFieldMaskers, effectiveValueMaskers);
            this.started = true;
        }
    }

    public synchronized void stop() {
        this.started = false;
    }

    private List<FieldMasker> getEffectiveFieldMaskers() {
        HashMap fieldNamesByMask = new HashMap();
        ArrayList pathFieldMaskers = new ArrayList();
        Stream.concat(Stream.of(this.pathsWithDefaultMask), this.pathMaskSuppliers.stream().map(Supplier::get)).forEach(pathMask -> ((PathMask)pathMask).paths.forEach(path -> {
            String mask = ((PathMask)pathMask).mask;
            if (PathBasedFieldMasker.isSingleFieldName(path)) {
                fieldNamesByMask.computeIfAbsent(mask, r -> new HashSet()).add(PathBasedFieldMasker.unescapeJsonPointerToken(path));
            } else {
                pathFieldMaskers.add(new PathBasedFieldMasker((String)path, mask));
            }
        }));
        return Collections.unmodifiableList(Stream.concat(fieldNamesByMask.entrySet().stream().map(entry -> new FieldNameBasedFieldMasker((Set)entry.getValue(), entry.getKey())), Stream.concat(pathFieldMaskers.stream(), this.fieldMaskers.stream())).collect(Collectors.toList()));
    }

    private List<ValueMasker> getEffectiveValueMaskers() {
        return Collections.unmodifiableList(Stream.concat(Stream.concat(Stream.of(this.valuesWithDefaultMask), this.valueMaskSuppliers.stream().map(Supplier::get)).flatMap(valueMask -> ((ValueMask)valueMask).values.stream().map(value -> new RegexValueMasker((String)value, (Object)((ValueMask)valueMask).mask))), this.valueMaskers.stream()).collect(Collectors.toList()));
    }

    @Override
    public JsonGenerator decorate(JsonGenerator generator) {
        return this.delegate.decorate(generator);
    }

    public void setDefaultMask(String defaultMask) {
        Objects.requireNonNull(defaultMask, "defaultMask must not be null");
        this.valuesWithDefaultMask.setMask(defaultMask);
        this.pathsWithDefaultMask.setMask(defaultMask);
    }

    public void addPath(String pathToMask) {
        this.pathsWithDefaultMask.addPath(pathToMask);
    }

    public void addPaths(String pathsToMask) {
        this.pathsWithDefaultMask.addPaths(pathsToMask);
    }

    public void addPathMask(PathMask pathMask) {
        this.addPathMaskSupplier(() -> pathMask);
    }

    public void addPathMaskSupplier(PathMaskSupplier pathMaskSupplier) {
        this.pathMaskSuppliers.add(pathMaskSupplier);
    }

    public void addFieldMasker(FieldMasker fieldMasker) {
        this.fieldMaskers.add(fieldMasker);
    }

    public void addValue(String valueToMask) {
        this.valuesWithDefaultMask.addValue(valueToMask);
    }

    public void addValues(String valuesToMask) {
        this.valuesWithDefaultMask.addValues(valuesToMask);
    }

    public void addValueMask(ValueMask valueMask) {
        this.addValueMaskSupplier(() -> valueMask);
    }

    public void addValueMaskSupplier(ValueMaskSupplier valueMaskSupplier) {
        this.valueMaskSuppliers.add(valueMaskSupplier);
    }

    public void addValueMasker(ValueMasker valueMasker) {
        this.valueMaskers.add(valueMasker);
    }

    public static class PathMask {
        private final List<String> paths = new ArrayList<String>();
        private String mask = "****";

        public PathMask() {
        }

        public PathMask(String path) {
            this(path, "****");
        }

        public PathMask(String path, String mask) {
            this(Collections.singletonList(path), mask);
        }

        public PathMask(List<String> paths) {
            this(paths, "****");
        }

        public PathMask(List<String> paths, String mask) {
            paths.forEach(this::addPath);
            this.setMask(mask);
        }

        public void addPath(String path) {
            PathBasedFieldMasker.validatePathToMask(path);
            this.paths.add(path);
        }

        public void addPaths(String paths) {
            for (String path : StringUtils.commaDelimitedListToStringArray(paths)) {
                this.addPath(path);
            }
        }

        public void setMask(String mask) {
            this.mask = Objects.requireNonNull(mask);
        }
    }

    public static class ValueMask {
        private final List<String> values = new ArrayList<String>();
        private String mask = "****";

        public ValueMask() {
        }

        public ValueMask(String values) {
            this(values, "****");
        }

        public ValueMask(String value, String mask) {
            this(Collections.singletonList(value), mask);
        }

        public ValueMask(List<String> values) {
            this(values, "****");
        }

        public ValueMask(List<String> values, String mask) {
            values.forEach(this::addValue);
            this.setMask(mask);
        }

        public void addValue(String value) {
            this.values.add(Objects.requireNonNull(value));
        }

        public void addValues(String values) {
            for (String value : StringUtils.commaDelimitedListToStringArray(values)) {
                this.addValue(value);
            }
        }

        public void setMask(String mask) {
            this.mask = Objects.requireNonNull(mask);
        }
    }

    public static interface PathMaskSupplier
    extends Supplier<PathMask> {
    }

    public static interface ValueMaskSupplier
    extends Supplier<ValueMask> {
    }
}

