/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite;

import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import ch.qos.logback.core.spi.LifeCycle;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.ref.SoftReference;
import net.logstash.logback.composite.JsonProviders;
import net.logstash.logback.decorate.JsonFactoryDecorator;
import net.logstash.logback.decorate.JsonGeneratorDecorator;
import net.logstash.logback.decorate.NullJsonFactoryDecorator;
import net.logstash.logback.decorate.NullJsonGeneratorDecorator;

public abstract class CompositeJsonFormatter<Event extends DeferredProcessingAware>
extends ContextAwareBase
implements LifeCycle {
    private final ThreadLocal<SoftReference<BufferRecycler>> recycler = new ThreadLocal<SoftReference<BufferRecycler>>(){

        @Override
        protected SoftReference<BufferRecycler> initialValue() {
            BufferRecycler bufferRecycler = new BufferRecycler();
            return new SoftReference<BufferRecycler>(bufferRecycler);
        }
    };
    private MappingJsonFactory jsonFactory;
    private JsonFactoryDecorator jsonFactoryDecorator = new NullJsonFactoryDecorator();
    private JsonGeneratorDecorator jsonGeneratorDecorator = new NullJsonGeneratorDecorator();
    private JsonProviders<Event> jsonProviders = new JsonProviders();
    private JsonEncoding encoding = JsonEncoding.UTF8;
    private boolean findAndRegisterJacksonModules = true;
    private volatile boolean started;

    public CompositeJsonFormatter(ContextAware declaredOrigin) {
        super(declaredOrigin);
    }

    public void start() {
        if (this.jsonProviders.getProviders().isEmpty()) {
            this.addError("No providers configured");
        }
        this.jsonFactory = this.createJsonFactory();
        this.jsonProviders.setJsonFactory((JsonFactory)this.jsonFactory);
        this.jsonProviders.setContext(this.context);
        this.jsonProviders.start();
        this.started = true;
    }

    public void stop() {
        this.jsonProviders.stop();
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }

    private MappingJsonFactory createJsonFactory() {
        ObjectMapper objectMapper = new ObjectMapper().disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        if (this.findAndRegisterJacksonModules) {
            objectMapper.findAndRegisterModules();
        }
        MappingJsonFactory jsonFactory = (MappingJsonFactory)objectMapper.getFactory().disable(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM);
        return this.jsonFactoryDecorator.decorate(jsonFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] writeEventAsBytes(Event event) throws IOException {
        ByteArrayBuilder outputStream = new ByteArrayBuilder(this.getBufferRecycler());
        try {
            this.writeEventToOutputStream(event, (OutputStream)outputStream);
            outputStream.flush();
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        finally {
            outputStream.release();
        }
    }

    public void writeEventToOutputStream(Event event, OutputStream outputStream) throws IOException {
        JsonGenerator generator = this.createGenerator(outputStream);
        this.writeEventToGenerator(generator, event);
    }

    public String writeEventAsString(Event event) throws IOException {
        SegmentedStringWriter writer = new SegmentedStringWriter(this.getBufferRecycler());
        JsonGenerator generator = this.createGenerator((Writer)writer);
        this.writeEventToGenerator(generator, event);
        writer.flush();
        return writer.getAndClear();
    }

    protected void writeEventToGenerator(JsonGenerator generator, Event event) throws IOException {
        if (!this.isStarted()) {
            throw new IllegalStateException("Encoding attempted before starting.");
        }
        generator.writeStartObject();
        this.jsonProviders.writeTo(generator, event);
        generator.writeEndObject();
        generator.flush();
    }

    protected void prepareForDeferredProcessing(Event event) {
        event.prepareForDeferredProcessing();
        this.jsonProviders.prepareForDeferredProcessing(event);
    }

    private JsonGenerator createGenerator(OutputStream outputStream) throws IOException {
        return this.jsonGeneratorDecorator.decorate(this.jsonFactory.createGenerator(outputStream, this.encoding));
    }

    private JsonGenerator createGenerator(Writer writer) throws IOException {
        return this.jsonGeneratorDecorator.decorate(this.jsonFactory.createGenerator(writer));
    }

    private BufferRecycler getBufferRecycler() {
        SoftReference<BufferRecycler> bufferRecyclerReference = this.recycler.get();
        BufferRecycler bufferRecycler = bufferRecyclerReference.get();
        if (bufferRecycler == null) {
            this.recycler.remove();
            return this.getBufferRecycler();
        }
        return bufferRecycler;
    }

    public JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    public JsonFactoryDecorator getJsonFactoryDecorator() {
        return this.jsonFactoryDecorator;
    }

    public void setJsonFactoryDecorator(JsonFactoryDecorator jsonFactoryDecorator) {
        this.jsonFactoryDecorator = jsonFactoryDecorator;
    }

    public JsonGeneratorDecorator getJsonGeneratorDecorator() {
        return this.jsonGeneratorDecorator;
    }

    public void setJsonGeneratorDecorator(JsonGeneratorDecorator jsonGeneratorDecorator) {
        this.jsonGeneratorDecorator = jsonGeneratorDecorator;
    }

    public JsonProviders<Event> getProviders() {
        return this.jsonProviders;
    }

    public String getEncoding() {
        return this.encoding.getJavaName();
    }

    public void setEncoding(String encodingName) {
        for (JsonEncoding encoding : JsonEncoding.values()) {
            if (!encoding.getJavaName().equals(encodingName) && !encoding.name().equals(encodingName)) continue;
            this.encoding = encoding;
            return;
        }
        throw new IllegalArgumentException("Unknown encoding " + encodingName);
    }

    public void setProviders(JsonProviders<Event> jsonProviders) {
        this.jsonProviders = jsonProviders;
    }

    public boolean isFindAndRegisterJacksonModules() {
        return this.findAndRegisterJacksonModules;
    }

    public void setFindAndRegisterJacksonModules(boolean findAndRegisterJacksonModules) {
        this.findAndRegisterJacksonModules = findAndRegisterJacksonModules;
    }
}

