/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.appender;

import ch.qos.logback.classic.pattern.ThrowableHandlingConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.net.SyslogAppenderBase;
import ch.qos.logback.core.net.SyslogOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import net.logstash.logback.appender.listener.AppenderListener;
import net.logstash.logback.composite.JsonProvider;
import net.logstash.logback.decorate.JsonFactoryDecorator;
import net.logstash.logback.decorate.JsonGeneratorDecorator;
import net.logstash.logback.fieldnames.LogstashFieldNames;
import net.logstash.logback.layout.LogstashLayout;

public class LogstashSocketAppender
extends SyslogAppenderBase<ILoggingEvent> {
    private final LogstashLayout logstashLayout = new LogstashLayout();
    private final List<AppenderListener<ILoggingEvent>> listeners = new ArrayList<AppenderListener<ILoggingEvent>>();
    private SyslogOutputStream syslogOutputStream;

    public LogstashSocketAppender() {
        this.setFacility("NEWS");
    }

    public Layout<ILoggingEvent> buildLayout() {
        this.logstashLayout.setContext(this.getContext());
        return this.logstashLayout;
    }

    public void start() {
        super.start();
        this.getLayout().start();
        this.fireAppenderStarted();
    }

    public void stop() {
        super.stop();
        this.getLayout().stop();
        this.fireAppenderStopped();
    }

    protected void append(ILoggingEvent eventObject) {
        if (!this.isStarted()) {
            return;
        }
        long startTime = System.nanoTime();
        try {
            String msg = this.getLayout().doLayout((Object)eventObject);
            if (msg == null) {
                return;
            }
            if (msg.length() > this.getMaxMessageSize()) {
                msg = msg.substring(0, this.getMaxMessageSize());
            }
            this.syslogOutputStream.write(msg.getBytes(this.getCharset()));
            this.syslogOutputStream.flush();
            this.postProcess(eventObject, (OutputStream)this.syslogOutputStream);
            this.fireEventAppended(eventObject, System.nanoTime() - startTime);
        }
        catch (IOException ioe) {
            this.addError("Failed to send diagram to " + this.getSyslogHost(), ioe);
            this.fireEventAppendFailed(eventObject, ioe);
        }
    }

    protected void fireAppenderStarted() {
        for (AppenderListener<ILoggingEvent> listener : this.listeners) {
            listener.appenderStarted((Appender<ILoggingEvent>)this);
        }
    }

    protected void fireAppenderStopped() {
        for (AppenderListener<ILoggingEvent> listener : this.listeners) {
            listener.appenderStopped((Appender<ILoggingEvent>)this);
        }
    }

    protected void fireEventAppended(ILoggingEvent event, long durationInNanos) {
        for (AppenderListener<ILoggingEvent> listener : this.listeners) {
            listener.eventAppended((Appender<ILoggingEvent>)this, event, durationInNanos);
        }
    }

    protected void fireEventAppendFailed(ILoggingEvent event, Throwable reason) {
        for (AppenderListener<ILoggingEvent> listener : this.listeners) {
            listener.eventAppendFailed((Appender<ILoggingEvent>)this, event, reason);
        }
    }

    public int getSeverityForEvent(Object eventObject) {
        return 0;
    }

    public String getHost() {
        return this.getSyslogHost();
    }

    public void setHost(String host) {
        this.setSyslogHost(host);
    }

    public void addProvider(JsonProvider<ILoggingEvent> provider) {
        this.logstashLayout.addProvider(provider);
    }

    public void setCustomFields(String customFields) {
        this.logstashLayout.setCustomFields(customFields);
    }

    public String getCustomFields() {
        return this.logstashLayout.getCustomFields().toString();
    }

    public boolean isIncludeCallerData() {
        return this.logstashLayout.isIncludeCallerData();
    }

    public void setIncludeCallerData(boolean includeCallerData) {
        this.logstashLayout.setIncludeCallerData(includeCallerData);
    }

    @Deprecated
    public boolean isIncludeCallerInfo() {
        return this.logstashLayout.isIncludeCallerInfo();
    }

    @Deprecated
    public void setIncludeCallerInfo(boolean includeCallerInfo) {
        this.logstashLayout.setIncludeCallerInfo(includeCallerInfo);
    }

    public LogstashFieldNames getFieldNames() {
        return this.logstashLayout.getFieldNames();
    }

    public void setFieldNames(LogstashFieldNames fieldNames) {
        this.logstashLayout.setFieldNames(fieldNames);
    }

    public boolean isIncludeMdc() {
        return this.logstashLayout.isIncludeMdc();
    }

    public void setIncludeMdc(boolean includeMdc) {
        this.logstashLayout.setIncludeMdc(includeMdc);
    }

    public List<String> getIncludeMdcKeyNames() {
        return this.logstashLayout.getIncludeMdcKeyNames();
    }

    public void addIncludeMdcKeyName(String includedMdcKeyName) {
        this.logstashLayout.addIncludeMdcKeyName(includedMdcKeyName);
    }

    public void setIncludeMdcKeyNames(List<String> includeMdcKeyNames) {
        this.logstashLayout.setIncludeMdcKeyNames(includeMdcKeyNames);
    }

    public List<String> getExcludeMdcKeyNames() {
        return this.logstashLayout.getExcludeMdcKeyNames();
    }

    public void addExcludeMdcKeyName(String excludedMdcKeyName) {
        this.logstashLayout.addExcludeMdcKeyName(excludedMdcKeyName);
    }

    public void setExcludeMdcKeyNames(List<String> excludeMdcKeyNames) {
        this.logstashLayout.setExcludeMdcKeyNames(excludeMdcKeyNames);
    }

    public boolean isIncludeContext() {
        return this.logstashLayout.isIncludeContext();
    }

    public void setIncludeContext(boolean includeContext) {
        this.logstashLayout.setIncludeContext(includeContext);
    }

    public boolean isIncludeStructuredArguments() {
        return this.logstashLayout.isIncludeStructuredArguments();
    }

    public void setIncludeStructuredArguments(boolean includeStructuredArguments) {
        this.logstashLayout.setIncludeStructuredArguments(includeStructuredArguments);
    }

    public boolean isIncludeNonStructuredArguments() {
        return this.logstashLayout.isIncludeNonStructuredArguments();
    }

    public void setIncludeNonStructuredArguments(boolean includeNonStructuredArguments) {
        this.logstashLayout.setIncludeNonStructuredArguments(includeNonStructuredArguments);
    }

    public String getNonStructuredArgumentsFieldPrefix() {
        return this.logstashLayout.getNonStructuredArgumentsFieldPrefix();
    }

    public void setNonStructuredArgumentsFieldPrefix(String nonStructuredArgumentsFieldPrefix) {
        this.logstashLayout.setNonStructuredArgumentsFieldPrefix(nonStructuredArgumentsFieldPrefix);
    }

    public int getShortenedLoggerNameLength() {
        return this.logstashLayout.getShortenedLoggerNameLength();
    }

    public void setShortenedLoggerNameLength(int length) {
        this.logstashLayout.setShortenedLoggerNameLength(length);
    }

    public JsonFactoryDecorator getJsonFactoryDecorator() {
        return this.logstashLayout.getJsonFactoryDecorator();
    }

    public void setJsonFactoryDecorator(JsonFactoryDecorator jsonFactoryDecorator) {
        this.logstashLayout.setJsonFactoryDecorator(jsonFactoryDecorator);
    }

    public JsonGeneratorDecorator getJsonGeneratorDecorator() {
        return this.logstashLayout.getJsonGeneratorDecorator();
    }

    public void setJsonGeneratorDecorator(JsonGeneratorDecorator jsonGeneratorDecorator) {
        this.logstashLayout.setJsonGeneratorDecorator(jsonGeneratorDecorator);
    }

    public void setFindAndRegisterJacksonModules(boolean findAndRegisterJacksonModules) {
        this.logstashLayout.setFindAndRegisterJacksonModules(findAndRegisterJacksonModules);
    }

    public String getTimeZone() {
        return this.logstashLayout.getTimeZone();
    }

    public void setTimeZone(String timeZoneId) {
        this.logstashLayout.setTimeZone(timeZoneId);
    }

    public ThrowableHandlingConverter getThrowableConverter() {
        return this.logstashLayout.getThrowableConverter();
    }

    public void setThrowableConverter(ThrowableHandlingConverter throwableConverter) {
        this.logstashLayout.setThrowableConverter(throwableConverter);
    }

    public Layout<ILoggingEvent> getPrefix() {
        return this.logstashLayout.getPrefix();
    }

    public void setPrefix(Layout<ILoggingEvent> prefix) {
        this.logstashLayout.setPrefix(prefix);
    }

    public Layout<ILoggingEvent> getSuffix() {
        return this.logstashLayout.getSuffix();
    }

    public void setSuffix(Layout<ILoggingEvent> suffix) {
        this.logstashLayout.setSuffix(suffix);
    }

    public void addListener(AppenderListener<ILoggingEvent> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(AppenderListener<ILoggingEvent> listener) {
        this.listeners.remove(listener);
    }

    public SyslogOutputStream createOutputStream() throws UnknownHostException, SocketException {
        this.syslogOutputStream = new SyslogOutputStream(this.getHost(), this.getPort());
        return this.syslogOutputStream;
    }
}

