/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.web;

import java.util.Map;
import javax.inject.Inject;
import net.hasor.dataql.DataQL;
import net.hasor.dataql.Query;
import net.hasor.dataql.QueryResult;
import net.hasor.dataway.config.DatawayUtils;
import net.hasor.dataway.config.MappingToUrl;
import net.hasor.dataway.config.Result;
import net.hasor.dataway.web.BasicController;
import net.hasor.web.annotation.Post;
import net.hasor.web.annotation.QueryParameter;
import net.hasor.web.annotation.RequestBody;
import net.hasor.web.objects.JsonRenderEngine;
import net.hasor.web.render.RenderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MappingToUrl(value="/api/perform")
@RenderType(value="json", engineType=JsonRenderEngine.class)
public class PerformController
extends BasicController {
    protected static Logger logger = LoggerFactory.getLogger(PerformController.class);
    @Inject
    private DataQL executeDataQL;

    @Post
    public Result<Map<String, Object>> doPerform(@QueryParameter(value="id") String apiId, @RequestBody Map<String, Object> requestBody) {
        if (!apiId.equalsIgnoreCase(requestBody.get("id").toString())) {
            throw new IllegalArgumentException("id Parameters of the ambiguity.");
        }
        String strCodeType = requestBody.get("codeType").toString();
        String strCodeValue = requestBody.get("codeValue").toString();
        Map strRequestBody = (Map)requestBody.get("requestBody");
        if ("sql".equalsIgnoreCase(strCodeType)) {
            strCodeValue = DatawayUtils.evalCodeValueForSQL(strCodeValue, strRequestBody);
        }
        try {
            Query dataQLQuery = this.executeDataQL.createQuery(strCodeValue);
            QueryResult queryResult = dataQLQuery.execute(strRequestBody);
            return DatawayUtils.queryResultToResult(queryResult);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return DatawayUtils.exceptionToResult(e);
        }
    }
}

