/*
 * Decompiled with CFR 0.152.
 */
package kr.motd.maven.sphinx;

import java.util.Arrays;

final class Sha256 {
    private static final int HASH_LEN = 32;
    private static final int BLOCK_LEN = 64;
    private final byte[] buf = new byte[64];
    private int bufOff;
    private long byteCount;
    private final int[] state = new int[8];
    private final int[] bufInts = new int[16];
    private final int[] w = new int[64];

    Sha256() {
        this.reset();
    }

    int getDigestLen() {
        return 32;
    }

    int getBlockLen() {
        return 64;
    }

    void reset() {
        Arrays.fill(this.buf, (byte)0);
        this.bufOff = 0;
        this.byteCount = 0L;
        this.state[0] = 1779033703;
        this.state[1] = -1150833019;
        this.state[2] = 1013904242;
        this.state[3] = -1521486534;
        this.state[4] = 1359893119;
        this.state[5] = -1694144372;
        this.state[6] = 528734635;
        this.state[7] = 1541459225;
    }

    void update(byte[] data, int offset, int length) {
        if (data == null) {
            throw new NullPointerException("Input data buffer is null");
        }
        if (offset + length > data.length) {
            throw new IllegalArgumentException("reading " + length + " bytes of input starting at offset " + offset + " will overrun end of input buffer (" + data.length + " bytes long)");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("input offset is negative (" + offset + ')');
        }
        if (length < 0) {
            throw new IllegalArgumentException("input length is negative (" + offset + ')');
        }
        this.byteCount += (long)length;
        while (this.bufOff + length >= this.buf.length) {
            int todo = this.buf.length - this.bufOff;
            System.arraycopy(data, offset, this.buf, this.bufOff, todo);
            this.transform(this.buf);
            length -= todo;
            offset += todo;
            this.bufOff = 0;
        }
        System.arraycopy(data, offset, this.buf, this.bufOff, length);
        this.bufOff += length;
    }

    void finishDigest(byte[] out, int outOffset) {
        if (out == null) {
            throw new NullPointerException("output array is null");
        }
        if (outOffset + this.getDigestLen() > out.length) {
            throw new IllegalArgumentException("writing " + this.getDigestLen() + " bytes of input starting at offset " + outOffset + " will overrun end of output buffer (" + out.length + " bytes long)");
        }
        if (outOffset < 0) {
            throw new IllegalArgumentException("output offset is negative (" + outOffset + ')');
        }
        this.buf[this.bufOff++] = -128;
        if (this.bufOff + 8 > this.buf.length) {
            Arrays.fill(this.buf, this.bufOff, this.getBlockLen(), (byte)0);
            this.transform(this.buf);
            this.bufOff = 0;
        }
        Arrays.fill(this.buf, this.bufOff, this.buf.length - 8, (byte)0);
        long bitCount = this.byteCount * 8L;
        for (int i = 0; i < 8; ++i) {
            this.buf[this.buf.length - i - 1] = (byte)bitCount;
            bitCount >>>= 8;
        }
        this.transform(this.buf);
        Sha256.int2byte(this.state, 0, out, outOffset, this.state.length);
        this.reset();
    }

    private static void byte2int(byte[] src, int srcOffset, int[] dst, int dstOffset, int numInts) {
        while (numInts-- > 0) {
            dst[dstOffset++] = src[srcOffset++] << 24 | (src[srcOffset++] & 0xFF) << 16 | (src[srcOffset++] & 0xFF) << 8 | src[srcOffset++] & 0xFF;
        }
    }

    private static void int2byte(int[] src, int srcOffset, byte[] dst, int dstOffset, int numInts) {
        int end = numInts + srcOffset;
        int j = dstOffset;
        for (int i = srcOffset; i < end; ++i) {
            int d = src[srcOffset + i];
            dst[j++] = (byte)(d >>> 24);
            dst[j++] = (byte)(d >>> 16);
            dst[j++] = (byte)(d >>> 8);
            dst[j++] = (byte)d;
        }
    }

    private static int RR(int a, int n) {
        return a >>> n | a << 32 - n;
    }

    private static int S0(int a) {
        return Sha256.RR(a, 2) ^ Sha256.RR(a, 13) ^ Sha256.RR(a, 22);
    }

    private static int S1(int a) {
        return Sha256.RR(a, 6) ^ Sha256.RR(a, 11) ^ Sha256.RR(a, 25);
    }

    private static int s0(int a) {
        return Sha256.RR(a, 7) ^ Sha256.RR(a, 18) ^ a >>> 3;
    }

    private static int s1(int a) {
        return Sha256.RR(a, 17) ^ Sha256.RR(a, 19) ^ a >>> 10;
    }

    private void transform(byte[] block) {
        Sha256.byte2int(this.buf, 0, this.bufInts, 0, 16);
        int A = this.state[0];
        int B = this.state[1];
        int C = this.state[2];
        int D = this.state[3];
        int E = this.state[4];
        int F = this.state[5];
        int G = this.state[6];
        int H = this.state[7];
        D += (H += Sha256.S1(E) + (E & (F ^ G) ^ G) + 1116352408 + this.bufInts[0]);
        H += Sha256.S0(A) + (A & B | C & (A | B));
        C += (G += Sha256.S1(D) + (D & (E ^ F) ^ F) + 1899447441 + this.bufInts[1]);
        G += Sha256.S0(H) + (H & A | B & (H | A));
        B += (F += Sha256.S1(C) + (C & (D ^ E) ^ E) + -1245643825 + this.bufInts[2]);
        F += Sha256.S0(G) + (G & H | A & (G | H));
        A += (E += Sha256.S1(B) + (B & (C ^ D) ^ D) + -373957723 + this.bufInts[3]);
        E += Sha256.S0(F) + (F & G | H & (F | G));
        H += (D += Sha256.S1(A) + (A & (B ^ C) ^ C) + 961987163 + this.bufInts[4]);
        D += Sha256.S0(E) + (E & F | G & (E | F));
        G += (C += Sha256.S1(H) + (H & (A ^ B) ^ B) + 1508970993 + this.bufInts[5]);
        C += Sha256.S0(D) + (D & E | F & (D | E));
        F += (B += Sha256.S1(G) + (G & (H ^ A) ^ A) + -1841331548 + this.bufInts[6]);
        B += Sha256.S0(C) + (C & D | E & (C | D));
        E += (A += Sha256.S1(F) + (F & (G ^ H) ^ H) + -1424204075 + this.bufInts[7]);
        A += Sha256.S0(B) + (B & C | D & (B | C));
        D += (H += Sha256.S1(E) + (E & (F ^ G) ^ G) + -670586216 + this.bufInts[8]);
        H += Sha256.S0(A) + (A & B | C & (A | B));
        C += (G += Sha256.S1(D) + (D & (E ^ F) ^ F) + 310598401 + this.bufInts[9]);
        G += Sha256.S0(H) + (H & A | B & (H | A));
        B += (F += Sha256.S1(C) + (C & (D ^ E) ^ E) + 607225278 + this.bufInts[10]);
        F += Sha256.S0(G) + (G & H | A & (G | H));
        A += (E += Sha256.S1(B) + (B & (C ^ D) ^ D) + 1426881987 + this.bufInts[11]);
        E += Sha256.S0(F) + (F & G | H & (F | G));
        H += (D += Sha256.S1(A) + (A & (B ^ C) ^ C) + 1925078388 + this.bufInts[12]);
        D += Sha256.S0(E) + (E & F | G & (E | F));
        G += (C += Sha256.S1(H) + (H & (A ^ B) ^ B) + -2132889090 + this.bufInts[13]);
        C += Sha256.S0(D) + (D & E | F & (D | E));
        F += (B += Sha256.S1(G) + (G & (H ^ A) ^ A) + -1680079193 + this.bufInts[14]);
        B += Sha256.S0(C) + (C & D | E & (C | D));
        E += (A += Sha256.S1(F) + (F & (G ^ H) ^ H) + -1046744716 + this.bufInts[15]);
        A += Sha256.S0(B) + (B & C | D & (B | C));
        this.w[0] = this.bufInts[0] + Sha256.s0(this.bufInts[1]) + this.bufInts[9] + Sha256.s1(this.bufInts[14]);
        D += (H += Sha256.S1(E) + (E & (F ^ G) ^ G) + -459576895 + this.w[0]);
        H += Sha256.S0(A) + (A & B | C & (A | B));
        this.w[1] = this.bufInts[1] + Sha256.s0(this.bufInts[2]) + this.bufInts[10] + Sha256.s1(this.bufInts[15]);
        C += (G += Sha256.S1(D) + (D & (E ^ F) ^ F) + -272742522 + this.w[1]);
        G += Sha256.S0(H) + (H & A | B & (H | A));
        this.w[2] = this.bufInts[2] + Sha256.s0(this.bufInts[3]) + this.bufInts[11] + Sha256.s1(this.w[0]);
        B += (F += Sha256.S1(C) + (C & (D ^ E) ^ E) + 264347078 + this.w[2]);
        F += Sha256.S0(G) + (G & H | A & (G | H));
        this.w[3] = this.bufInts[3] + Sha256.s0(this.bufInts[4]) + this.bufInts[12] + Sha256.s1(this.w[1]);
        A += (E += Sha256.S1(B) + (B & (C ^ D) ^ D) + 604807628 + this.w[3]);
        E += Sha256.S0(F) + (F & G | H & (F | G));
        this.w[4] = this.bufInts[4] + Sha256.s0(this.bufInts[5]) + this.bufInts[13] + Sha256.s1(this.w[2]);
        H += (D += Sha256.S1(A) + (A & (B ^ C) ^ C) + 770255983 + this.w[4]);
        D += Sha256.S0(E) + (E & F | G & (E | F));
        this.w[5] = this.bufInts[5] + Sha256.s0(this.bufInts[6]) + this.bufInts[14] + Sha256.s1(this.w[3]);
        G += (C += Sha256.S1(H) + (H & (A ^ B) ^ B) + 1249150122 + this.w[5]);
        C += Sha256.S0(D) + (D & E | F & (D | E));
        this.w[6] = this.bufInts[6] + Sha256.s0(this.bufInts[7]) + this.bufInts[15] + Sha256.s1(this.w[4]);
        F += (B += Sha256.S1(G) + (G & (H ^ A) ^ A) + 1555081692 + this.w[6]);
        B += Sha256.S0(C) + (C & D | E & (C | D));
        this.w[7] = this.bufInts[7] + Sha256.s0(this.bufInts[8]) + this.w[0] + Sha256.s1(this.w[5]);
        E += (A += Sha256.S1(F) + (F & (G ^ H) ^ H) + 1996064986 + this.w[7]);
        A += Sha256.S0(B) + (B & C | D & (B | C));
        this.w[8] = this.bufInts[8] + Sha256.s0(this.bufInts[9]) + this.w[1] + Sha256.s1(this.w[6]);
        D += (H += Sha256.S1(E) + (E & (F ^ G) ^ G) + -1740746414 + this.w[8]);
        H += Sha256.S0(A) + (A & B | C & (A | B));
        this.w[9] = this.bufInts[9] + Sha256.s0(this.bufInts[10]) + this.w[2] + Sha256.s1(this.w[7]);
        C += (G += Sha256.S1(D) + (D & (E ^ F) ^ F) + -1473132947 + this.w[9]);
        G += Sha256.S0(H) + (H & A | B & (H | A));
        this.w[10] = this.bufInts[10] + Sha256.s0(this.bufInts[11]) + this.w[3] + Sha256.s1(this.w[8]);
        B += (F += Sha256.S1(C) + (C & (D ^ E) ^ E) + -1341970488 + this.w[10]);
        F += Sha256.S0(G) + (G & H | A & (G | H));
        this.w[11] = this.bufInts[11] + Sha256.s0(this.bufInts[12]) + this.w[4] + Sha256.s1(this.w[9]);
        A += (E += Sha256.S1(B) + (B & (C ^ D) ^ D) + -1084653625 + this.w[11]);
        E += Sha256.S0(F) + (F & G | H & (F | G));
        this.w[12] = this.bufInts[12] + Sha256.s0(this.bufInts[13]) + this.w[5] + Sha256.s1(this.w[10]);
        H += (D += Sha256.S1(A) + (A & (B ^ C) ^ C) + -958395405 + this.w[12]);
        D += Sha256.S0(E) + (E & F | G & (E | F));
        this.w[13] = this.bufInts[13] + Sha256.s0(this.bufInts[14]) + this.w[6] + Sha256.s1(this.w[11]);
        G += (C += Sha256.S1(H) + (H & (A ^ B) ^ B) + -710438585 + this.w[13]);
        C += Sha256.S0(D) + (D & E | F & (D | E));
        this.w[14] = this.bufInts[14] + Sha256.s0(this.bufInts[15]) + this.w[7] + Sha256.s1(this.w[12]);
        F += (B += Sha256.S1(G) + (G & (H ^ A) ^ A) + 113926993 + this.w[14]);
        B += Sha256.S0(C) + (C & D | E & (C | D));
        this.w[15] = this.bufInts[15] + Sha256.s0(this.w[0]) + this.w[8] + Sha256.s1(this.w[13]);
        E += (A += Sha256.S1(F) + (F & (G ^ H) ^ H) + 338241895 + this.w[15]);
        A += Sha256.S0(B) + (B & C | D & (B | C));
        this.w[0] = this.w[0] + (Sha256.s0(this.w[1]) + this.w[9] + Sha256.s1(this.w[14]));
        D += (H += Sha256.S1(E) + (E & (F ^ G) ^ G) + 666307205 + this.w[0]);
        H += Sha256.S0(A) + (A & B | C & (A | B));
        this.w[1] = this.w[1] + (Sha256.s0(this.w[2]) + this.w[10] + Sha256.s1(this.w[15]));
        C += (G += Sha256.S1(D) + (D & (E ^ F) ^ F) + 773529912 + this.w[1]);
        G += Sha256.S0(H) + (H & A | B & (H | A));
        this.w[2] = this.w[2] + (Sha256.s0(this.w[3]) + this.w[11] + Sha256.s1(this.w[0]));
        B += (F += Sha256.S1(C) + (C & (D ^ E) ^ E) + 1294757372 + this.w[2]);
        F += Sha256.S0(G) + (G & H | A & (G | H));
        this.w[3] = this.w[3] + (Sha256.s0(this.w[4]) + this.w[12] + Sha256.s1(this.w[1]));
        A += (E += Sha256.S1(B) + (B & (C ^ D) ^ D) + 1396182291 + this.w[3]);
        E += Sha256.S0(F) + (F & G | H & (F | G));
        this.w[4] = this.w[4] + (Sha256.s0(this.w[5]) + this.w[13] + Sha256.s1(this.w[2]));
        H += (D += Sha256.S1(A) + (A & (B ^ C) ^ C) + 1695183700 + this.w[4]);
        D += Sha256.S0(E) + (E & F | G & (E | F));
        this.w[5] = this.w[5] + (Sha256.s0(this.w[6]) + this.w[14] + Sha256.s1(this.w[3]));
        G += (C += Sha256.S1(H) + (H & (A ^ B) ^ B) + 1986661051 + this.w[5]);
        C += Sha256.S0(D) + (D & E | F & (D | E));
        this.w[6] = this.w[6] + (Sha256.s0(this.w[7]) + this.w[15] + Sha256.s1(this.w[4]));
        F += (B += Sha256.S1(G) + (G & (H ^ A) ^ A) + -2117940946 + this.w[6]);
        B += Sha256.S0(C) + (C & D | E & (C | D));
        this.w[7] = this.w[7] + (Sha256.s0(this.w[8]) + this.w[0] + Sha256.s1(this.w[5]));
        E += (A += Sha256.S1(F) + (F & (G ^ H) ^ H) + -1838011259 + this.w[7]);
        A += Sha256.S0(B) + (B & C | D & (B | C));
        this.w[8] = this.w[8] + (Sha256.s0(this.w[9]) + this.w[1] + Sha256.s1(this.w[6]));
        D += (H += Sha256.S1(E) + (E & (F ^ G) ^ G) + -1564481375 + this.w[8]);
        H += Sha256.S0(A) + (A & B | C & (A | B));
        this.w[9] = this.w[9] + (Sha256.s0(this.w[10]) + this.w[2] + Sha256.s1(this.w[7]));
        C += (G += Sha256.S1(D) + (D & (E ^ F) ^ F) + -1474664885 + this.w[9]);
        G += Sha256.S0(H) + (H & A | B & (H | A));
        this.w[10] = this.w[10] + (Sha256.s0(this.w[11]) + this.w[3] + Sha256.s1(this.w[8]));
        B += (F += Sha256.S1(C) + (C & (D ^ E) ^ E) + -1035236496 + this.w[10]);
        F += Sha256.S0(G) + (G & H | A & (G | H));
        this.w[11] = this.w[11] + (Sha256.s0(this.w[12]) + this.w[4] + Sha256.s1(this.w[9]));
        A += (E += Sha256.S1(B) + (B & (C ^ D) ^ D) + -949202525 + this.w[11]);
        E += Sha256.S0(F) + (F & G | H & (F | G));
        this.w[12] = this.w[12] + (Sha256.s0(this.w[13]) + this.w[5] + Sha256.s1(this.w[10]));
        H += (D += Sha256.S1(A) + (A & (B ^ C) ^ C) + -778901479 + this.w[12]);
        D += Sha256.S0(E) + (E & F | G & (E | F));
        this.w[13] = this.w[13] + (Sha256.s0(this.w[14]) + this.w[6] + Sha256.s1(this.w[11]));
        G += (C += Sha256.S1(H) + (H & (A ^ B) ^ B) + -694614492 + this.w[13]);
        C += Sha256.S0(D) + (D & E | F & (D | E));
        this.w[14] = this.w[14] + (Sha256.s0(this.w[15]) + this.w[7] + Sha256.s1(this.w[12]));
        F += (B += Sha256.S1(G) + (G & (H ^ A) ^ A) + -200395387 + this.w[14]);
        B += Sha256.S0(C) + (C & D | E & (C | D));
        this.w[15] = this.w[15] + (Sha256.s0(this.w[0]) + this.w[8] + Sha256.s1(this.w[13]));
        E += (A += Sha256.S1(F) + (F & (G ^ H) ^ H) + 275423344 + this.w[15]);
        A += Sha256.S0(B) + (B & C | D & (B | C));
        this.w[0] = this.w[0] + (Sha256.s0(this.w[1]) + this.w[9] + Sha256.s1(this.w[14]));
        D += (H += Sha256.S1(E) + (E & (F ^ G) ^ G) + 430227734 + this.w[0]);
        H += Sha256.S0(A) + (A & B | C & (A | B));
        this.w[1] = this.w[1] + (Sha256.s0(this.w[2]) + this.w[10] + Sha256.s1(this.w[15]));
        C += (G += Sha256.S1(D) + (D & (E ^ F) ^ F) + 506948616 + this.w[1]);
        G += Sha256.S0(H) + (H & A | B & (H | A));
        this.w[2] = this.w[2] + (Sha256.s0(this.w[3]) + this.w[11] + Sha256.s1(this.w[0]));
        B += (F += Sha256.S1(C) + (C & (D ^ E) ^ E) + 659060556 + this.w[2]);
        F += Sha256.S0(G) + (G & H | A & (G | H));
        this.w[3] = this.w[3] + (Sha256.s0(this.w[4]) + this.w[12] + Sha256.s1(this.w[1]));
        A += (E += Sha256.S1(B) + (B & (C ^ D) ^ D) + 883997877 + this.w[3]);
        E += Sha256.S0(F) + (F & G | H & (F | G));
        this.w[4] = this.w[4] + (Sha256.s0(this.w[5]) + this.w[13] + Sha256.s1(this.w[2]));
        H += (D += Sha256.S1(A) + (A & (B ^ C) ^ C) + 958139571 + this.w[4]);
        D += Sha256.S0(E) + (E & F | G & (E | F));
        this.w[5] = this.w[5] + (Sha256.s0(this.w[6]) + this.w[14] + Sha256.s1(this.w[3]));
        G += (C += Sha256.S1(H) + (H & (A ^ B) ^ B) + 1322822218 + this.w[5]);
        C += Sha256.S0(D) + (D & E | F & (D | E));
        this.w[6] = this.w[6] + (Sha256.s0(this.w[7]) + this.w[15] + Sha256.s1(this.w[4]));
        F += (B += Sha256.S1(G) + (G & (H ^ A) ^ A) + 1537002063 + this.w[6]);
        B += Sha256.S0(C) + (C & D | E & (C | D));
        this.w[7] = this.w[7] + (Sha256.s0(this.w[8]) + this.w[0] + Sha256.s1(this.w[5]));
        E += (A += Sha256.S1(F) + (F & (G ^ H) ^ H) + 1747873779 + this.w[7]);
        A += Sha256.S0(B) + (B & C | D & (B | C));
        this.w[8] = this.w[8] + (Sha256.s0(this.w[9]) + this.w[1] + Sha256.s1(this.w[6]));
        D += (H += Sha256.S1(E) + (E & (F ^ G) ^ G) + 1955562222 + this.w[8]);
        H += Sha256.S0(A) + (A & B | C & (A | B));
        this.w[9] = this.w[9] + (Sha256.s0(this.w[10]) + this.w[2] + Sha256.s1(this.w[7]));
        C += (G += Sha256.S1(D) + (D & (E ^ F) ^ F) + 2024104815 + this.w[9]);
        G += Sha256.S0(H) + (H & A | B & (H | A));
        this.w[10] = this.w[10] + (Sha256.s0(this.w[11]) + this.w[3] + Sha256.s1(this.w[8]));
        B += (F += Sha256.S1(C) + (C & (D ^ E) ^ E) + -2067236844 + this.w[10]);
        F += Sha256.S0(G) + (G & H | A & (G | H));
        this.w[11] = this.w[11] + (Sha256.s0(this.w[12]) + this.w[4] + Sha256.s1(this.w[9]));
        A += (E += Sha256.S1(B) + (B & (C ^ D) ^ D) + -1933114872 + this.w[11]);
        E += Sha256.S0(F) + (F & G | H & (F | G));
        this.w[12] = this.w[12] + (Sha256.s0(this.w[13]) + this.w[5] + Sha256.s1(this.w[10]));
        H += (D += Sha256.S1(A) + (A & (B ^ C) ^ C) + -1866530822 + this.w[12]);
        D += Sha256.S0(E) + (E & F | G & (E | F));
        this.w[13] = this.w[13] + (Sha256.s0(this.w[14]) + this.w[6] + Sha256.s1(this.w[11]));
        G += (C += Sha256.S1(H) + (H & (A ^ B) ^ B) + -1538233109 + this.w[13]);
        C += Sha256.S0(D) + (D & E | F & (D | E));
        this.w[14] = this.w[14] + (Sha256.s0(this.w[15]) + this.w[7] + Sha256.s1(this.w[12]));
        F += (B += Sha256.S1(G) + (G & (H ^ A) ^ A) + -1090935817 + this.w[14]);
        B += Sha256.S0(C) + (C & D | E & (C | D));
        this.w[15] = this.w[15] + (Sha256.s0(this.w[0]) + this.w[8] + Sha256.s1(this.w[13]));
        this.state[0] = this.state[0] + (A += Sha256.S0(B) + (B & C | D & (B | C)));
        this.state[1] = this.state[1] + B;
        this.state[2] = this.state[2] + C;
        this.state[3] = this.state[3] + D;
        this.state[4] = this.state[4] + (E += (A += Sha256.S1(F) + (F & (G ^ H) ^ H) + -965641998 + this.w[15]));
        this.state[5] = this.state[5] + F;
        this.state[6] = this.state[6] + G;
        this.state[7] = this.state[7] + H;
        Arrays.fill(this.bufInts, 0);
        Arrays.fill(this.w, 0);
    }
}

