/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * glassfish/bootstrap/legal/CDDLv1.0.txt or
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable,
 * add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your
 * own identifying information: Portions Copyright [yyyy]
 * [name of copyright owner]
 *
 * Copyright 2005 Sun Microsystems, Inc. All rights reserved.
 *
 * Portions Copyright Apache Software Foundation.
 */ 
 
package javax.servlet.jsp.tagext;

/**
 * Information for a function in a Tag Library.
 * This class is instantiated from the Tag Library Descriptor file (TLD)
 * and is available only at translation time.
 * 
 * @since 2.0
 */
public class FunctionInfo {

    /**
     * Constructor for FunctionInfo.
     *
     * @param name The name of the function
     * @param klass The class of the function
     * @param signature The signature of the function
     */

    public FunctionInfo(String name, String klass, String signature) {

	this.name = name;
        this.functionClass = klass;
        this.functionSignature = signature;
    }

    /**
     * The name of the function.
     *
     * @return The name of the function
     */

    public String getName() {
	return name;
    }

    /**
     * The class of the function.
     *
     * @return The class of the function
     */

    public String getFunctionClass() {
        return functionClass;
    }

    /**
     * The signature of the function.
     *
     * @return The signature of the function
     */

    public String getFunctionSignature() {
        return functionSignature;
    }

    /*
     * fields
     */

    private String name;
    private String functionClass;
    private String functionSignature;
}
