/*
 * Decompiled with CFR 0.152.
 */
package zipkin.reporter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import zipkin.reporter.ByteBoundedQueue;
import zipkin.reporter.Sender;

final class BufferNextMessage
implements ByteBoundedQueue.Consumer {
    private final Sender sender;
    private final int maxBytes;
    private final long timeoutNanos;
    private final List<byte[]> buffer = new LinkedList<byte[]>();
    long deadlineNanoTime;
    int sizeInBytes;
    boolean bufferFull;

    BufferNextMessage(Sender sender, int maxBytes, long timeoutNanos) {
        this.sender = sender;
        this.maxBytes = maxBytes;
        this.timeoutNanos = timeoutNanos;
    }

    @Override
    public boolean accept(byte[] next) {
        int includingNextVsMaxBytes;
        this.buffer.add(next);
        int x = this.sender.messageSizeInBytes(this.buffer);
        int y = this.maxBytes;
        int n = x < y ? -1 : (includingNextVsMaxBytes = x == y ? 0 : 1);
        if (includingNextVsMaxBytes <= 0) {
            this.sizeInBytes = x;
            if (includingNextVsMaxBytes == 0) {
                this.bufferFull = true;
            }
            return true;
        }
        this.buffer.remove(this.buffer.size() - 1);
        return false;
    }

    long remainingNanos() {
        if (this.buffer.isEmpty()) {
            this.deadlineNanoTime = System.nanoTime() + this.timeoutNanos;
        }
        return Math.max(this.deadlineNanoTime - System.nanoTime(), 0L);
    }

    boolean isReady() {
        return this.bufferFull || this.remainingNanos() <= 0L;
    }

    List<byte[]> drain() {
        if (this.buffer.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<byte[]> result = new ArrayList<byte[]>(this.buffer);
        this.buffer.clear();
        this.sizeInBytes = 0;
        this.bufferFull = false;
        this.deadlineNanoTime = 0L;
        return result;
    }

    int sizeInBytes() {
        return this.sizeInBytes;
    }
}

