/*
 * Decompiled with CFR 0.152.
 */
package brave.http;

import brave.http.HttpAdapter;
import brave.http.HttpSampler;
import brave.internal.Nullable;
import brave.sampler.ParameterizedSampler;
import java.util.ArrayList;
import java.util.List;

public final class HttpRuleSampler
extends HttpSampler {
    final ParameterizedSampler<MethodAndPath> sampler;

    public static Builder newBuilder() {
        return new Builder();
    }

    HttpRuleSampler(List<MethodAndPathRule> rules) {
        this.sampler = ParameterizedSampler.create(rules);
    }

    @Override
    public <Req> Boolean trySample(HttpAdapter<Req, ?> adapter, Req request) {
        String method = adapter.method(request);
        String path = adapter.path(request);
        if (method == null || path == null) {
            return null;
        }
        return this.sampler.sample((Object)new MethodAndPath(method, path)).sampled();
    }

    static final class MethodAndPathRule
    extends ParameterizedSampler.Rule<MethodAndPath> {
        @Nullable
        final String method;
        final String path;

        MethodAndPathRule(@Nullable String method, String path, float rate) {
            super(rate);
            this.method = method;
            this.path = path;
        }

        public boolean matches(MethodAndPath parameters) {
            if (this.method != null && !this.method.equals(parameters.method)) {
                return false;
            }
            return parameters.path.startsWith(this.path);
        }
    }

    static final class MethodAndPath {
        final String method;
        final String path;

        MethodAndPath(String method, String path) {
            this.method = method;
            this.path = path;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodAndPath)) {
                return false;
            }
            MethodAndPath that = (MethodAndPath)o;
            return this.method.equals(that.method) && this.path.equals(that.path);
        }

        public int hashCode() {
            int h = 1;
            h *= 1000003;
            h ^= this.method.hashCode();
            h *= 1000003;
            return h ^= this.path.hashCode();
        }
    }

    public static final class Builder {
        final List<MethodAndPathRule> rules = new ArrayList<MethodAndPathRule>();

        public Builder addRule(@Nullable String method, String path, float rate) {
            this.rules.add(new MethodAndPathRule(method, path, rate));
            return this;
        }

        public HttpSampler build() {
            return new HttpRuleSampler(this.rules);
        }

        Builder() {
        }
    }
}

