/*
 * Decompiled with CFR 0.152.
 */
package brave.http;

import brave.http.AutoValue_HttpRuleSampler_MethodAndPath;
import brave.http.HttpAdapter;
import brave.http.HttpSampler;
import brave.internal.Nullable;
import brave.sampler.ParameterizedSampler;
import com.google.auto.value.AutoValue;
import java.util.ArrayList;
import java.util.List;

public final class HttpRuleSampler
extends HttpSampler {
    final ParameterizedSampler<MethodAndPath> sampler;

    public static Builder newBuilder() {
        return new Builder();
    }

    HttpRuleSampler(List<MethodAndPathRule> rules) {
        this.sampler = ParameterizedSampler.create(rules);
    }

    @Override
    public <Req> Boolean trySample(HttpAdapter<Req, ?> adapter, Req request) {
        String method = adapter.method(request);
        String path = adapter.path(request);
        if (method == null || path == null) {
            return null;
        }
        return this.sampler.sample((Object)MethodAndPath.create(method, path)).sampled();
    }

    static final class MethodAndPathRule
    extends ParameterizedSampler.Rule<MethodAndPath> {
        @Nullable
        final String method;
        final String path;

        MethodAndPathRule(@Nullable String method, String path, float rate) {
            super(rate);
            this.method = method;
            this.path = path;
        }

        public boolean matches(MethodAndPath parameters) {
            if (this.method != null && !this.method.equals(parameters.method())) {
                return false;
            }
            return parameters.path().startsWith(this.path);
        }
    }

    @AutoValue
    static abstract class MethodAndPath {
        MethodAndPath() {
        }

        static MethodAndPath create(String method, String path) {
            return new AutoValue_HttpRuleSampler_MethodAndPath(method, path);
        }

        abstract String method();

        abstract String path();
    }

    public static final class Builder {
        final List<MethodAndPathRule> rules = new ArrayList<MethodAndPathRule>();

        public Builder addRule(@Nullable String method, String path, float rate) {
            this.rules.add(new MethodAndPathRule(method, path, rate));
            return this;
        }

        public HttpSampler build() {
            return new HttpRuleSampler(this.rules);
        }

        Builder() {
        }
    }
}

