/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.atom.parsing;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.building.ModelSource;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonatype.maven.polyglot.atom.parsing.Id;
import org.sonatype.maven.polyglot.atom.parsing.Project;
import org.sonatype.maven.polyglot.atom.parsing.Property;
import org.sonatype.maven.polyglot.atom.parsing.Repositories;
import org.sonatype.maven.polyglot.atom.parsing.ScmElement;
import org.sonatype.maven.polyglot.atom.parsing.Token;

public class AtomParser {
    private final Logger log = Logger.getLogger(AtomParser.class.getName());
    private final List<Token> tokens;
    private final ModelSource modelSource;
    private int i = 0;

    public AtomParser(ModelSource modelSource, List<Token> tokens) {
        this.tokens = tokens;
        this.modelSource = modelSource;
    }

    private void parseException(String message, Throwable t) {
        String location = this.modelSource != null ? this.modelSource.getLocation() : "";
        throw new RuntimeException("Error parsing " + location + ": " + message, t);
    }

    private void parseException(String message) {
        String location = this.modelSource != null ? this.modelSource.getLocation() : "";
        throw new RuntimeException("Error parsing " + location + ": " + message);
    }

    public Project parse() {
        this.chewEols();
        Repositories repositories = this.repositories();
        if (null == repositories) {
            // empty if block
        }
        this.chewEols();
        return this.project(repositories);
    }

    private Project project(Repositories repositories) {
        if (this.match(Token.Kind.PROJECT) == null) {
            return null;
        }
        List<Token> signature = this.match(Token.Kind.STRING);
        if (null == signature) {
            this.log.severe("Expected string describing project after 'project'.");
        }
        String projectDescription = signature.get((int)0).value;
        String projectUrl = null;
        signature = this.match(Token.Kind.AT, Token.Kind.STRING);
        if (null != signature) {
            projectUrl = signature.get((int)1).value;
        }
        List<Token> packagingTokens = this.match(Token.Kind.PACKAGING, Token.Kind.IDENT);
        String packaging = null;
        if (null != packagingTokens) {
            packaging = packagingTokens.get((int)1).value;
        }
        if (this.match(Token.Kind.EOL) == null) {
            this.log.severe("Expected end of line after project declaration");
            return null;
        }
        this.indent();
        if (this.match(Token.Kind.ID) == null) {
            this.log.severe("Expected 'id' after project declaration");
            return null;
        }
        if (this.match(Token.Kind.COLON) == null) {
            this.log.severe("Expected ':' after 'id'");
            return null;
        }
        Id projectId = this.id();
        this.chewEols();
        this.chewIndents();
        Parent parent = this.parent();
        this.chewEols();
        this.chewIndents();
        this.chewEols();
        Map<String, String> dirs = this.srcs();
        this.chewEols();
        this.chewIndents();
        List<Property> properties = this.properties(Token.Kind.PROPS);
        this.chewEols();
        this.chewIndents();
        List<Id> overrides = this.dependencies(Token.Kind.OVERRIDES, false);
        this.chewEols();
        this.chewIndents();
        List<Id> deps = this.dependencies(Token.Kind.DEPS, true);
        this.chewEols();
        this.chewIndents();
        List<String> modules = this.modules();
        ScmElement scm = this.scm();
        this.chewEols();
        this.chewIndents();
        List<Plugin> pluginOverrides = this.plugins(Token.Kind.PLUGIN_OVERRIDE);
        List<Plugin> plugins = this.plugins(Token.Kind.PLUGIN);
        return new Project(projectId, parent, packaging, properties, repositories, projectDescription, projectUrl, overrides, deps, modules, pluginOverrides, plugins, dirs, scm);
    }

    private ScmElement scm() {
        List<Token> ident;
        this.chewIndents();
        if (this.match(Token.Kind.SCM, Token.Kind.COLON, Token.Kind.LBRACKET) == null) {
            return null;
        }
        this.chewEols();
        this.chewIndents();
        String connection = null;
        String developerConnection = null;
        String url = null;
        while ((ident = this.match(Token.Kind.IDENT)) != null) {
            List<Token> valueToken;
            String label = ident.get((int)0).value;
            if (this.match(Token.Kind.COLON) == null) {
                this.parseException("Expected : after label");
            }
            if (null == (valueToken = this.match(Token.Kind.STRING))) {
                this.parseException("Expected String after :");
            }
            String value = valueToken.get((int)0).value;
            if ("connection".equals(label)) {
                connection = value;
            } else if ("developerConnection".equals(label)) {
                developerConnection = value;
            } else if ("url".equals(label)) {
                url = value;
            }
            this.chewEols();
            this.chewIndents();
        }
        if (this.match(Token.Kind.RBRACKET) == null) {
            this.parseException("Expected ] after srcs list");
        }
        return new ScmElement(connection, developerConnection, url);
    }

    private Map<String, String> srcs() {
        this.indent();
        if (this.match(Token.Kind.SRCS, Token.Kind.COLON, Token.Kind.LBRACKET) == null) {
            return null;
        }
        this.chewEols();
        this.chewIndents();
        List<Token> aMatch = this.match(Token.Kind.IDENT);
        if (aMatch == null) {
            this.parseException("Expected 'src' or 'test'");
        }
        String srcDir = null;
        if ("src".equals(aMatch.get((int)0).value)) {
            List<Token> srcDirToken;
            if (null == this.match(Token.Kind.COLON)) {
                this.parseException("Expected : after src");
            }
            if (null == (srcDirToken = this.match(Token.Kind.STRING))) {
                this.parseException("Expected string after src:");
            }
            srcDir = srcDirToken.get((int)0).value;
        }
        aMatch = this.match(Token.Kind.IDENT);
        String testDir = null;
        if (null != aMatch && "test".equals(aMatch.get((int)0).value)) {
            List<Token> testDirToken;
            if (null == this.match(Token.Kind.COLON)) {
                this.parseException("Expected : after test");
            }
            if (null == (testDirToken = this.match(Token.Kind.STRING))) {
                this.parseException("Expected string after test:");
            }
            testDir = testDirToken.get((int)0).value;
        }
        HashMap<String, String> dirs = new HashMap<String, String>();
        if (null != srcDir) {
            dirs.put("src", AtomParser.stripQuotes(srcDir));
        }
        if (null != testDir) {
            dirs.put("test", AtomParser.stripQuotes(testDir));
        }
        if (this.match(Token.Kind.RBRACKET) == null) {
            this.parseException("Expected ] after srcs list");
        }
        return dirs;
    }

    private List<Id> dependencies(Token.Kind kind, boolean allowNullVersion) {
        Id id;
        this.indent();
        if (this.match(kind, Token.Kind.COLON, Token.Kind.LBRACKET) == null) {
            return null;
        }
        ArrayList<Id> deps = new ArrayList<Id>();
        this.chewEols();
        this.chewIndents();
        while ((id = this.id(allowNullVersion)) != null) {
            String classifier = this.classifier();
            if (null != classifier) {
                id.setClassifier(classifier);
            }
            this.chewEols();
            this.chewIndents();
            deps.add(id);
        }
        if (this.match(Token.Kind.RBRACKET) == null) {
            this.parseException("Expected ]");
        }
        return deps;
    }

    private List<Plugin> plugins(Token.Kind keyword) {
        Plugin plugin;
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        this.chewEols();
        while ((plugin = this.plugin(keyword)) != null) {
            plugins.add(plugin);
            this.chewEols();
        }
        return plugins;
    }

    private Plugin plugin(Token.Kind keyword) {
        if (this.match(keyword) == null) {
            return null;
        }
        if (this.match(Token.Kind.EOL) == null) {
            this.parseException("Expected newline after 'plugin' keyword");
        }
        Plugin plugin = new Plugin();
        this.chewIndents();
        if (this.match(Token.Kind.ID, Token.Kind.COLON) == null) {
            this.log.severe("Plugin declaration is missing an 'id' tag");
            return null;
        }
        Id pluginId = this.id(true);
        if (pluginId == null) {
            this.log.severe("Plugin id declaration malformed");
            return null;
        }
        if (this.match(Token.Kind.EOL) == null) {
            this.log.severe("Expected newline after plugin id declaration");
            return null;
        }
        plugin.setGroupId(pluginId.getGroup());
        plugin.setArtifactId(pluginId.getArtifact());
        plugin.setVersion(pluginId.getVersion());
        Map<String, Object> config = this.configurationMap();
        if (config == null || config.isEmpty()) {
            return plugin;
        }
        plugin.setConfiguration((Object)this.toXpp3DomTree("configuration", config));
        return plugin;
    }

    private Xpp3Dom toXpp3DomTree(String name, Map<String, Object> config) {
        Xpp3Dom xConfig = new Xpp3Dom(name);
        for (Map.Entry<String, Object> entry : config.entrySet()) {
            if (entry.getValue() instanceof String) {
                Xpp3Dom node = new Xpp3Dom(entry.getKey());
                node.setValue(entry.getValue().toString());
                xConfig.addChild(node);
                continue;
            }
            Map childMap = (Map)entry.getValue();
            Xpp3Dom child = this.toXpp3DomTree(entry.getKey(), childMap);
            xConfig.addChild(child);
        }
        return xConfig;
    }

    private Map<String, Object> configurationMap() {
        List<Token> propKey;
        LinkedHashMap<String, Object> config = new LinkedHashMap<String, Object>();
        this.chewIndents();
        while ((propKey = this.match(Token.Kind.IDENT, Token.Kind.COLON)) != null) {
            List<Token> tokens;
            String atom = this.idFragment();
            if (atom == null && (tokens = this.match(Token.Kind.STRING)) != null) {
                atom = tokens.get((int)0).value;
            }
            if (atom != null) {
                atom = atom.trim();
                atom = AtomParser.stripQuotes(atom);
                config.put(propKey.get((int)0).value, atom);
                this.match(Token.Kind.EOL);
            } else if (this.anyOf(Token.Kind.LBRACKET, Token.Kind.LBRACE) != null) {
                this.chewEols();
                this.chewIndents();
                Map<String, Object> childProps = this.configurationMap();
                this.chewEols();
                this.chewIndents();
                if (this.match(Token.Kind.RBRACKET) == null && this.match(Token.Kind.RBRACE) == null) {
                    this.parseException("Expected ']' after configuration properties");
                }
                config.put(propKey.get((int)0).value, childProps);
            } else {
                this.log.warning("Unknown element type in plugin declaration");
                return null;
            }
            this.chewIndents();
        }
        return config;
    }

    static String stripQuotes(String atom) {
        if (atom.startsWith("\"") && atom.endsWith("\"")) {
            atom = atom.substring(1, atom.length() - 1);
        }
        return atom;
    }

    private List<Property> properties(Token.Kind kind) {
        Property p;
        this.indent();
        if (this.match(kind, Token.Kind.COLON, Token.Kind.LBRACKET) == null) {
            return null;
        }
        ArrayList<Property> properties = new ArrayList<Property>();
        this.chewEols();
        this.chewIndents();
        while ((p = this.property()) != null) {
            this.chewEols();
            this.chewIndents();
            properties.add(p);
        }
        if (this.match(Token.Kind.RBRACKET) == null) {
            this.parseException("Expected ]");
        }
        return properties;
    }

    private List<String> modules() {
        String module;
        this.indent();
        if (this.match(Token.Kind.MODULES, Token.Kind.COLON, Token.Kind.LBRACKET) == null) {
            return null;
        }
        ArrayList<String> modules = new ArrayList<String>();
        this.chewEols();
        this.chewIndents();
        while ((module = this.idFragment()) != null) {
            this.chewEols();
            this.chewIndents();
            modules.add(module);
        }
        if (this.match(Token.Kind.RBRACKET) == null) {
            this.parseException("Expected ]");
        }
        return modules;
    }

    private String classifier() {
        if (this.match(Token.Kind.LPAREN) == null) {
            return null;
        }
        List<Token> classifier = this.match(Token.Kind.IDENT);
        if (classifier == null) {
            this.log.severe("Expected identifier after '(' in classifier clause");
            return null;
        }
        if (this.match(Token.Kind.RPAREN) == null) {
            this.log.severe("Expected ')' in classifier clause before end of line");
            return null;
        }
        return classifier.get((int)0).value;
    }

    private Property property() {
        String key = this.idFragment();
        if (key == null) {
            return null;
        }
        if (this.match(Token.Kind.COLON) == null) {
            return null;
        }
        List<Token> value = this.match(Token.Kind.STRING);
        if (value == null) {
            return null;
        }
        String actual = AtomParser.stripQuotes(value.get((int)0).value);
        return new Property(key, actual);
    }

    private Id id() {
        return this.id(false);
    }

    private Id id(boolean allowNullVersion) {
        String groupId = this.idFragment();
        if (groupId == null) {
            return null;
        }
        if (this.match(Token.Kind.COLON) == null) {
            return null;
        }
        String artifactId = this.idFragment();
        if (artifactId == null) {
            return null;
        }
        if (this.match(Token.Kind.COLON) == null && !allowNullVersion) {
            return null;
        }
        String version = this.idFragment();
        if (version == null && !allowNullVersion) {
            return null;
        }
        return new Id(groupId, artifactId, StringUtils.isEmpty((String)version) ? null : version);
    }

    private Parent parent() {
        if (this.match(Token.Kind.PARENT) == null) {
            return null;
        }
        if (this.match(Token.Kind.COLON) == null) {
            this.log.severe("Expected ':' after 'inherits'");
            return null;
        }
        Id parentId = this.id(true);
        if (parentId == null) {
            this.log.severe("Expected complete artifact identifier in 'parent' clause");
            return null;
        }
        String relativePath = "../pom.atom";
        if (this.match(Token.Kind.COLON) != null && (relativePath = this.relativePath()) == null) {
            return null;
        }
        Parent parent = new Parent();
        parent.setGroupId(parentId.getGroup());
        parent.setArtifactId(parentId.getArtifact());
        parent.setVersion(parentId.getVersion());
        parent.setRelativePath(relativePath);
        return parent;
    }

    private String relativePath() {
        List<Token> idFragment;
        StringBuilder fragment = new StringBuilder();
        if (this.match(Token.Kind.DOT) != null) {
            fragment.append(".");
        }
        if (this.match(Token.Kind.DOT) != null) {
            fragment.append(".");
        }
        while ((idFragment = this.match(Token.Kind.IDENT)) != null) {
            fragment.append(idFragment.get((int)0).value);
            if (this.match(Token.Kind.DOT) == null) continue;
            fragment.append('.');
        }
        return fragment.toString();
    }

    private String idFragment() {
        Token idFragment;
        StringBuilder fragment = new StringBuilder();
        while ((idFragment = this.anyOf(Token.Kind.IDENT, Token.Kind.PLUGIN, Token.Kind.PROJECT, Token.Kind.DEPS, Token.Kind.SCM, Token.Kind.SRCS, Token.Kind.MODULES, Token.Kind.ID, Token.Kind.PACKAGING, Token.Kind.PARENT, Token.Kind.OVERRIDES, Token.Kind.REPOSITORIES, Token.Kind.PROPS)) != null) {
            fragment.append(idFragment.value);
            if (this.match(Token.Kind.DOT) != null) {
                fragment.append('.');
            }
            if (this.match(Token.Kind.DASH) == null) continue;
            fragment.append('-');
        }
        if (fragment.length() == 1 && fragment.charAt(0) == '$') {
            List<Token> startOfExpr = this.match(Token.Kind.LBRACE);
            if (startOfExpr == null) {
                return null;
            }
            fragment.append("{");
            String prop = this.idFragment();
            if (prop == null) {
                this.parseException("Expected a property expression after ${");
            }
            if (this.match(Token.Kind.RBRACE) == null) {
                this.parseException("Expected '}' after property expression");
            }
            fragment.append(prop).append("}");
        }
        if (fragment.length() == 0) {
            return null;
        }
        return fragment.toString();
    }

    private Repositories repositories() {
        if (this.match(Token.Kind.REPOSITORIES, Token.Kind.LEFT_WAVE) == null) {
            return null;
        }
        ArrayList<String> repoUrls = new ArrayList<String>();
        List<Token> repositories = this.match(Token.Kind.STRING);
        if (repositories == null) {
            this.parseException("Error: expected URL string after 'respositories");
        }
        String url = repositories.get((int)0).value;
        repoUrls.add(this.validateUrl(url));
        while ((repositories = this.match(Token.Kind.COMMA)) != null) {
            this.chewEols();
            this.chewIndents();
            repositories = this.match(Token.Kind.STRING);
            this.chewEols();
            this.chewIndents();
            if (null == repositories) continue;
            url = this.validateUrl(repositories.get((int)0).value);
            repoUrls.add(url);
        }
        return new Repositories(repoUrls);
    }

    private String validateUrl(String url) {
        url = AtomParser.stripQuotes(url);
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            this.parseException("Invalid URL: " + url, e);
        }
        return url;
    }

    private void indent() {
        if (this.match(Token.Kind.INDENT, Token.Kind.INDENT) != null) {
            // empty if block
        }
    }

    private Token anyOf(Token.Kind ... ident) {
        if (this.i >= this.tokens.size()) {
            return null;
        }
        for (Token.Kind kind : ident) {
            Token token = this.tokens.get(this.i);
            if (kind != token.kind) continue;
            ++this.i;
            return token;
        }
        return null;
    }

    private List<Token> match(Token.Kind ... ident) {
        int cursor = this.i;
        for (Token.Kind kind : ident) {
            if (cursor >= this.tokens.size()) {
                return null;
            }
            Token token = this.tokens.get(cursor);
            if (token.kind != kind) {
                return null;
            }
            ++cursor;
        }
        int start = this.i;
        this.i = cursor;
        return this.tokens.subList(start, this.i);
    }

    private void chewEols() {
        while (this.match(Token.Kind.EOL) != null) {
        }
    }

    private void chewIndents() {
        while (this.match(Token.Kind.INDENT) != null) {
        }
    }
}

