/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.schema;

import io.smallrye.openapi.api.constants.JDKConstants;
import io.smallrye.openapi.api.constants.JacksonConstants;
import io.smallrye.openapi.api.constants.MutinyConstants;
import io.smallrye.openapi.api.models.media.DiscriminatorImpl;
import io.smallrye.openapi.api.models.media.SchemaImpl;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.io.CurrentScannerInfo;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.extension.ExtensionReader;
import io.smallrye.openapi.runtime.io.externaldocs.ExternalDocsReader;
import io.smallrye.openapi.runtime.io.schema.SchemaConstant;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.OpenApiDataObjectScanner;
import io.smallrye.openapi.runtime.scanner.SchemaRegistry;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.JandexUtil;
import io.smallrye.openapi.runtime.util.ModelUtil;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.media.Discriminator;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

public class SchemaFactory {
    private SchemaFactory() {
    }

    public static Schema readSchema(AnnotationScannerContext context, AnnotationValue value) {
        if (value == null) {
            return null;
        }
        return SchemaFactory.readSchema(context, value.asNested());
    }

    public static Schema readSchema(AnnotationScannerContext context, AnnotationInstance schemaAnnotation) {
        if (SchemaFactory.isAnnotationMissingOrHidden(schemaAnnotation, Collections.emptyMap())) {
            return null;
        }
        return SchemaFactory.readSchema(context, (Schema)new SchemaImpl(), schemaAnnotation, Collections.emptyMap());
    }

    public static Schema readSchema(AnnotationScannerContext context, Schema schema, AnnotationInstance annotation, ClassInfo clazz) {
        return SchemaFactory.readSchema(context, schema, annotation, clazz, Collections.emptyMap());
    }

    static Schema readSchema(AnnotationScannerContext context, Schema schema, AnnotationInstance annotation, ClassInfo clazz, Map<String, Object> defaults) {
        if (SchemaFactory.isAnnotationMissingOrHidden(annotation, defaults)) {
            return schema;
        }
        schema = SchemaFactory.readSchema(context, schema, annotation, defaults);
        ClassType clazzType = (ClassType)Type.create((DotName)clazz.name(), (Type.Kind)Type.Kind.CLASS);
        SchemaFactory.schemaRegistration(context, (Type)clazzType, schema);
        return schema;
    }

    public static Schema readSchema(AnnotationScannerContext context, Schema schema, AnnotationInstance annotation, Map<String, Object> defaults) {
        if (SchemaFactory.isAnnotationMissingOrHidden(annotation, defaults)) {
            return schema;
        }
        schema.setNot(SchemaFactory.readAttr(annotation, "not", types -> SchemaFactory.readClassSchema(context, types, true), defaults));
        schema.setOneOf(SchemaFactory.readAttr(annotation, "oneOf", types -> SchemaFactory.readClassSchemas(context, types, false), defaults));
        schema.setAnyOf(SchemaFactory.readAttr(annotation, "anyOf", types -> SchemaFactory.readClassSchemas(context, types, false), defaults));
        schema.setAllOf(SchemaFactory.readAttr(annotation, "allOf", types -> SchemaFactory.readClassSchemas(context, types, true), defaults));
        schema.setTitle((String)((Object)SchemaFactory.readAttr(annotation, "title", defaults)));
        schema.setMultipleOf(SchemaFactory.readAttr(annotation, "multipleOf", BigDecimal::valueOf, defaults));
        schema.setMaximum(SchemaFactory.readAttr(annotation, "maximum", SchemaFactory::tolerantParseBigDecimal, defaults));
        schema.setMinimum(SchemaFactory.readAttr(annotation, "minimum", SchemaFactory::tolerantParseBigDecimal, defaults));
        schema.setExclusiveMaximum((Boolean)((Object)SchemaFactory.readAttr(annotation, "exclusiveMaximum", defaults)));
        schema.setExclusiveMinimum((Boolean)((Object)SchemaFactory.readAttr(annotation, "exclusiveMinimum", defaults)));
        schema.setMaxLength((Integer)((Object)SchemaFactory.readAttr(annotation, "maxLength", defaults)));
        schema.setMinLength((Integer)((Object)SchemaFactory.readAttr(annotation, "minLength", defaults)));
        schema.setPattern((String)((Object)SchemaFactory.readAttr(annotation, "pattern", defaults)));
        schema.setMaxProperties((Integer)((Object)SchemaFactory.readAttr(annotation, "maxProperties", defaults)));
        schema.setMinProperties((Integer)((Object)SchemaFactory.readAttr(annotation, "minProperties", defaults)));
        schema.setRequired((List)((Object)SchemaFactory.readAttr(annotation, "requiredProperties", defaults)));
        schema.setDescription((String)((Object)SchemaFactory.readAttr(annotation, "description", defaults)));
        schema.setFormat((String)((Object)SchemaFactory.readAttr(annotation, "format", defaults)));
        schema.setRef((String)((Object)SchemaFactory.readAttr(annotation, "ref", defaults)));
        schema.setNullable((Boolean)((Object)SchemaFactory.readAttr(annotation, "nullable", defaults)));
        schema.setReadOnly((Boolean)((Object)SchemaFactory.readAttr(annotation, "readOnly", defaults)));
        schema.setWriteOnly((Boolean)((Object)SchemaFactory.readAttr(annotation, "writeOnly", defaults)));
        AnnotationInstance externalDocsAnnotation = (AnnotationInstance)JandexUtil.value(annotation, "externalDocs");
        schema.setExternalDocs(ExternalDocsReader.readExternalDocs(context, externalDocsAnnotation));
        schema.setDeprecated((Boolean)((Object)SchemaFactory.readAttr(annotation, "deprecated", defaults)));
        schema.setType(SchemaFactory.readSchemaType(annotation, schema, defaults));
        schema.setExample(SchemaFactory.parseSchemaAttr(context, annotation, "example", defaults, schema.getType()));
        schema.setDefaultValue(SchemaFactory.readAttr(annotation, "defaultValue", defaults));
        schema.setDiscriminator(SchemaFactory.readDiscriminator(context, (String)JandexUtil.value(annotation, "discriminatorProperty"), (AnnotationInstance[])JandexUtil.value(annotation, "discriminatorMapping")));
        schema.setMaxItems((Integer)((Object)SchemaFactory.readAttr(annotation, "maxItems", defaults)));
        schema.setMinItems((Integer)((Object)SchemaFactory.readAttr(annotation, "minItems", defaults)));
        schema.setUniqueItems((Boolean)((Object)SchemaFactory.readAttr(annotation, "uniqueItems", defaults)));
        schema.setExtensions(ExtensionReader.readExtensions(context, annotation));
        schema.setProperties(SchemaFactory.readAttr(annotation, "properties", properties -> {
            if (properties == null || ((AnnotationInstance[])properties).length == 0) {
                return null;
            }
            LinkedHashMap<String, Schema> propertySchemas = new LinkedHashMap<String, Schema>(((AnnotationInstance[])properties).length);
            for (AnnotationInstance propAnnotation : properties) {
                String key = (String)JandexUtil.value(propAnnotation, "name");
                Schema value = SchemaFactory.readSchema(context, (Schema)new SchemaImpl(), propAnnotation, Collections.emptyMap());
                propertySchemas.put(key, value);
            }
            return propertySchemas;
        }, defaults));
        List enumeration = (List)((Object)SchemaFactory.readAttr(annotation, "enumeration", defaults));
        if (enumeration != null && !enumeration.isEmpty()) {
            schema.setEnumeration(enumeration);
        }
        boolean namedComponent = SchemaImpl.isNamed(schema);
        if (JandexUtil.isSimpleClassSchema(annotation)) {
            Schema implSchema = SchemaFactory.readClassSchema(context, (Type)JandexUtil.value(annotation, "implementation"), !namedComponent);
            schema = MergeUtil.mergeObjects(implSchema, schema);
        } else if (JandexUtil.isSimpleArraySchema(annotation)) {
            Schema implSchema = SchemaFactory.readClassSchema(context, (Type)JandexUtil.value(annotation, "implementation"), !namedComponent);
            schema.setItems(implSchema);
        } else {
            Schema implSchema = SchemaFactory.readClassSchema(context, (Type)JandexUtil.value(annotation, "implementation"), false);
            if (schema.getType() == Schema.SchemaType.ARRAY && implSchema != null) {
                schema.setItems(implSchema);
            } else if (implSchema != null) {
                schema = MergeUtil.mergeObjects(implSchema, schema);
            }
        }
        return schema;
    }

    static boolean isAnnotationMissingOrHidden(AnnotationInstance annotation, Map<String, Object> defaults) {
        if (annotation == null) {
            return true;
        }
        return Boolean.TRUE.equals(SchemaFactory.readAttr(annotation, "hidden", defaults));
    }

    static <T> T readAttr(AnnotationInstance annotation, String propertyName, Map<String, Object> defaults) {
        return (T)SchemaFactory.readAttr(annotation, propertyName, defaults.get(propertyName));
    }

    static <T> T readAttr(AnnotationInstance annotation, String propertyName, T defaultValue) {
        Object value = JandexUtil.value(annotation, propertyName);
        if (value == null) {
            value = defaultValue;
        } else if (value.getClass().isArray()) {
            value = Arrays.stream((Object[])value).collect(Collectors.toList());
        }
        return value;
    }

    static Object parseSchemaAttr(AnnotationScannerContext context, AnnotationInstance annotation, String propertyName, Map<String, Object> defaults, Schema.SchemaType schemaType) {
        return SchemaFactory.readAttr(annotation, propertyName, value -> {
            if (!(value instanceof String)) {
                return value;
            }
            String stringValue = (String)value;
            if (schemaType != Schema.SchemaType.STRING) {
                for (AnnotationScannerExtension e : context.getExtensions()) {
                    Object parsedValue = e.parseValue(stringValue);
                    if (parsedValue == null) continue;
                    return parsedValue;
                }
            }
            return stringValue;
        }, defaults);
    }

    static <R, T> T readAttr(AnnotationInstance annotation, String propertyName, Function<R, T> converter, Map<String, Object> defaults) {
        Object rawValue = JandexUtil.value(annotation, propertyName);
        Object value = rawValue == null ? defaults.get(propertyName) : converter.apply(rawValue);
        return (T)value;
    }

    static Schema.SchemaType readSchemaType(AnnotationInstance annotation, Schema schema, Map<String, Object> defaults) {
        Schema.SchemaType type = SchemaFactory.readAttr(annotation, "type", SchemaFactory::parseSchemaType, defaults);
        return type != null ? type : schema.getType();
    }

    static Schema.SchemaType parseSchemaType(String value) {
        return JandexUtil.enumValue(value, Schema.SchemaType.class);
    }

    static Schema readClassSchema(AnnotationScannerContext context, Type type, boolean schemaReferenceSupported) {
        Schema schema;
        if (type == null) {
            return null;
        }
        if (type.kind() == Type.Kind.ARRAY) {
            schema = new SchemaImpl().type(Schema.SchemaType.ARRAY);
            ArrayType array = type.asArrayType();
            int dimensions = array.dimensions();
            Type componentType = array.component();
            if (dimensions > 1) {
                schema.setItems(SchemaFactory.readClassSchema(context, (Type)ArrayType.create((Type)componentType, (int)(dimensions - 1)), schemaReferenceSupported));
            } else {
                schema.setItems(SchemaFactory.readClassSchema(context, componentType, schemaReferenceSupported));
            }
        } else {
            schema = type.kind() == Type.Kind.PRIMITIVE ? OpenApiDataObjectScanner.process(type.asPrimitiveType()) : SchemaFactory.introspectClassToSchema(context, type.asClassType(), schemaReferenceSupported);
        }
        return schema;
    }

    public static Schema typeToSchema(AnnotationScannerContext context, Type type, List<AnnotationScannerExtension> extensions) {
        Schema schema = null;
        if (TypeUtil.isWrappedType(type)) {
            schema = SchemaFactory.typeToSchema(context, TypeUtil.unwrapType(type), extensions);
        } else if (CurrentScannerInfo.isWrapperType(type)) {
            schema = SchemaFactory.typeToSchema(context, CurrentScannerInfo.getCurrentAnnotationScanner().unwrapType(type), extensions);
        } else if (TypeUtil.isTerminalType(type)) {
            schema = new SchemaImpl();
            TypeUtil.applyTypeAttributes(type, schema);
            schema = SchemaFactory.schemaRegistration(context, type, schema);
        } else if (type.kind() == Type.Kind.ARRAY) {
            schema = new SchemaImpl().type(Schema.SchemaType.ARRAY);
            ArrayType array = type.asArrayType();
            int dimensions = array.dimensions();
            Type componentType = array.component();
            if (dimensions > 1) {
                schema.setItems(SchemaFactory.typeToSchema(context, (Type)ArrayType.create((Type)componentType, (int)(dimensions - 1)), extensions));
            } else {
                schema.setItems(SchemaFactory.typeToSchema(context, componentType, extensions));
            }
        } else {
            schema = type.kind() == Type.Kind.CLASS ? SchemaFactory.introspectClassToSchema(context, type.asClassType(), true) : (type.kind() == Type.Kind.PRIMITIVE ? OpenApiDataObjectScanner.process(type.asPrimitiveType()) : SchemaFactory.otherTypeToSchema(context, type, extensions));
        }
        return schema;
    }

    public static Schema enumToSchema(AnnotationScannerContext context, Type enumType) {
        IoLogging.logger.enumProcessing(enumType);
        int ENUM = 16384;
        ClassInfo enumKlazz = context.getIndex().getClassByName(TypeUtil.getName(enumType));
        AnnotationInstance schemaAnnotation = enumKlazz.classAnnotation(SchemaConstant.DOTNAME_SCHEMA);
        SchemaImpl enumSchema = new SchemaImpl();
        List enumeration = enumKlazz.annotationsMap().getOrDefault(JacksonConstants.JSON_VALUE, Collections.emptyList()).stream().filter(atJsonValue -> JandexUtil.value(atJsonValue, "value", true)).map(AnnotationInstance::target).filter(JandexUtil::isSupplier).map(valueTarget -> {
            String className = enumKlazz.name().toString();
            String methodName = valueTarget.asMethod().name();
            try {
                Class<?> loadedEnum = Class.forName(className, false, context.getClassLoader());
                Method valueMethod = loadedEnum.getDeclaredMethod(methodName, new Class[0]);
                ?[] constants = loadedEnum.getEnumConstants();
                ArrayList<Object> reflectedEnumeration = new ArrayList<Object>(constants.length);
                for (Object constant : constants) {
                    reflectedEnumeration.add(valueMethod.invoke(constant, new Object[0]));
                }
                return reflectedEnumeration;
            }
            catch (Exception e) {
                IoLogging.logger.exceptionReadingEnumJsonValue(className, methodName, e);
                return null;
            }
        }).filter(Objects::nonNull).findFirst().orElseGet(() -> JandexUtil.fields(context, enumKlazz).stream().filter(field -> (field.flags() & 0x4000) != 0).map(FieldInfo::name).collect(Collectors.toList()));
        if (schemaAnnotation != null) {
            HashMap<String, Object> defaults = new HashMap<String, Object>(2);
            defaults.put("type", Schema.SchemaType.STRING);
            defaults.put("enumeration", enumeration);
            enumSchema = SchemaFactory.readSchema(context, enumSchema, schemaAnnotation, enumKlazz, defaults);
        } else {
            enumSchema.setType(Schema.SchemaType.STRING);
            enumSchema.setEnumeration(enumeration);
        }
        return enumSchema;
    }

    private static Schema introspectClassToSchema(AnnotationScannerContext context, ClassType ctype, boolean schemaReferenceSupported) {
        AnnotationInstance schemaAnnotation;
        if (CurrentScannerInfo.isScannerInternalResponse((Type)ctype)) {
            return null;
        }
        ClassInfo classInfo = context.getAugmentedIndex().getClass((Type)ctype);
        if (classInfo != null && (schemaAnnotation = classInfo.classAnnotation(SchemaConstant.DOTNAME_SCHEMA)) != null && Boolean.TRUE.equals(SchemaFactory.readAttr(schemaAnnotation, "hidden", false))) {
            return null;
        }
        SchemaRegistry schemaRegistry = SchemaRegistry.currentInstance();
        if (schemaReferenceSupported && schemaRegistry.hasSchema((Type)ctype)) {
            return schemaRegistry.lookupRef((Type)ctype);
        }
        if (!schemaReferenceSupported && schemaRegistry != null && schemaRegistry.hasSchema((Type)ctype)) {
            return MergeUtil.mergeObjects(new SchemaImpl(), schemaRegistry.lookupSchema((Type)ctype));
        }
        if (context.getScanStack().contains(ctype)) {
            return SchemaRegistry.registerReference((Type)ctype, null, new SchemaImpl());
        }
        Schema schema = OpenApiDataObjectScanner.process(context, (Type)ctype);
        if (schemaReferenceSupported) {
            return SchemaFactory.schemaRegistration(context, (Type)ctype, schema);
        }
        return schema;
    }

    public static Schema schemaRegistration(AnnotationScannerContext context, Type type, Schema schema) {
        SchemaRegistry schemaRegistry = SchemaRegistry.currentInstance();
        if (SchemaFactory.allowRegistration(context, schemaRegistry, type, schema)) {
            schema = schemaRegistry.register(type, schema);
        } else if (schemaRegistry != null && schemaRegistry.hasRef(type)) {
            schema = schemaRegistry.lookupRef(type);
        }
        return schema;
    }

    static boolean allowRegistration(AnnotationScannerContext context, SchemaRegistry registry, Type type, Schema schema) {
        if (schema == null || registry == null || !registry.isTypeRegistrationSupported(type, schema)) {
            return false;
        }
        return !registry.hasSchema(type);
    }

    private static List<Schema> readClassSchemas(AnnotationScannerContext context, Type[] types, boolean removeCurrent) {
        IoLogging.logger.annotationsList("schema Class");
        Type introspectedClassType = removeCurrent ? context.getScanStack().peek() : null;
        return Arrays.stream(types).filter(type -> !type.equals((Object)introspectedClassType)).map(type -> SchemaFactory.readClassSchema(context, type, true)).collect(Collectors.toList());
    }

    private static Schema otherTypeToSchema(AnnotationScannerContext context, Type type, List<AnnotationScannerExtension> extensions) {
        if (TypeUtil.isA(context, type, MutinyConstants.MULTI_TYPE)) {
            Schema schema = new SchemaImpl().type(Schema.SchemaType.ARRAY);
            Type componentType = (Type)type.asParameterizedType().arguments().get(0);
            schema.setItems(SchemaFactory.typeToSchema(context, componentType, extensions));
            return schema;
        }
        Type asyncType = SchemaFactory.resolveAsyncType(context, type, extensions);
        return SchemaFactory.schemaRegistration(context, asyncType, OpenApiDataObjectScanner.process(context, asyncType));
    }

    static Type resolveAsyncType(AnnotationScannerContext context, Type type, List<AnnotationScannerExtension> extensions) {
        ParameterizedType pType;
        if (type.kind() == Type.Kind.PARAMETERIZED_TYPE && (pType = type.asParameterizedType()).arguments().size() == 1 && TypeUtil.isA(context, type, JDKConstants.COMPLETION_STAGE_TYPE)) {
            return (Type)pType.arguments().get(0);
        }
        for (AnnotationScannerExtension extension : extensions) {
            Type asyncType = extension.resolveAsyncType(type);
            if (asyncType == null) continue;
            return asyncType;
        }
        return type;
    }

    private static Discriminator readDiscriminator(AnnotationScannerContext context, String propertyName, AnnotationInstance[] annotation) {
        if (propertyName == null && annotation == null) {
            return null;
        }
        DiscriminatorImpl discriminator = new DiscriminatorImpl();
        if (propertyName != null) {
            discriminator.setPropertyName(propertyName);
        }
        if (annotation != null) {
            IoLogging.logger.annotationsList("@DiscriminatorMapping");
            Arrays.stream(annotation).forEach(mapping -> SchemaFactory.readDiscriminatorMapping(context, discriminator, mapping));
        }
        return discriminator;
    }

    private static void readDiscriminatorMapping(AnnotationScannerContext context, Discriminator discriminator, AnnotationInstance mapping) {
        Schema schema;
        String propertyValue = (String)JandexUtil.value(mapping, "value");
        Type schemaType = (Type)JandexUtil.value(mapping, "schema");
        String schemaRef = schemaType != null ? ((schema = SchemaFactory.introspectClassToSchema(context, schemaType.asClassType(), true)) != null ? schema.getRef() : null) : null;
        if (propertyValue == null && schemaRef != null) {
            propertyValue = ModelUtil.nameFromRef(schemaRef);
        }
        discriminator.addMapping(propertyValue, schemaRef);
    }

    private static BigDecimal tolerantParseBigDecimal(String value) {
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

