/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.spi;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.FilteredIndexView;
import io.smallrye.openapi.runtime.scanner.dataobject.AugmentedIndexView;
import io.smallrye.openapi.runtime.scanner.dataobject.TypeResolver;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

public class AnnotationScannerContext {
    private final FilteredIndexView index;
    private final AugmentedIndexView augmentedIndex;
    private final List<AnnotationScannerExtension> extensions;
    private final OpenApiConfig config;
    private final ClassLoader classLoader;
    private final OpenAPI openApi;
    private final Deque<Type> scanStack = new ArrayDeque<Type>();
    private Deque<TypeResolver> resolverStack = new ArrayDeque<TypeResolver>();

    public AnnotationScannerContext(FilteredIndexView index, ClassLoader classLoader, List<AnnotationScannerExtension> extensions, OpenApiConfig config, OpenAPI openApi) {
        this.index = index;
        this.augmentedIndex = AugmentedIndexView.augment(index);
        this.classLoader = classLoader;
        this.extensions = extensions;
        this.config = config;
        this.openApi = openApi;
    }

    public AnnotationScannerContext(IndexView index, ClassLoader classLoader, OpenApiConfig config) {
        this(new FilteredIndexView(index, config), classLoader, Collections.emptyList(), config, new OpenAPIImpl());
    }

    public FilteredIndexView getIndex() {
        return this.index;
    }

    public AugmentedIndexView getAugmentedIndex() {
        return this.augmentedIndex;
    }

    public List<AnnotationScannerExtension> getExtensions() {
        return this.extensions;
    }

    public OpenApiConfig getConfig() {
        return this.config;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public OpenAPI getOpenApi() {
        return this.openApi;
    }

    public Deque<Type> getScanStack() {
        return this.scanStack;
    }

    public Deque<TypeResolver> getResolverStack() {
        return this.resolverStack;
    }

    public TypeResolver getResourceTypeResolver() {
        return this.resolverStack.peek();
    }
}

