package io.vertx.mutiny.ext.bridge;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.ext.bridge.BridgeEventType;
import io.vertx.core.json.JsonObject;
import io.vertx.core.Future;

/**
 * Represents an event that occurs on the event bus bridge.
 * <p>
 * Please consult the documentation for a full explanation.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.bridge.BaseBridgeEvent original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.bridge.BaseBridgeEvent.class)
public class BaseBridgeEvent extends io.vertx.mutiny.core.Promise<Boolean> implements io.smallrye.mutiny.vertx.MutinyDelegate {

  public static final io.smallrye.mutiny.vertx.TypeArg<BaseBridgeEvent> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new BaseBridgeEvent((io.vertx.ext.bridge.BaseBridgeEvent) obj),
    BaseBridgeEvent::getDelegate
  );

  private final io.vertx.ext.bridge.BaseBridgeEvent delegate;
  
  public BaseBridgeEvent(io.vertx.ext.bridge.BaseBridgeEvent delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public BaseBridgeEvent(Object delegate) {
    super((io.vertx.ext.bridge.BaseBridgeEvent)delegate);
    this.delegate = (io.vertx.ext.bridge.BaseBridgeEvent)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  BaseBridgeEvent() {
    super(null);
    this.delegate = null;
  }

  @Override
  public io.vertx.ext.bridge.BaseBridgeEvent getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BaseBridgeEvent that = (BaseBridgeEvent) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public void complete(Boolean result) { 
    delegate.complete(result);
  }

  public boolean tryComplete(Boolean arg0) { 
    boolean ret = delegate.tryComplete(arg0);
    return ret;
  }

  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Boolean> future() { 
    return io.smallrye.mutiny.vertx.UniHelper.toUni(delegate.future());}

  public Boolean futureAndAwait() { 
    return future().await().indefinitely();
  }


  public void futureAndForget() { 
    future().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }


  /**
   * @return the type of the event
   */
  public io.vertx.ext.bridge.BridgeEventType type() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.ext.bridge.BridgeEventType ret = delegate.type();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the raw JSON message for the event
   */
  public JsonObject getRawMessage() { 
    JsonObject ret = delegate.getRawMessage();
    return ret;
  }

  /**
   * @param message the raw message
   * @return this reference, so it can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.bridge.BaseBridgeEvent setRawMessage(JsonObject message) { 
    delegate.setRawMessage(message);
    return this;
  }

  private io.vertx.ext.bridge.BridgeEventType cached_0;
  public static  BaseBridgeEvent newInstance(io.vertx.ext.bridge.BaseBridgeEvent arg) {
    return arg != null ? new BaseBridgeEvent(arg) : null;
  }

}
