/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.impl;

import io.smallrye.classfile.BufWriter;
import io.smallrye.classfile.ClassReader;
import io.smallrye.classfile.Label;
import io.smallrye.classfile.MethodModel;
import io.smallrye.classfile.attribute.StackMapFrameInfo;
import io.smallrye.classfile.constantpool.ClassEntry;
import io.smallrye.classfile.extras.reflect.AccessFlag;
import io.smallrye.classfile.impl.BufWriterImpl;
import io.smallrye.classfile.impl.DirectCodeBuilder;
import io.smallrye.classfile.impl.LabelContext;
import io.smallrye.classfile.impl.MethodInfo;
import io.smallrye.classfile.impl.TemporaryConstantPool;
import io.smallrye.classfile.impl.Util;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class StackMapDecoder {
    private static final StackMapFrameInfo[] NO_STACK_FRAME_INFOS = new StackMapFrameInfo[0];
    private final ClassReader classReader;
    private final int pos;
    private final LabelContext ctx;
    private final List<StackMapFrameInfo.VerificationTypeInfo> initFrameLocals;
    private int p;

    StackMapDecoder(ClassReader classReader, int pos, LabelContext ctx, List<StackMapFrameInfo.VerificationTypeInfo> initFrameLocals) {
        this.classReader = classReader;
        this.pos = pos;
        this.ctx = ctx;
        this.initFrameLocals = initFrameLocals;
    }

    static List<StackMapFrameInfo.VerificationTypeInfo> initFrameLocals(MethodModel method) {
        return StackMapDecoder.initFrameLocals(method.parent().orElseThrow().thisClass(), method.methodName().stringValue(), method.methodTypeSymbol(), method.flags().has(AccessFlag.STATIC));
    }

    public static List<StackMapFrameInfo.VerificationTypeInfo> initFrameLocals(ClassEntry thisClass, String methodName, MethodTypeDesc methodType, boolean isStatic) {
        StackMapFrameInfo.VerificationTypeInfo[] vtis;
        int i = 0;
        if (!isStatic) {
            vtis = new StackMapFrameInfo.VerificationTypeInfo[methodType.parameterCount() + 1];
            vtis[i++] = "<init>".equals(methodName) && !ConstantDescs.CD_Object.equals(thisClass.asSymbol()) ? StackMapFrameInfo.SimpleVerificationTypeInfo.UNINITIALIZED_THIS : new ObjectVerificationTypeInfoImpl(thisClass);
        } else {
            vtis = new StackMapFrameInfo.VerificationTypeInfo[methodType.parameterCount()];
        }
        for (int pi = 0; pi < methodType.parameterCount(); ++pi) {
            ClassDesc arg = methodType.parameterType(pi);
            int n = i++;
            vtis[n] = switch (arg.descriptorString().charAt(0)) {
                case 'B', 'C', 'I', 'S', 'Z' -> StackMapFrameInfo.SimpleVerificationTypeInfo.INTEGER;
                case 'J' -> StackMapFrameInfo.SimpleVerificationTypeInfo.LONG;
                case 'F' -> StackMapFrameInfo.SimpleVerificationTypeInfo.FLOAT;
                case 'D' -> StackMapFrameInfo.SimpleVerificationTypeInfo.DOUBLE;
                case 'V' -> throw new IllegalArgumentException("Illegal method argument type: " + String.valueOf(arg));
                default -> new ObjectVerificationTypeInfoImpl(TemporaryConstantPool.INSTANCE.classEntry(arg));
            };
        }
        return List.of(vtis);
    }

    public static void writeFrames(BufWriter b, List<StackMapFrameInfo> entries) {
        BufWriterImpl buf = (BufWriterImpl)b;
        final DirectCodeBuilder dcb = (DirectCodeBuilder)buf.labelContext();
        MethodInfo mi = dcb.methodInfo();
        List<StackMapFrameInfo.VerificationTypeInfo> prevLocals = StackMapDecoder.initFrameLocals(buf.thisClass(), mi.methodName().stringValue(), mi.methodTypeSymbol(), (mi.methodFlags() & 8) != 0);
        int prevOffset = -1;
        StackMapFrameInfo[] infos = entries.toArray(NO_STACK_FRAME_INFOS);
        Arrays.sort(infos, new Comparator<StackMapFrameInfo>(){

            @Override
            public int compare(StackMapFrameInfo o1, StackMapFrameInfo o2) {
                return Integer.compare(dcb.labelToBci(o1.target()), dcb.labelToBci(o2.target()));
            }
        });
        b.writeU2(infos.length);
        for (StackMapFrameInfo fr : infos) {
            int offset = dcb.labelToBci(fr.target());
            if (offset == prevOffset) {
                throw new IllegalArgumentException("Duplicated stack frame bytecode index: " + offset);
            }
            StackMapDecoder.writeFrame(buf, offset - prevOffset - 1, prevLocals, fr);
            prevOffset = offset;
            prevLocals = fr.locals();
        }
    }

    private static void writeFrame(BufWriterImpl out, int offsetDelta, List<StackMapFrameInfo.VerificationTypeInfo> prevLocals, StackMapFrameInfo fr) {
        if (offsetDelta < 0) {
            throw new IllegalArgumentException("Invalid stack map frames order");
        }
        if (fr.stack().isEmpty()) {
            int commonLocalsSize = Math.min(prevLocals.size(), fr.locals().size());
            int diffLocalsSize = fr.locals().size() - prevLocals.size();
            if (-3 <= diffLocalsSize && diffLocalsSize <= 3 && StackMapDecoder.equals(fr.locals(), prevLocals, commonLocalsSize)) {
                if (diffLocalsSize == 0 && offsetDelta <= 63) {
                    out.writeU1(offsetDelta);
                } else {
                    out.writeU1U2(251 + diffLocalsSize, offsetDelta);
                    for (int i = commonLocalsSize; i < fr.locals().size(); ++i) {
                        StackMapDecoder.writeTypeInfo(out, fr.locals().get(i));
                    }
                }
                return;
            }
        } else if (fr.stack().size() == 1 && fr.locals().equals(prevLocals)) {
            if (offsetDelta <= 63) {
                out.writeU1(64 + offsetDelta);
            } else {
                out.writeU1U2(247, offsetDelta);
            }
            StackMapDecoder.writeTypeInfo(out, fr.stack().get(0));
            return;
        }
        out.writeU1U2U2(255, offsetDelta, fr.locals().size());
        for (StackMapFrameInfo.VerificationTypeInfo l : fr.locals()) {
            StackMapDecoder.writeTypeInfo(out, l);
        }
        out.writeU2(fr.stack().size());
        for (StackMapFrameInfo.VerificationTypeInfo s : fr.stack()) {
            StackMapDecoder.writeTypeInfo(out, s);
        }
    }

    private static boolean equals(List<StackMapFrameInfo.VerificationTypeInfo> l1, List<StackMapFrameInfo.VerificationTypeInfo> l2, int compareSize) {
        for (int i = 0; i < compareSize; ++i) {
            if (l1.get(i).equals(l2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static void writeTypeInfo(BufWriterImpl bw, StackMapFrameInfo.VerificationTypeInfo vti) {
        int tag = vti.tag();
        switch (tag) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                bw.writeU1(tag);
                break;
            }
            case 7: {
                bw.writeU1U2(tag, bw.cpIndex(((StackMapFrameInfo.ObjectVerificationTypeInfo)vti).className()));
                break;
            }
            case 8: {
                bw.writeU1U2(tag, bw.labelContext().labelToBci(((StackMapFrameInfo.UninitializedVerificationTypeInfo)vti).newTarget()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid verification type tag: " + vti.tag());
            }
        }
    }

    List<StackMapFrameInfo> entries() {
        this.p = this.pos;
        List<StackMapFrameInfo.VerificationTypeInfo> locals = this.initFrameLocals;
        List<Object> stack = List.of();
        int bci = -1;
        StackMapFrameInfo[] entries = new StackMapFrameInfo[this.u2()];
        for (int ei = 0; ei < entries.length; ++ei) {
            int frameType;
            if ((frameType = this.classReader.readU1(this.p++)) <= 63) {
                bci += frameType + 1;
                stack = List.of();
            } else if (frameType <= 127) {
                bci += frameType - 64 + 1;
                stack = List.of(this.readVerificationTypeInfo());
            } else {
                if (frameType < 247) {
                    throw new IllegalArgumentException("Invalid stackmap frame type: " + frameType);
                }
                bci += this.u2() + 1;
                if (frameType == 247) {
                    stack = List.of(this.readVerificationTypeInfo());
                } else if (frameType < 251) {
                    locals = locals.subList(0, locals.size() + frameType - 251);
                    stack = List.of();
                } else if (frameType == 251) {
                    stack = List.of();
                } else if (frameType <= 254) {
                    int actSize = locals.size();
                    StackMapFrameInfo.VerificationTypeInfo[] newLocals = locals.toArray(new StackMapFrameInfo.VerificationTypeInfo[actSize + frameType - 251]);
                    for (i = actSize; i < newLocals.length; ++i) {
                        newLocals[i] = this.readVerificationTypeInfo();
                    }
                    locals = List.of(newLocals);
                    stack = List.of();
                } else {
                    StackMapFrameInfo.VerificationTypeInfo[] newLocals = new StackMapFrameInfo.VerificationTypeInfo[this.u2()];
                    for (int i = 0; i < newLocals.length; ++i) {
                        newLocals[i] = this.readVerificationTypeInfo();
                    }
                    StackMapFrameInfo.VerificationTypeInfo[] newStack = new StackMapFrameInfo.VerificationTypeInfo[this.u2()];
                    for (i = 0; i < newStack.length; ++i) {
                        newStack[i] = this.readVerificationTypeInfo();
                    }
                    locals = List.of(newLocals);
                    stack = List.of(newStack);
                }
            }
            entries[ei] = new StackMapFrameImpl(frameType, this.ctx.getLabel(bci), locals, stack);
        }
        return List.of(entries);
    }

    private StackMapFrameInfo.VerificationTypeInfo readVerificationTypeInfo() {
        int tag = this.classReader.readU1(this.p++);
        return switch (tag) {
            case 0 -> StackMapFrameInfo.SimpleVerificationTypeInfo.TOP;
            case 1 -> StackMapFrameInfo.SimpleVerificationTypeInfo.INTEGER;
            case 2 -> StackMapFrameInfo.SimpleVerificationTypeInfo.FLOAT;
            case 3 -> StackMapFrameInfo.SimpleVerificationTypeInfo.DOUBLE;
            case 4 -> StackMapFrameInfo.SimpleVerificationTypeInfo.LONG;
            case 5 -> StackMapFrameInfo.SimpleVerificationTypeInfo.NULL;
            case 6 -> StackMapFrameInfo.SimpleVerificationTypeInfo.UNINITIALIZED_THIS;
            case 7 -> new ObjectVerificationTypeInfoImpl(this.classReader.entryByIndex(this.u2(), ClassEntry.class));
            case 8 -> new UninitializedVerificationTypeInfoImpl(this.ctx.getLabel(this.u2()));
            default -> throw new IllegalArgumentException("Invalid verification type tag: " + tag);
        };
    }

    private int u2() {
        int v = this.classReader.readU2(this.p);
        this.p += 2;
        return v;
    }

    public record ObjectVerificationTypeInfoImpl(ClassEntry className) implements StackMapFrameInfo.ObjectVerificationTypeInfo
    {
        public ObjectVerificationTypeInfoImpl {
            Objects.requireNonNull(className);
        }

        @Override
        public int tag() {
            return 7;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof ObjectVerificationTypeInfoImpl) {
                ObjectVerificationTypeInfoImpl that = (ObjectVerificationTypeInfoImpl)o;
                return Objects.equals(this.className, that.className);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.className);
        }

        @Override
        public String toString() {
            return this.className.asInternalName();
        }
    }

    public record StackMapFrameImpl(int frameType, Label target, List<StackMapFrameInfo.VerificationTypeInfo> locals, List<StackMapFrameInfo.VerificationTypeInfo> stack) implements StackMapFrameInfo
    {
        public StackMapFrameImpl {
            Objects.requireNonNull(target);
            locals = Util.sanitizeU2List(locals);
            stack = Util.sanitizeU2List(stack);
        }
    }

    public record UninitializedVerificationTypeInfoImpl(Label newTarget) implements StackMapFrameInfo.UninitializedVerificationTypeInfo
    {
        public UninitializedVerificationTypeInfoImpl {
            Objects.requireNonNull(newTarget);
        }

        @Override
        public int tag() {
            return 8;
        }

        @Override
        public String toString() {
            return "UNINIT(" + String.valueOf(this.newTarget) + ")";
        }
    }
}

