/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.impl;

import io.smallrye.classfile.ClassSignature;
import io.smallrye.classfile.MethodSignature;
import io.smallrye.classfile.Signature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class SignaturesImpl {
    private final String sig;
    private int sigp;
    private static final long SMALL_NON_IDENTIFIER_CHARS_SET = 0x5C00C00000000000L;

    public SignaturesImpl(String signature) {
        this.sig = Objects.requireNonNull(signature);
        this.sigp = 0;
    }

    public ClassSignature parseClassSignature() {
        try {
            List<Signature.TypeParam> typeParamTypes = this.parseParamTypes();
            Signature.ClassTypeSig superclass = this.classTypeSig();
            ArrayList<Signature.ClassTypeSig> superinterfaces = null;
            while (this.sigp < this.sig.length()) {
                if (superinterfaces == null) {
                    superinterfaces = new ArrayList<Signature.ClassTypeSig>();
                }
                superinterfaces.add(this.classTypeSig());
            }
            return new ClassSignatureImpl(typeParamTypes, superclass, SignaturesImpl.null2Empty(superinterfaces));
        }
        catch (IndexOutOfBoundsException e) {
            throw this.error("Not a valid class signature");
        }
    }

    public MethodSignature parseMethodSignature() {
        try {
            List<Signature.TypeParam> typeParamTypes = this.parseParamTypes();
            this.require('(');
            ArrayList<Signature> paramTypes = null;
            while (!this.match(')')) {
                if (paramTypes == null) {
                    paramTypes = new ArrayList<Signature>();
                }
                paramTypes.add(SignaturesImpl.validateNonVoid(this.typeSig()));
            }
            Signature returnType = this.typeSig();
            ArrayList<Signature.ThrowableSig> throwsTypes = null;
            while (this.sigp < this.sig.length()) {
                Signature.RefTypeSig t;
                this.require('^');
                if (throwsTypes == null) {
                    throwsTypes = new ArrayList<Signature.ThrowableSig>();
                }
                if ((t = this.referenceTypeSig()) instanceof Signature.ThrowableSig) {
                    Signature.ThrowableSig ts = (Signature.ThrowableSig)((Object)t);
                    throwsTypes.add(ts);
                    continue;
                }
                throw this.error("Not a valid throwable signature %s in".formatted(t.signatureString()));
            }
            return new MethodSignatureImpl(typeParamTypes, SignaturesImpl.null2Empty(throwsTypes), returnType, SignaturesImpl.null2Empty(paramTypes));
        }
        catch (IndexOutOfBoundsException e) {
            throw this.error("Not a valid method signature");
        }
    }

    public Signature parseSignature() {
        try {
            Signature s = this.typeSig();
            if (this.sigp == this.sig.length()) {
                return s;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        throw this.error("Not a valid type signature");
    }

    private List<Signature.TypeParam> parseParamTypes() {
        ArrayList<TypeParamImpl> typeParamTypes = null;
        if (this.match('<')) {
            typeParamTypes = new ArrayList<TypeParamImpl>();
            do {
                char limit;
                int p;
                String name = this.sig.substring(this.sigp, this.requireIdentifier());
                Signature.RefTypeSig classBound = null;
                ArrayList<Signature.RefTypeSig> interfaceBounds = null;
                this.require(':');
                if (this.sig.charAt(this.sigp) != ':' && (p = SignaturesImpl.nextIdentifierEnd(this.sig, this.sigp)) < this.sig.length() && (limit = this.sig.charAt(p)) != '>' && limit != ':') {
                    classBound = this.referenceTypeSig();
                }
                while (this.match(':')) {
                    if (interfaceBounds == null) {
                        interfaceBounds = new ArrayList<Signature.RefTypeSig>();
                    }
                    interfaceBounds.add(this.referenceTypeSig());
                }
                typeParamTypes.add(new TypeParamImpl(name, Optional.ofNullable(classBound), SignaturesImpl.null2Empty(interfaceBounds)));
            } while (!this.match('>'));
        }
        return SignaturesImpl.null2Empty(typeParamTypes);
    }

    private Signature typeSig() {
        char c = this.sig.charAt(this.sigp++);
        return switch (c) {
            case 'B', 'C', 'D', 'F', 'I', 'J', 'S', 'V', 'Z' -> Signature.BaseTypeSig.of(c);
            default -> {
                --this.sigp;
                yield this.referenceTypeSig();
            }
        };
    }

    private Signature.RefTypeSig referenceTypeSig() {
        return switch (this.sig.charAt(this.sigp)) {
            case 'L' -> this.classTypeSig();
            case 'T' -> {
                ++this.sigp;
                Signature.TypeVarSig ty = Signature.TypeVarSig.of(this.sig.substring(this.sigp, this.requireIdentifier()));
                this.require(';');
                yield ty;
            }
            case '[' -> {
                ++this.sigp;
                yield Signature.ArrayTypeSig.of(this.typeSig());
            }
            default -> throw this.unexpectedError("a type signature");
        };
    }

    private Signature.TypeArg typeArg() {
        char c = this.sig.charAt(this.sigp++);
        return switch (c) {
            case '*' -> Signature.TypeArg.unbounded();
            case '+' -> Signature.TypeArg.extendsOf(this.referenceTypeSig());
            case '-' -> Signature.TypeArg.superOf(this.referenceTypeSig());
            default -> {
                --this.sigp;
                yield Signature.TypeArg.of(this.referenceTypeSig());
            }
        };
    }

    private Signature.ClassTypeSig classTypeSig() {
        block6: {
            boolean end;
            this.require('L');
            ClassTypeSigImpl t = null;
            do {
                ArrayList<Signature.TypeArg> argTypes;
                int start = this.sigp;
                this.requireIdentifier();
                if (t == null) {
                    while (this.match('/')) {
                        this.requireIdentifier();
                    }
                }
                String className = this.sig.substring(start, this.sigp);
                if (this.match('<')) {
                    argTypes = new ArrayList<Signature.TypeArg>();
                    do {
                        argTypes.add(this.typeArg());
                    } while (!this.match('>'));
                } else {
                    argTypes = null;
                }
                end = this.match(';');
                if (!end && !this.match('.')) break block6;
                t = new ClassTypeSigImpl(Optional.ofNullable(t), className, SignaturesImpl.null2Empty(argTypes));
            } while (!end);
            return t;
        }
        throw this.unexpectedError(". or ;");
    }

    private boolean match(char c) {
        if (this.sigp < this.sig.length() && this.sig.charAt(this.sigp) == c) {
            ++this.sigp;
            return true;
        }
        return false;
    }

    private void require(char c) {
        if (!this.match(c)) {
            throw this.unexpectedError(String.valueOf(c));
        }
    }

    private int requireIdentifier() {
        int start = this.sigp;
        while (this.sigp < this.sig.length() && !SignaturesImpl.isNonIdentifierChar(this.sig.charAt(this.sigp))) {
            ++this.sigp;
        }
        if (start == this.sigp) {
            throw this.unexpectedError("an identifier");
        }
        return this.sigp;
    }

    private static boolean isNonIdentifierChar(char c) {
        return c < '@' ? (0x5C00C00000000000L & 1L << c) != 0L : c == '[';
    }

    public static int nextIdentifierEnd(String st, int start) {
        int end = st.length();
        for (int i = start; i < end; ++i) {
            if (!SignaturesImpl.isNonIdentifierChar(st.charAt(i))) continue;
            return i;
        }
        return end;
    }

    public static String validateIdentifier(String st) {
        int len = st.length();
        if (len == 0 || SignaturesImpl.nextIdentifierEnd(st, 0) != len) {
            throw new IllegalArgumentException("Not a valid identifier: " + st);
        }
        return st;
    }

    public static String validatePackageSpecifierPlusIdentifier(String st) {
        int nextIdentifierStart = 0;
        int len = st.length();
        while (nextIdentifierStart < len) {
            int end = SignaturesImpl.nextIdentifierEnd(st, nextIdentifierStart);
            if (end == len) {
                return st;
            }
            if (end == nextIdentifierStart || st.charAt(end) != '/') {
                throw new IllegalArgumentException("Not a class name: " + st);
            }
            nextIdentifierStart = end + 1;
        }
        throw new IllegalArgumentException("Not a class name: " + st);
    }

    public static Signature validateNonVoid(Signature incoming) {
        Signature.BaseTypeSig baseType;
        Objects.requireNonNull(incoming);
        if (incoming instanceof Signature.BaseTypeSig && (baseType = (Signature.BaseTypeSig)incoming).baseType() == 'V') {
            throw new IllegalArgumentException("void");
        }
        return incoming;
    }

    public static List<Signature> validateArgumentList(Signature[] signatures) {
        return SignaturesImpl.validateArgumentList(List.of(signatures));
    }

    public static List<Signature> validateArgumentList(List<Signature> signatures) {
        List<Signature> res = List.copyOf(signatures);
        for (Signature sig : signatures) {
            Signature.BaseTypeSig baseType;
            if (!(sig instanceof Signature.BaseTypeSig) || (baseType = (Signature.BaseTypeSig)sig).baseType() != 'V') continue;
            throw new IllegalArgumentException("void");
        }
        return res;
    }

    private static StringBuilder printTypeParameters(List<Signature.TypeParam> typeParameters) {
        StringBuilder sb = new StringBuilder();
        if (!typeParameters.isEmpty()) {
            sb.append('<');
            for (Signature.TypeParam tp : typeParameters) {
                sb.append(tp.identifier()).append(':');
                if (tp.classBound().isPresent()) {
                    sb.append(tp.classBound().get().signatureString());
                }
                for (Signature.RefTypeSig is : tp.interfaceBounds()) {
                    sb.append(':').append(is.signatureString());
                }
            }
            sb.append('>');
        }
        return sb;
    }

    private static <T> List<T> null2Empty(ArrayList<T> l) {
        return l == null ? List.of() : Collections.unmodifiableList(l);
    }

    private IllegalArgumentException unexpectedError(String expected) {
        return this.error(this.sigp < this.sig.length() ? "Unexpected character %c at position %d, expected %s".formatted(Character.valueOf(this.sig.charAt(this.sigp)), this.sigp, expected) : "Unexpected end of signature at position %d, expected %s".formatted(this.sigp, expected));
    }

    private IllegalArgumentException error(String message) {
        return new IllegalArgumentException("%s: %s".formatted(message, this.sig));
    }

    public record ClassSignatureImpl(List<Signature.TypeParam> typeParameters, Signature.ClassTypeSig superclassSignature, List<Signature.ClassTypeSig> superinterfaceSignatures) implements ClassSignature
    {
        @Override
        public String signatureString() {
            StringBuilder sb = SignaturesImpl.printTypeParameters(this.typeParameters);
            sb.append(this.superclassSignature.signatureString());
            for (Signature.ClassTypeSig in : this.superinterfaceSignatures) {
                sb.append(in.signatureString());
            }
            return sb.toString();
        }
    }

    public record MethodSignatureImpl(List<Signature.TypeParam> typeParameters, List<Signature.ThrowableSig> throwableSignatures, Signature result, List<Signature> arguments) implements MethodSignature
    {
        @Override
        public String signatureString() {
            StringBuilder sb = SignaturesImpl.printTypeParameters(this.typeParameters);
            sb.append('(');
            for (Signature a : this.arguments) {
                sb.append(a.signatureString());
            }
            sb.append(')').append(this.result.signatureString());
            if (!this.throwableSignatures.isEmpty()) {
                for (Signature.ThrowableSig t : this.throwableSignatures) {
                    sb.append('^').append(t.signatureString());
                }
            }
            return sb.toString();
        }
    }

    public record TypeParamImpl(String identifier, Optional<Signature.RefTypeSig> classBound, List<Signature.RefTypeSig> interfaceBounds) implements Signature.TypeParam
    {
    }

    public record ClassTypeSigImpl(Optional<Signature.ClassTypeSig> outerType, String className, List<Signature.TypeArg> typeArgs) implements Signature.ClassTypeSig
    {
        @Override
        public String signatureString() {
            Object prefix = "L";
            if (this.outerType.isPresent()) {
                prefix = this.outerType.get().signatureString();
                assert (((String)prefix).charAt(((String)prefix).length() - 1) == ';');
                prefix = ((String)prefix).substring(0, ((String)prefix).length() - 1) + ".";
            }
            String suffix = ";";
            if (!this.typeArgs.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append('<');
                for (Signature.TypeArg ta : this.typeArgs) {
                    if (ta instanceof Signature.TypeArg.Bounded) {
                        Signature.TypeArg.Bounded b = (Signature.TypeArg.Bounded)ta;
                        switch (b.wildcardIndicator()) {
                            case SUPER: {
                                sb.append('-');
                                break;
                            }
                            case EXTENDS: {
                                sb.append('+');
                            }
                        }
                        sb.append(b.boundType().signatureString());
                        continue;
                    }
                    if (!(ta instanceof Signature.TypeArg.Unbounded)) continue;
                    sb.append('*');
                }
                suffix = sb.append(">;").toString();
            }
            return (String)prefix + this.className + suffix;
        }
    }

    public record TypeArgImpl(Signature.TypeArg.Bounded.WildcardIndicator wildcardIndicator, Signature.RefTypeSig boundType) implements Signature.TypeArg.Bounded
    {
    }

    public static enum UnboundedTypeArgImpl implements Signature.TypeArg.Unbounded
    {
        INSTANCE;

    }

    public record ArrayTypeSigImpl(int arrayDepth, Signature elemType) implements Signature.ArrayTypeSig
    {
        @Override
        public Signature componentSignature() {
            return this.arrayDepth > 1 ? new ArrayTypeSigImpl(this.arrayDepth - 1, this.elemType) : this.elemType;
        }

        @Override
        public String signatureString() {
            return "[".repeat(this.arrayDepth) + this.elemType.signatureString();
        }
    }

    public record TypeVarSigImpl(String identifier) implements Signature.TypeVarSig
    {
        @Override
        public String signatureString() {
            return "T" + this.identifier + ";";
        }
    }

    public record BaseTypeSigImpl(char baseType) implements Signature.BaseTypeSig
    {
        @Override
        public String signatureString() {
            return "" + this.baseType;
        }
    }
}

