/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.impl;

import io.smallrye.classfile.CustomAttribute;
import io.smallrye.classfile.FieldBuilder;
import io.smallrye.classfile.FieldElement;
import io.smallrye.classfile.FieldModel;
import io.smallrye.classfile.constantpool.Utf8Entry;
import io.smallrye.classfile.impl.AbstractDirectBuilder;
import io.smallrye.classfile.impl.AbstractElement;
import io.smallrye.classfile.impl.BufWriterImpl;
import io.smallrye.classfile.impl.ClassFileImpl;
import io.smallrye.classfile.impl.SplitConstantPool;
import io.smallrye.classfile.impl.TerminalFieldBuilder;
import io.smallrye.classfile.impl.Util;
import java.util.Objects;
import java.util.function.Consumer;

public final class DirectFieldBuilder
extends AbstractDirectBuilder<FieldModel>
implements TerminalFieldBuilder,
Util.Writable {
    private final Utf8Entry name;
    private final Utf8Entry desc;
    private int flags;

    public DirectFieldBuilder(SplitConstantPool constantPool, ClassFileImpl context, Utf8Entry name, Utf8Entry type, int flags, FieldModel original) {
        super(constantPool, context);
        this.setOriginal(original);
        this.name = Objects.requireNonNull(name);
        this.desc = Objects.requireNonNull(type);
        this.flags = Util.checkFlags(flags);
    }

    @Override
    public FieldBuilder with(FieldElement element) {
        if (element instanceof AbstractElement) {
            AbstractElement ae = (AbstractElement)((Object)element);
            ae.writeTo(this);
        } else {
            this.writeAttribute((CustomAttribute)Objects.requireNonNull(element));
        }
        return this;
    }

    public DirectFieldBuilder run(Consumer<? super FieldBuilder> handler) {
        handler.accept(this);
        return this;
    }

    @Override
    public FieldBuilder withFlags(int flags) {
        this.setFlags(Util.checkFlags(flags));
        return this;
    }

    void setFlags(int flags) {
        this.flags = flags;
    }

    @Override
    public void writeTo(BufWriterImpl buf) {
        buf.writeU2U2U2(this.flags, buf.cpIndex(this.name), buf.cpIndex(this.desc));
        this.attributes.writeTo(buf);
    }
}

