/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.impl;

import io.smallrye.classfile.Label;
import io.smallrye.classfile.impl.AbstractElement;
import io.smallrye.classfile.impl.CodeImpl;
import io.smallrye.classfile.impl.DirectCodeBuilder;
import io.smallrye.classfile.instruction.CharacterRange;

public final class BoundCharacterRange
extends AbstractElement
implements CharacterRange {
    private final CodeImpl code;
    private final int offset;

    public BoundCharacterRange(CodeImpl code, int offset) {
        this.code = code;
        this.offset = offset;
    }

    int startPc() {
        return this.code.classReader.readU2(this.offset);
    }

    int endPc() {
        return this.code.classReader.readU2(this.offset + 2);
    }

    @Override
    public int characterRangeStart() {
        return this.code.classReader.readInt(this.offset + 4);
    }

    @Override
    public int characterRangeEnd() {
        return this.code.classReader.readInt(this.offset + 8);
    }

    @Override
    public int flags() {
        return this.code.classReader.readU2(this.offset + 12);
    }

    @Override
    public Label startScope() {
        return this.code.getLabel(this.startPc());
    }

    @Override
    public Label endScope() {
        return this.code.getLabel(this.endPc() + 1);
    }

    @Override
    public void writeTo(DirectCodeBuilder builder) {
        builder.addCharacterRange(this);
    }

    public String toString() {
        return String.format("CharacterRange[startScope=%s, endScope=%s, characterRangeStart=%s, characterRangeEnd=%s, flags=%d]", this.startScope(), this.endScope(), this.characterRangeStart(), this.characterRangeEnd(), this.flags());
    }
}

