/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.impl;

import io.smallrye.classfile.Annotation;
import io.smallrye.classfile.Attribute;
import io.smallrye.classfile.AttributeMapper;
import io.smallrye.classfile.AttributedElement;
import io.smallrye.classfile.BootstrapMethodEntry;
import io.smallrye.classfile.BufWriter;
import io.smallrye.classfile.ClassReader;
import io.smallrye.classfile.attribute.AnnotationDefaultAttribute;
import io.smallrye.classfile.attribute.BootstrapMethodsAttribute;
import io.smallrye.classfile.attribute.CharacterRangeInfo;
import io.smallrye.classfile.attribute.CharacterRangeTableAttribute;
import io.smallrye.classfile.attribute.CodeAttribute;
import io.smallrye.classfile.attribute.CompilationIDAttribute;
import io.smallrye.classfile.attribute.ConstantValueAttribute;
import io.smallrye.classfile.attribute.DeprecatedAttribute;
import io.smallrye.classfile.attribute.EnclosingMethodAttribute;
import io.smallrye.classfile.attribute.ExceptionsAttribute;
import io.smallrye.classfile.attribute.InnerClassInfo;
import io.smallrye.classfile.attribute.InnerClassesAttribute;
import io.smallrye.classfile.attribute.LineNumberInfo;
import io.smallrye.classfile.attribute.LineNumberTableAttribute;
import io.smallrye.classfile.attribute.LocalVariableInfo;
import io.smallrye.classfile.attribute.LocalVariableTableAttribute;
import io.smallrye.classfile.attribute.LocalVariableTypeInfo;
import io.smallrye.classfile.attribute.LocalVariableTypeTableAttribute;
import io.smallrye.classfile.attribute.MethodParameterInfo;
import io.smallrye.classfile.attribute.MethodParametersAttribute;
import io.smallrye.classfile.attribute.ModuleAttribute;
import io.smallrye.classfile.attribute.ModuleExportInfo;
import io.smallrye.classfile.attribute.ModuleHashInfo;
import io.smallrye.classfile.attribute.ModuleHashesAttribute;
import io.smallrye.classfile.attribute.ModuleMainClassAttribute;
import io.smallrye.classfile.attribute.ModuleOpenInfo;
import io.smallrye.classfile.attribute.ModulePackagesAttribute;
import io.smallrye.classfile.attribute.ModuleProvideInfo;
import io.smallrye.classfile.attribute.ModuleRequireInfo;
import io.smallrye.classfile.attribute.ModuleResolutionAttribute;
import io.smallrye.classfile.attribute.ModuleTargetAttribute;
import io.smallrye.classfile.attribute.NestHostAttribute;
import io.smallrye.classfile.attribute.NestMembersAttribute;
import io.smallrye.classfile.attribute.PermittedSubclassesAttribute;
import io.smallrye.classfile.attribute.RecordAttribute;
import io.smallrye.classfile.attribute.RecordComponentInfo;
import io.smallrye.classfile.attribute.RuntimeInvisibleAnnotationsAttribute;
import io.smallrye.classfile.attribute.RuntimeInvisibleParameterAnnotationsAttribute;
import io.smallrye.classfile.attribute.RuntimeInvisibleTypeAnnotationsAttribute;
import io.smallrye.classfile.attribute.RuntimeVisibleAnnotationsAttribute;
import io.smallrye.classfile.attribute.RuntimeVisibleParameterAnnotationsAttribute;
import io.smallrye.classfile.attribute.RuntimeVisibleTypeAnnotationsAttribute;
import io.smallrye.classfile.attribute.SignatureAttribute;
import io.smallrye.classfile.attribute.SourceDebugExtensionAttribute;
import io.smallrye.classfile.attribute.SourceFileAttribute;
import io.smallrye.classfile.attribute.SourceIDAttribute;
import io.smallrye.classfile.attribute.StackMapTableAttribute;
import io.smallrye.classfile.attribute.SyntheticAttribute;
import io.smallrye.classfile.impl.AnnotationReader;
import io.smallrye.classfile.impl.BootstrapMethodEntryImpl;
import io.smallrye.classfile.impl.BoundAttribute;
import io.smallrye.classfile.impl.BufWriterImpl;
import io.smallrye.classfile.impl.CodeImpl;
import io.smallrye.classfile.impl.StackMapDecoder;
import io.smallrye.classfile.impl.Util;
import java.util.List;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AbstractAttributeMapper<T extends Attribute<T>>
implements AttributeMapper<T> {
    private final String name;
    private final AttributeMapper.AttributeStability stability;
    private final boolean allowMultiple;

    protected abstract void writeBody(BufWriter var1, T var2);

    public AbstractAttributeMapper(String name, AttributeMapper.AttributeStability stability) {
        this(name, stability, false);
    }

    public AbstractAttributeMapper(String name, AttributeMapper.AttributeStability stability, boolean allowMultiple) {
        this.name = name;
        this.stability = stability;
        this.allowMultiple = allowMultiple;
    }

    @Override
    public final String name() {
        return this.name;
    }

    @Override
    public final void writeAttribute(BufWriter writer, T attr) {
        BufWriterImpl buf = (BufWriterImpl)writer;
        buf.writeIndex(attr.attributeName());
        int lengthIndex = buf.skip(4);
        this.writeBody(buf, attr);
        int written = buf.size() - lengthIndex - 4;
        buf.patchInt(lengthIndex, written);
    }

    @Override
    public AttributeMapper.AttributeStability stability() {
        return this.stability;
    }

    @Override
    public boolean allowMultiple() {
        return this.allowMultiple;
    }

    public String toString() {
        return String.format("AttributeMapper[name=%s, allowMultiple=%b, stability=%s]", new Object[]{this.name, this.allowMultiple, this.stability()});
    }

    public static final class SyntheticMapper
    extends AbstractAttributeMapper<SyntheticAttribute> {
        public static final SyntheticMapper INSTANCE = new SyntheticMapper();

        private SyntheticMapper() {
            super("Synthetic", AttributeMapper.AttributeStability.STATELESS, true);
        }

        @Override
        public SyntheticAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundSyntheticAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, SyntheticAttribute attr) {
        }
    }

    public static final class StackMapTableMapper
    extends AbstractAttributeMapper<StackMapTableAttribute> {
        public static final StackMapTableMapper INSTANCE = new StackMapTableMapper();

        private StackMapTableMapper() {
            super("StackMapTable", AttributeMapper.AttributeStability.LABELS);
        }

        @Override
        public StackMapTableAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundStackMapTableAttribute((CodeImpl)e, cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter b, StackMapTableAttribute attr) {
            StackMapDecoder.writeFrames(b, attr.entries());
        }
    }

    public static final class SourceIDMapper
    extends AbstractAttributeMapper<SourceIDAttribute> {
        public static final SourceIDMapper INSTANCE = new SourceIDMapper();

        private SourceIDMapper() {
            super("SourceID", AttributeMapper.AttributeStability.CP_REFS);
        }

        @Override
        public SourceIDAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundSourceIDAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, SourceIDAttribute attr) {
            buf.writeIndex(attr.sourceId());
        }
    }

    public static final class SourceFileMapper
    extends AbstractAttributeMapper<SourceFileAttribute> {
        public static final SourceFileMapper INSTANCE = new SourceFileMapper();

        private SourceFileMapper() {
            super("SourceFile", AttributeMapper.AttributeStability.CP_REFS);
        }

        @Override
        public SourceFileAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundSourceFileAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, SourceFileAttribute attr) {
            buf.writeIndex(attr.sourceFile());
        }
    }

    public static final class SourceDebugExtensionMapper
    extends AbstractAttributeMapper<SourceDebugExtensionAttribute> {
        public static final SourceDebugExtensionMapper INSTANCE = new SourceDebugExtensionMapper();

        private SourceDebugExtensionMapper() {
            super("SourceDebugExtension", AttributeMapper.AttributeStability.STATELESS);
        }

        @Override
        public SourceDebugExtensionAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundSourceDebugExtensionAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, SourceDebugExtensionAttribute attr) {
            buf.writeBytes(attr.contents());
        }
    }

    public static final class SignatureMapper
    extends AbstractAttributeMapper<SignatureAttribute> {
        public static final SignatureMapper INSTANCE = new SignatureMapper();

        private SignatureMapper() {
            super("Signature", AttributeMapper.AttributeStability.CP_REFS);
        }

        @Override
        public SignatureAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundSignatureAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, SignatureAttribute attr) {
            buf.writeIndex(attr.signature());
        }
    }

    public static final class RuntimeVisibleTypeAnnotationsMapper
    extends AbstractAttributeMapper<RuntimeVisibleTypeAnnotationsAttribute> {
        public static final RuntimeVisibleTypeAnnotationsMapper INSTANCE = new RuntimeVisibleTypeAnnotationsMapper();

        private RuntimeVisibleTypeAnnotationsMapper() {
            super("RuntimeVisibleTypeAnnotations", AttributeMapper.AttributeStability.UNSTABLE);
        }

        @Override
        public RuntimeVisibleTypeAnnotationsAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundRuntimeVisibleTypeAnnotationsAttribute(e, cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, RuntimeVisibleTypeAnnotationsAttribute attr) {
            AnnotationReader.writeTypeAnnotations(buf, attr.annotations());
        }
    }

    public static final class RuntimeVisibleParameterAnnotationsMapper
    extends AbstractAttributeMapper<RuntimeVisibleParameterAnnotationsAttribute> {
        public static final RuntimeVisibleParameterAnnotationsMapper INSTANCE = new RuntimeVisibleParameterAnnotationsMapper();

        private RuntimeVisibleParameterAnnotationsMapper() {
            super("RuntimeVisibleParameterAnnotations", AttributeMapper.AttributeStability.CP_REFS);
        }

        @Override
        public RuntimeVisibleParameterAnnotationsAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundRuntimeVisibleParameterAnnotationsAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, RuntimeVisibleParameterAnnotationsAttribute attr) {
            List<List<Annotation>> lists = attr.parameterAnnotations();
            buf.writeU1(lists.size());
            for (List<Annotation> list : lists) {
                AnnotationReader.writeAnnotations(buf, list);
            }
        }
    }

    public static final class RuntimeVisibleAnnotationsMapper
    extends AbstractAttributeMapper<RuntimeVisibleAnnotationsAttribute> {
        public static final RuntimeVisibleAnnotationsMapper INSTANCE = new RuntimeVisibleAnnotationsMapper();

        private RuntimeVisibleAnnotationsMapper() {
            super("RuntimeVisibleAnnotations", AttributeMapper.AttributeStability.CP_REFS);
        }

        @Override
        public RuntimeVisibleAnnotationsAttribute readAttribute(AttributedElement enclosing, ClassReader cf, int pos) {
            return new BoundAttribute.BoundRuntimeVisibleAnnotationsAttribute(cf, pos);
        }

        @Override
        protected void writeBody(BufWriter buf, RuntimeVisibleAnnotationsAttribute attr) {
            AnnotationReader.writeAnnotations(buf, attr.annotations());
        }
    }

    public static final class RuntimeInvisibleTypeAnnotationsMapper
    extends AbstractAttributeMapper<RuntimeInvisibleTypeAnnotationsAttribute> {
        public static final RuntimeInvisibleTypeAnnotationsMapper INSTANCE = new RuntimeInvisibleTypeAnnotationsMapper();

        private RuntimeInvisibleTypeAnnotationsMapper() {
            super("RuntimeInvisibleTypeAnnotations", AttributeMapper.AttributeStability.UNSTABLE);
        }

        @Override
        public RuntimeInvisibleTypeAnnotationsAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundRuntimeInvisibleTypeAnnotationsAttribute(e, cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, RuntimeInvisibleTypeAnnotationsAttribute attr) {
            AnnotationReader.writeTypeAnnotations(buf, attr.annotations());
        }
    }

    public static final class RuntimeInvisibleParameterAnnotationsMapper
    extends AbstractAttributeMapper<RuntimeInvisibleParameterAnnotationsAttribute> {
        public static final RuntimeInvisibleParameterAnnotationsMapper INSTANCE = new RuntimeInvisibleParameterAnnotationsMapper();

        private RuntimeInvisibleParameterAnnotationsMapper() {
            super("RuntimeInvisibleParameterAnnotations", AttributeMapper.AttributeStability.CP_REFS);
        }

        @Override
        public RuntimeInvisibleParameterAnnotationsAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundRuntimeInvisibleParameterAnnotationsAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, RuntimeInvisibleParameterAnnotationsAttribute attr) {
            List<List<Annotation>> lists = attr.parameterAnnotations();
            buf.writeU1(lists.size());
            for (List<Annotation> list : lists) {
                AnnotationReader.writeAnnotations(buf, list);
            }
        }
    }

    public static final class RuntimeInvisibleAnnotationsMapper
    extends AbstractAttributeMapper<RuntimeInvisibleAnnotationsAttribute> {
        public static final RuntimeInvisibleAnnotationsMapper INSTANCE = new RuntimeInvisibleAnnotationsMapper();

        private RuntimeInvisibleAnnotationsMapper() {
            super("RuntimeInvisibleAnnotations", AttributeMapper.AttributeStability.CP_REFS);
        }

        @Override
        public RuntimeInvisibleAnnotationsAttribute readAttribute(AttributedElement enclosing, ClassReader cf, int pos) {
            return new BoundAttribute.BoundRuntimeInvisibleAnnotationsAttribute(cf, pos);
        }

        @Override
        protected void writeBody(BufWriter buf, RuntimeInvisibleAnnotationsAttribute attr) {
            AnnotationReader.writeAnnotations(buf, attr.annotations());
        }
    }

    public static final class RecordMapper
    extends AbstractAttributeMapper<RecordAttribute> {
        public static final RecordMapper INSTANCE = new RecordMapper();

        private RecordMapper() {
            super("Record", AttributeMapper.AttributeStability.CP_REFS);
        }

        @Override
        public RecordAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundRecordAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter bufWriter, RecordAttribute attr) {
            List<RecordComponentInfo> components = attr.components();
            BufWriterImpl buf = (BufWriterImpl)bufWriter;
            buf.writeU2(components.size());
            for (RecordComponentInfo info : components) {
                buf.writeU2U2(buf.cpIndex(info.name()), buf.cpIndex(info.descriptor()));
                Util.writeAttributes(buf, info.attributes());
            }
        }
    }

    public static final class PermittedSubclassesMapper
    extends AbstractAttributeMapper<PermittedSubclassesAttribute> {
        public static final PermittedSubclassesMapper INSTANCE = new PermittedSubclassesMapper();

        private PermittedSubclassesMapper() {
            super("PermittedSubclasses", AttributeMapper.AttributeStability.CP_REFS);
        }

        @Override
        public PermittedSubclassesAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundPermittedSubclassesAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, PermittedSubclassesAttribute attr) {
            Util.writeListIndices(buf, attr.permittedSubclasses());
        }
    }

    public static final class NestMembersMapper
    extends AbstractAttributeMapper<NestMembersAttribute> {
        public static final NestMembersMapper INSTANCE = new NestMembersMapper();

        private NestMembersMapper() {
            super("NestMembers", AttributeMapper.AttributeStability.CP_REFS);
        }

        @Override
        public NestMembersAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundNestMembersAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, NestMembersAttribute attr) {
            Util.writeListIndices(buf, attr.nestMembers());
        }
    }

    public static final class NestHostMapper
    extends AbstractAttributeMapper<NestHostAttribute> {
        public static final NestHostMapper INSTANCE = new NestHostMapper();

        private NestHostMapper() {
            super("NestHost", AttributeMapper.AttributeStability.CP_REFS);
        }

        @Override
        public NestHostAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundNestHostAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, NestHostAttribute attr) {
            buf.writeIndex(attr.nestHost());
        }
    }

    public static final class ModuleTargetMapper
    extends AbstractAttributeMapper<ModuleTargetAttribute> {
        public static final ModuleTargetMapper INSTANCE = new ModuleTargetMapper();

        private ModuleTargetMapper() {
            super("ModuleTarget", AttributeMapper.AttributeStability.CP_REFS);
        }

        @Override
        public ModuleTargetAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundModuleTargetAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, ModuleTargetAttribute attr) {
            buf.writeIndex(attr.targetPlatform());
        }
    }

    public static final class ModuleResolutionMapper
    extends AbstractAttributeMapper<ModuleResolutionAttribute> {
        public static final ModuleResolutionMapper INSTANCE = new ModuleResolutionMapper();

        private ModuleResolutionMapper() {
            super("ModuleResolution", AttributeMapper.AttributeStability.STATELESS);
        }

        @Override
        public ModuleResolutionAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundModuleResolutionAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, ModuleResolutionAttribute attr) {
            buf.writeU2(attr.resolutionFlags());
        }
    }

    public static final class ModulePackagesMapper
    extends AbstractAttributeMapper<ModulePackagesAttribute> {
        public static final ModulePackagesMapper INSTANCE = new ModulePackagesMapper();

        private ModulePackagesMapper() {
            super("ModulePackages", AttributeMapper.AttributeStability.CP_REFS);
        }

        @Override
        public ModulePackagesAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundModulePackagesAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, ModulePackagesAttribute attr) {
            Util.writeListIndices(buf, attr.packages());
        }
    }

    public static final class ModuleMainClassMapper
    extends AbstractAttributeMapper<ModuleMainClassAttribute> {
        public static final ModuleMainClassMapper INSTANCE = new ModuleMainClassMapper();

        private ModuleMainClassMapper() {
            super("ModuleMainClass", AttributeMapper.AttributeStability.CP_REFS);
        }

        @Override
        public ModuleMainClassAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundModuleMainClassAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, ModuleMainClassAttribute attr) {
            buf.writeIndex(attr.mainClass());
        }
    }

    public static final class ModuleHashesMapper
    extends AbstractAttributeMapper<ModuleHashesAttribute> {
        public static final ModuleHashesMapper INSTANCE = new ModuleHashesMapper();

        private ModuleHashesMapper() {
            super("ModuleHashes", AttributeMapper.AttributeStability.CP_REFS);
        }

        @Override
        public ModuleHashesAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundModuleHashesAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter bufWriter, ModuleHashesAttribute attr) {
            List<ModuleHashInfo> hashes = attr.hashes();
            BufWriterImpl buf = (BufWriterImpl)bufWriter;
            buf.writeU2U2(buf.cpIndex(attr.algorithm()), hashes.size());
            for (ModuleHashInfo hash : hashes) {
                buf.writeU2U2(buf.cpIndex(hash.moduleName()), hash.hash().length);
                buf.writeBytes(hash.hash());
            }
        }
    }

    public static final class ModuleMapper
    extends AbstractAttributeMapper<ModuleAttribute> {
        public static final ModuleMapper INSTANCE = new ModuleMapper();

        private ModuleMapper() {
            super("Module", AttributeMapper.AttributeStability.CP_REFS);
        }

        @Override
        public ModuleAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundModuleAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter bufWriter, ModuleAttribute attr) {
            BufWriterImpl buf = (BufWriterImpl)bufWriter;
            buf.writeU2U2U2(buf.cpIndex(attr.moduleName()), attr.moduleFlagsMask(), buf.cpIndexOrZero(attr.moduleVersion().orElse(null)));
            buf.writeU2(attr.requires().size());
            for (ModuleRequireInfo require : attr.requires()) {
                buf.writeU2U2U2(buf.cpIndex(require.requires()), require.requiresFlagsMask(), buf.cpIndexOrZero(require.requiresVersion().orElse(null)));
            }
            buf.writeU2(attr.exports().size());
            for (ModuleExportInfo export : attr.exports()) {
                buf.writeU2U2(buf.cpIndex(export.exportedPackage()), export.exportsFlagsMask());
                Util.writeListIndices(buf, export.exportsTo());
            }
            buf.writeU2(attr.opens().size());
            for (ModuleOpenInfo open : attr.opens()) {
                buf.writeU2U2(buf.cpIndex(open.openedPackage()), open.opensFlagsMask());
                Util.writeListIndices(buf, open.opensTo());
            }
            Util.writeListIndices(buf, attr.uses());
            buf.writeU2(attr.provides().size());
            for (ModuleProvideInfo provide : attr.provides()) {
                buf.writeIndex(provide.provides());
                Util.writeListIndices(buf, provide.providesWith());
            }
        }
    }

    public static final class MethodParametersMapper
    extends AbstractAttributeMapper<MethodParametersAttribute> {
        public static final MethodParametersMapper INSTANCE = new MethodParametersMapper();

        private MethodParametersMapper() {
            super("MethodParameters", AttributeMapper.AttributeStability.CP_REFS);
        }

        @Override
        public MethodParametersAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundMethodParametersAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter bufWriter, MethodParametersAttribute attr) {
            List<MethodParameterInfo> parameters = attr.parameters();
            BufWriterImpl buf = (BufWriterImpl)bufWriter;
            buf.writeU1(parameters.size());
            for (MethodParameterInfo info : parameters) {
                buf.writeU2U2(buf.cpIndexOrZero(info.name().orElse(null)), info.flagsMask());
            }
        }
    }

    public static final class LocalVariableTypeTableMapper
    extends AbstractAttributeMapper<LocalVariableTypeTableAttribute> {
        public static final LocalVariableTypeTableMapper INSTANCE = new LocalVariableTypeTableMapper();

        private LocalVariableTypeTableMapper() {
            super("LocalVariableTypeTable", AttributeMapper.AttributeStability.LABELS, true);
        }

        @Override
        public LocalVariableTypeTableAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundLocalVariableTypeTableAttribute(e, cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter bufWriter, LocalVariableTypeTableAttribute attr) {
            List<LocalVariableTypeInfo> infos = attr.localVariableTypes();
            BufWriterImpl buf = (BufWriterImpl)bufWriter;
            buf.writeU2(infos.size());
            for (LocalVariableTypeInfo info : infos) {
                buf.writeU2U2(info.startPc(), info.length());
                buf.writeU2U2U2(buf.cpIndex(info.name()), buf.cpIndex(info.signature()), info.slot());
            }
        }
    }

    public static final class LocalVariableTableMapper
    extends AbstractAttributeMapper<LocalVariableTableAttribute> {
        public static final LocalVariableTableMapper INSTANCE = new LocalVariableTableMapper();

        private LocalVariableTableMapper() {
            super("LocalVariableTable", AttributeMapper.AttributeStability.LABELS, true);
        }

        @Override
        public LocalVariableTableAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundLocalVariableTableAttribute(e, cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter bufWriter, LocalVariableTableAttribute attr) {
            List<LocalVariableInfo> infos = attr.localVariables();
            BufWriterImpl buf = (BufWriterImpl)bufWriter;
            buf.writeU2(infos.size());
            for (LocalVariableInfo info : infos) {
                buf.writeU2U2(info.startPc(), info.length());
                buf.writeU2U2U2(buf.cpIndex(info.name()), buf.cpIndex(info.type()), info.slot());
            }
        }
    }

    public static final class LineNumberTableMapper
    extends AbstractAttributeMapper<LineNumberTableAttribute> {
        public static final LineNumberTableMapper INSTANCE = new LineNumberTableMapper();

        private LineNumberTableMapper() {
            super("LineNumberTable", AttributeMapper.AttributeStability.LABELS, true);
        }

        @Override
        public LineNumberTableAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundLineNumberTableAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter bufWriter, LineNumberTableAttribute attr) {
            List<LineNumberInfo> lines = attr.lineNumbers();
            BufWriterImpl buf = (BufWriterImpl)bufWriter;
            buf.writeU2(lines.size());
            for (LineNumberInfo line : lines) {
                buf.writeU2U2(line.startPc(), line.lineNumber());
            }
        }
    }

    public static final class InnerClassesMapper
    extends AbstractAttributeMapper<InnerClassesAttribute> {
        public static final InnerClassesMapper INSTANCE = new InnerClassesMapper();

        private InnerClassesMapper() {
            super("InnerClasses", AttributeMapper.AttributeStability.CP_REFS);
        }

        @Override
        public InnerClassesAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundInnerClassesAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter bufWriter, InnerClassesAttribute attr) {
            List<InnerClassInfo> classes = attr.classes();
            BufWriterImpl buf = (BufWriterImpl)bufWriter;
            buf.writeU2(classes.size());
            for (InnerClassInfo ic : classes) {
                buf.writeU2U2U2(buf.cpIndex(ic.innerClass()), buf.cpIndexOrZero(ic.outerClass().orElse(null)), buf.cpIndexOrZero(ic.innerName().orElse(null)));
                buf.writeU2(ic.flagsMask());
            }
        }
    }

    public static final class ExceptionsMapper
    extends AbstractAttributeMapper<ExceptionsAttribute> {
        public static final ExceptionsMapper INSTANCE = new ExceptionsMapper();

        private ExceptionsMapper() {
            super("Exceptions", AttributeMapper.AttributeStability.CP_REFS);
        }

        @Override
        public ExceptionsAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundExceptionsAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, ExceptionsAttribute attr) {
            Util.writeListIndices(buf, attr.exceptions());
        }
    }

    public static final class EnclosingMethodMapper
    extends AbstractAttributeMapper<EnclosingMethodAttribute> {
        public static final EnclosingMethodMapper INSTANCE = new EnclosingMethodMapper();

        private EnclosingMethodMapper() {
            super("EnclosingMethod", AttributeMapper.AttributeStability.CP_REFS);
        }

        @Override
        public EnclosingMethodAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundEnclosingMethodAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter bufWriter, EnclosingMethodAttribute attr) {
            BufWriterImpl buf = (BufWriterImpl)bufWriter;
            buf.writeU2U2(buf.cpIndex(attr.enclosingClass()), buf.cpIndexOrZero(attr.enclosingMethod().orElse(null)));
        }
    }

    public static final class DeprecatedMapper
    extends AbstractAttributeMapper<DeprecatedAttribute> {
        public static final DeprecatedMapper INSTANCE = new DeprecatedMapper();

        private DeprecatedMapper() {
            super("Deprecated", AttributeMapper.AttributeStability.STATELESS, true);
        }

        @Override
        public DeprecatedAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundDeprecatedAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, DeprecatedAttribute attr) {
        }
    }

    public static final class ConstantValueMapper
    extends AbstractAttributeMapper<ConstantValueAttribute> {
        public static final ConstantValueMapper INSTANCE = new ConstantValueMapper();

        private ConstantValueMapper() {
            super("ConstantValue", AttributeMapper.AttributeStability.CP_REFS);
        }

        @Override
        public ConstantValueAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundConstantValueAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, ConstantValueAttribute attr) {
            buf.writeIndex(attr.constant());
        }
    }

    public static final class CompilationIDMapper
    extends AbstractAttributeMapper<CompilationIDAttribute> {
        public static final CompilationIDMapper INSTANCE = new CompilationIDMapper();

        private CompilationIDMapper() {
            super("CompilationID", AttributeMapper.AttributeStability.CP_REFS);
        }

        @Override
        public CompilationIDAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundCompilationIDAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, CompilationIDAttribute attr) {
            buf.writeIndex(attr.compilationId());
        }
    }

    public static final class CodeMapper
    extends AbstractAttributeMapper<CodeAttribute> {
        public static final CodeMapper INSTANCE = new CodeMapper();

        private CodeMapper() {
            super("Code", AttributeMapper.AttributeStability.CP_REFS);
        }

        @Override
        public CodeAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new CodeImpl(e, cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, CodeAttribute attr) {
            throw new UnsupportedOperationException("Code attribute does not support direct write");
        }
    }

    public static final class CharacterRangeTableMapper
    extends AbstractAttributeMapper<CharacterRangeTableAttribute> {
        public static final CharacterRangeTableMapper INSTANCE = new CharacterRangeTableMapper();

        private CharacterRangeTableMapper() {
            super("CharacterRangeTable", AttributeMapper.AttributeStability.LABELS, true);
        }

        @Override
        public CharacterRangeTableAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundCharacterRangeTableAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter bufWriter, CharacterRangeTableAttribute attr) {
            List<CharacterRangeInfo> ranges = attr.characterRangeTable();
            BufWriterImpl buf = (BufWriterImpl)bufWriter;
            buf.writeU2(ranges.size());
            for (CharacterRangeInfo info : ranges) {
                buf.writeU2U2(info.startPc(), info.endPc());
                buf.writeIntInt(info.characterRangeStart(), info.characterRangeEnd());
                buf.writeU2(info.flags());
            }
        }
    }

    public static final class BootstrapMethodsMapper
    extends AbstractAttributeMapper<BootstrapMethodsAttribute> {
        public static final BootstrapMethodsMapper INSTANCE = new BootstrapMethodsMapper();

        private BootstrapMethodsMapper() {
            super("BootstrapMethods", AttributeMapper.AttributeStability.CP_REFS);
        }

        @Override
        public BootstrapMethodsAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundBootstrapMethodsAttribute(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, BootstrapMethodsAttribute attr) {
            BufWriterImpl b = (BufWriterImpl)buf;
            b.writeU2(attr.bootstrapMethodsSize());
            for (BootstrapMethodEntry bsm : attr.bootstrapMethods()) {
                ((BootstrapMethodEntryImpl)bsm).writeTo(b);
            }
        }
    }

    public static final class AnnotationDefaultMapper
    extends AbstractAttributeMapper<AnnotationDefaultAttribute> {
        public static final AnnotationDefaultMapper INSTANCE = new AnnotationDefaultMapper();

        private AnnotationDefaultMapper() {
            super("AnnotationDefault", AttributeMapper.AttributeStability.CP_REFS);
        }

        @Override
        public AnnotationDefaultAttribute readAttribute(AttributedElement e, ClassReader cf, int p) {
            return new BoundAttribute.BoundAnnotationDefaultAttr(cf, this, p);
        }

        @Override
        protected void writeBody(BufWriter buf, AnnotationDefaultAttribute attr) {
            AnnotationReader.writeAnnotationValue((BufWriterImpl)buf, attr.defaultValue());
        }
    }
}

