/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.attribute;

import io.smallrye.classfile.Attribute;
import io.smallrye.classfile.ClassElement;
import io.smallrye.classfile.constantpool.ClassEntry;
import io.smallrye.classfile.constantpool.NameAndTypeEntry;
import io.smallrye.classfile.constantpool.Utf8Entry;
import io.smallrye.classfile.impl.TemporaryConstantPool;
import io.smallrye.classfile.impl.UnboundAttribute;
import io.smallrye.classfile.impl.Util;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.Optional;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface EnclosingMethodAttribute
extends Attribute<EnclosingMethodAttribute>,
ClassElement {
    public ClassEntry enclosingClass();

    public Optional<NameAndTypeEntry> enclosingMethod();

    default public Optional<Utf8Entry> enclosingMethodName() {
        return this.enclosingMethod().map(NameAndTypeEntry::name);
    }

    default public Optional<Utf8Entry> enclosingMethodType() {
        return this.enclosingMethod().map(NameAndTypeEntry::type);
    }

    default public Optional<MethodTypeDesc> enclosingMethodTypeSymbol() {
        return this.enclosingMethodType().map(Util::methodTypeSymbol);
    }

    public static EnclosingMethodAttribute of(ClassEntry className, Optional<NameAndTypeEntry> method) {
        return new UnboundAttribute.UnboundEnclosingMethodAttribute(className, method.orElse(null));
    }

    public static EnclosingMethodAttribute of(ClassDesc className, Optional<String> methodName, Optional<MethodTypeDesc> methodType) {
        return new UnboundAttribute.UnboundEnclosingMethodAttribute(TemporaryConstantPool.INSTANCE.classEntry(className), methodName.isPresent() && methodType.isPresent() ? TemporaryConstantPool.INSTANCE.nameAndTypeEntry(methodName.get(), methodType.get()) : null);
    }
}

