/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile;

import io.smallrye.classfile.BootstrapMethodEntry;
import io.smallrye.classfile.ClassFileBuilder;
import io.smallrye.classfile.CodeElement;
import io.smallrye.classfile.CodeTransform;
import io.smallrye.classfile.Label;
import io.smallrye.classfile.Opcode;
import io.smallrye.classfile.Signature;
import io.smallrye.classfile.TypeKind;
import io.smallrye.classfile.constantpool.ClassEntry;
import io.smallrye.classfile.constantpool.FieldRefEntry;
import io.smallrye.classfile.constantpool.InterfaceMethodRefEntry;
import io.smallrye.classfile.constantpool.InvokeDynamicEntry;
import io.smallrye.classfile.constantpool.LoadableConstantEntry;
import io.smallrye.classfile.constantpool.MemberRefEntry;
import io.smallrye.classfile.constantpool.MethodHandleEntry;
import io.smallrye.classfile.constantpool.MethodRefEntry;
import io.smallrye.classfile.constantpool.NameAndTypeEntry;
import io.smallrye.classfile.constantpool.Utf8Entry;
import io.smallrye.classfile.impl.BlockCodeBuilderImpl;
import io.smallrye.classfile.impl.BytecodeHelpers;
import io.smallrye.classfile.impl.CatchBuilderImpl;
import io.smallrye.classfile.impl.ChainedCodeBuilder;
import io.smallrye.classfile.impl.LabelImpl;
import io.smallrye.classfile.impl.TransformImpl;
import io.smallrye.classfile.instruction.ArrayLoadInstruction;
import io.smallrye.classfile.instruction.ArrayStoreInstruction;
import io.smallrye.classfile.instruction.BranchInstruction;
import io.smallrye.classfile.instruction.CharacterRange;
import io.smallrye.classfile.instruction.ConstantInstruction;
import io.smallrye.classfile.instruction.ConvertInstruction;
import io.smallrye.classfile.instruction.ExceptionCatch;
import io.smallrye.classfile.instruction.FieldInstruction;
import io.smallrye.classfile.instruction.IncrementInstruction;
import io.smallrye.classfile.instruction.InvokeDynamicInstruction;
import io.smallrye.classfile.instruction.InvokeInstruction;
import io.smallrye.classfile.instruction.LineNumber;
import io.smallrye.classfile.instruction.LoadInstruction;
import io.smallrye.classfile.instruction.LocalVariable;
import io.smallrye.classfile.instruction.LocalVariableType;
import io.smallrye.classfile.instruction.LookupSwitchInstruction;
import io.smallrye.classfile.instruction.MonitorInstruction;
import io.smallrye.classfile.instruction.NewMultiArrayInstruction;
import io.smallrye.classfile.instruction.NewObjectInstruction;
import io.smallrye.classfile.instruction.NewPrimitiveArrayInstruction;
import io.smallrye.classfile.instruction.NewReferenceArrayInstruction;
import io.smallrye.classfile.instruction.NopInstruction;
import io.smallrye.classfile.instruction.OperatorInstruction;
import io.smallrye.classfile.instruction.ReturnInstruction;
import io.smallrye.classfile.instruction.StackInstruction;
import io.smallrye.classfile.instruction.StoreInstruction;
import io.smallrye.classfile.instruction.SwitchCase;
import io.smallrye.classfile.instruction.TableSwitchInstruction;
import io.smallrye.classfile.instruction.ThrowInstruction;
import io.smallrye.classfile.instruction.TypeCheckInstruction;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.constant.DynamicCallSiteDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface CodeBuilder
extends ClassFileBuilder<CodeElement, CodeBuilder> {
    public Label newLabel();

    public Label startLabel();

    public Label endLabel();

    public int receiverSlot();

    public int parameterSlot(int var1);

    public int allocateLocal(TypeKind var1);

    default public CodeBuilder transforming(CodeTransform transform, Consumer<CodeBuilder> handler) {
        TransformImpl.ResolvedTransform<CodeElement> resolved = TransformImpl.resolve(transform, this);
        resolved.startHandler().run();
        handler.accept(new ChainedCodeBuilder(this, resolved.consumer()));
        resolved.endHandler().run();
        return this;
    }

    default public CodeBuilder block(Consumer<BlockCodeBuilder> handler) {
        Label breakLabel = this.newLabel();
        BlockCodeBuilderImpl child = new BlockCodeBuilderImpl(this, breakLabel);
        child.start();
        handler.accept(child);
        child.end();
        return this.labelBinding(breakLabel);
    }

    default public CodeBuilder ifThen(Consumer<BlockCodeBuilder> thenHandler) {
        return this.ifThen(Opcode.IFNE, thenHandler);
    }

    default public CodeBuilder ifThen(Opcode opcode, Consumer<BlockCodeBuilder> thenHandler) {
        if (opcode.kind() != Opcode.Kind.BRANCH || BytecodeHelpers.isUnconditionalBranch(opcode)) {
            throw new IllegalArgumentException("Illegal branch opcode: " + String.valueOf((Object)opcode));
        }
        Label breakLabel = this.newLabel();
        BlockCodeBuilderImpl thenBlock = new BlockCodeBuilderImpl(this, breakLabel);
        this.branch(BytecodeHelpers.reverseBranchOpcode(opcode), thenBlock.endLabel());
        thenBlock.start();
        thenHandler.accept(thenBlock);
        thenBlock.end();
        return this.labelBinding(breakLabel);
    }

    default public CodeBuilder ifThenElse(Consumer<BlockCodeBuilder> thenHandler, Consumer<BlockCodeBuilder> elseHandler) {
        return this.ifThenElse(Opcode.IFNE, thenHandler, elseHandler);
    }

    default public CodeBuilder ifThenElse(Opcode opcode, Consumer<BlockCodeBuilder> thenHandler, Consumer<BlockCodeBuilder> elseHandler) {
        if (opcode.kind() != Opcode.Kind.BRANCH || BytecodeHelpers.isUnconditionalBranch(opcode)) {
            throw new IllegalArgumentException("Illegal branch opcode: " + String.valueOf((Object)opcode));
        }
        Label breakLabel = this.newLabel();
        BlockCodeBuilderImpl thenBlock = new BlockCodeBuilderImpl(this, breakLabel);
        BlockCodeBuilderImpl elseBlock = new BlockCodeBuilderImpl(this, breakLabel);
        this.branch(BytecodeHelpers.reverseBranchOpcode(opcode), elseBlock.startLabel());
        thenBlock.start();
        thenHandler.accept(thenBlock);
        if (thenBlock.reachable()) {
            thenBlock.branch(Opcode.GOTO, thenBlock.breakLabel());
        }
        thenBlock.end();
        elseBlock.start();
        elseHandler.accept(elseBlock);
        elseBlock.end();
        return this.labelBinding(breakLabel);
    }

    default public CodeBuilder trying(Consumer<BlockCodeBuilder> tryHandler, Consumer<CatchBuilder> catchesHandler) {
        Label tryCatchEnd = this.newLabel();
        BlockCodeBuilderImpl tryBlock = new BlockCodeBuilderImpl(this, tryCatchEnd);
        tryBlock.start();
        tryHandler.accept(tryBlock);
        tryBlock.end();
        if (tryBlock.isEmpty()) {
            throw new IllegalArgumentException("The body of the try block is empty");
        }
        CatchBuilderImpl catchBuilder = new CatchBuilderImpl(this, tryBlock, tryCatchEnd);
        catchesHandler.accept(catchBuilder);
        catchBuilder.finish();
        return this;
    }

    default public CodeBuilder loadLocal(TypeKind tk, int slot) {
        return (CodeBuilder)this.with(LoadInstruction.of(tk, slot));
    }

    default public CodeBuilder storeLocal(TypeKind tk, int slot) {
        return (CodeBuilder)this.with(StoreInstruction.of(tk, slot));
    }

    default public CodeBuilder branch(Opcode op, Label target) {
        return (CodeBuilder)this.with(BranchInstruction.of(op, target));
    }

    default public CodeBuilder return_(TypeKind tk) {
        return (CodeBuilder)this.with(ReturnInstruction.of(tk));
    }

    default public CodeBuilder fieldAccess(Opcode opcode, FieldRefEntry ref) {
        return (CodeBuilder)this.with(FieldInstruction.of(opcode, ref));
    }

    default public CodeBuilder fieldAccess(Opcode opcode, ClassDesc owner, String name, ClassDesc type) {
        return this.fieldAccess(opcode, this.constantPool().fieldRefEntry(owner, name, type));
    }

    default public CodeBuilder invoke(Opcode opcode, MemberRefEntry ref) {
        return (CodeBuilder)this.with(InvokeInstruction.of(opcode, ref));
    }

    default public CodeBuilder invoke(Opcode opcode, ClassDesc owner, String name, MethodTypeDesc desc, boolean isInterface) {
        return this.invoke(opcode, isInterface ? this.constantPool().interfaceMethodRefEntry(owner, name, desc) : this.constantPool().methodRefEntry(owner, name, desc));
    }

    default public CodeBuilder arrayLoad(TypeKind tk) {
        Opcode opcode = BytecodeHelpers.arrayLoadOpcode(tk);
        return (CodeBuilder)this.with(ArrayLoadInstruction.of(opcode));
    }

    default public CodeBuilder arrayStore(TypeKind tk) {
        Opcode opcode = BytecodeHelpers.arrayStoreOpcode(tk);
        return (CodeBuilder)this.with(ArrayStoreInstruction.of(opcode));
    }

    default public CodeBuilder conversion(TypeKind fromType, TypeKind toType) {
        TypeKind computationalTo;
        TypeKind computationalFrom = fromType.asLoadable();
        if (computationalFrom != (computationalTo = toType.asLoadable())) {
            block0 : switch (computationalTo) {
                case INT: {
                    switch (computationalFrom) {
                        case FLOAT: {
                            this.f2i();
                            break block0;
                        }
                        case LONG: {
                            this.l2i();
                            break block0;
                        }
                        case DOUBLE: {
                            this.d2i();
                            break block0;
                        }
                    }
                    throw BytecodeHelpers.cannotConvertException(fromType, toType);
                }
                case FLOAT: {
                    switch (computationalFrom) {
                        case INT: {
                            this.i2f();
                            break block0;
                        }
                        case LONG: {
                            this.l2f();
                            break block0;
                        }
                        case DOUBLE: {
                            this.d2f();
                            break block0;
                        }
                    }
                    throw BytecodeHelpers.cannotConvertException(fromType, toType);
                }
                case LONG: {
                    switch (computationalFrom) {
                        case INT: {
                            this.i2l();
                            break block0;
                        }
                        case FLOAT: {
                            this.f2l();
                            break block0;
                        }
                        case DOUBLE: {
                            this.d2l();
                            break block0;
                        }
                    }
                    throw BytecodeHelpers.cannotConvertException(fromType, toType);
                }
                case DOUBLE: {
                    switch (computationalFrom) {
                        case INT: {
                            this.i2d();
                            break block0;
                        }
                        case FLOAT: {
                            this.f2d();
                            break block0;
                        }
                        case LONG: {
                            this.l2d();
                            break block0;
                        }
                    }
                    throw BytecodeHelpers.cannotConvertException(fromType, toType);
                }
            }
        }
        if (computationalTo == TypeKind.INT && toType != TypeKind.INT) {
            switch (toType) {
                case BOOLEAN: {
                    this.iconst_1().iand();
                    break;
                }
                case BYTE: {
                    this.i2b();
                    break;
                }
                case CHAR: {
                    this.i2c();
                    break;
                }
                case SHORT: {
                    this.i2s();
                }
            }
        }
        return this;
    }

    default public CodeBuilder loadConstant(ConstantDesc value) {
        if (value == null || value.equals(ConstantDescs.NULL)) {
            return this.aconst_null();
        }
        if (value instanceof Number) {
            if (value instanceof Integer) {
                return this.loadConstant((Integer)value);
            }
            if (value instanceof Long) {
                return this.loadConstant((Long)value);
            }
            if (value instanceof Float) {
                return this.loadConstant(((Float)value).floatValue());
            }
            if (value instanceof Double) {
                return this.loadConstant((Double)value);
            }
        }
        return this.ldc(value);
    }

    default public CodeBuilder loadConstant(int value) {
        return switch (value) {
            case -1 -> this.iconst_m1();
            case 0 -> this.iconst_0();
            case 1 -> this.iconst_1();
            case 2 -> this.iconst_2();
            case 3 -> this.iconst_3();
            case 4 -> this.iconst_4();
            case 5 -> this.iconst_5();
            default -> value >= -128 && value <= 127 ? this.bipush(value) : (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE ? this.sipush(value) : this.ldc(this.constantPool().intEntry(value)));
        };
    }

    default public CodeBuilder loadConstant(long value) {
        return value == 0L ? this.lconst_0() : (value == 1L ? this.lconst_1() : this.ldc(this.constantPool().longEntry(value)));
    }

    default public CodeBuilder loadConstant(float value) {
        return Float.floatToRawIntBits(value) == 0 ? this.fconst_0() : (value == 1.0f ? this.fconst_1() : (value == 2.0f ? this.fconst_2() : this.ldc(this.constantPool().floatEntry(value))));
    }

    default public CodeBuilder loadConstant(double value) {
        return Double.doubleToRawLongBits(value) == 0L ? this.dconst_0() : (value == 1.0 ? this.dconst_1() : this.ldc(this.constantPool().doubleEntry(value)));
    }

    default public CodeBuilder nop() {
        return (CodeBuilder)this.with(NopInstruction.of());
    }

    default public Label newBoundLabel() {
        Label label = this.newLabel();
        this.labelBinding(label);
        return label;
    }

    default public CodeBuilder labelBinding(Label label) {
        return (CodeBuilder)this.with((LabelImpl)label);
    }

    default public CodeBuilder lineNumber(int line) {
        return (CodeBuilder)this.with(LineNumber.of(line));
    }

    default public CodeBuilder exceptionCatch(Label start, Label end, Label handler, ClassEntry catchType) {
        return (CodeBuilder)this.with(ExceptionCatch.of(handler, start, end, Optional.ofNullable(catchType)));
    }

    default public CodeBuilder exceptionCatch(Label start, Label end, Label handler, Optional<ClassEntry> catchType) {
        return (CodeBuilder)this.with(ExceptionCatch.of(handler, start, end, catchType));
    }

    default public CodeBuilder exceptionCatch(Label start, Label end, Label handler, ClassDesc catchType) {
        Objects.requireNonNull(catchType);
        return this.exceptionCatch(start, end, handler, this.constantPool().classEntry(catchType));
    }

    default public CodeBuilder exceptionCatchAll(Label start, Label end, Label handler) {
        return (CodeBuilder)this.with(ExceptionCatch.of(handler, start, end));
    }

    default public CodeBuilder characterRange(Label startScope, Label endScope, int characterRangeStart, int characterRangeEnd, int flags) {
        return (CodeBuilder)this.with(CharacterRange.of(startScope, endScope, characterRangeStart, characterRangeEnd, flags));
    }

    default public CodeBuilder localVariable(int slot, Utf8Entry nameEntry, Utf8Entry descriptorEntry, Label startScope, Label endScope) {
        return (CodeBuilder)this.with(LocalVariable.of(slot, nameEntry, descriptorEntry, startScope, endScope));
    }

    default public CodeBuilder localVariable(int slot, String name, ClassDesc descriptor, Label startScope, Label endScope) {
        return (CodeBuilder)this.with(LocalVariable.of(slot, name, descriptor, startScope, endScope));
    }

    default public CodeBuilder localVariableType(int slot, Utf8Entry nameEntry, Utf8Entry signatureEntry, Label startScope, Label endScope) {
        return (CodeBuilder)this.with(LocalVariableType.of(slot, nameEntry, signatureEntry, startScope, endScope));
    }

    default public CodeBuilder localVariableType(int slot, String name, Signature signature, Label startScope, Label endScope) {
        return (CodeBuilder)this.with(LocalVariableType.of(slot, name, signature, startScope, endScope));
    }

    default public CodeBuilder aconst_null() {
        return (CodeBuilder)this.with(ConstantInstruction.ofIntrinsic(Opcode.ACONST_NULL));
    }

    default public CodeBuilder aaload() {
        return this.arrayLoad(TypeKind.REFERENCE);
    }

    default public CodeBuilder aastore() {
        return this.arrayStore(TypeKind.REFERENCE);
    }

    default public CodeBuilder aload(int slot) {
        return this.loadLocal(TypeKind.REFERENCE, slot);
    }

    default public CodeBuilder anewarray(ClassEntry classEntry) {
        return (CodeBuilder)this.with(NewReferenceArrayInstruction.of(classEntry));
    }

    default public CodeBuilder anewarray(ClassDesc className) {
        return this.anewarray(this.constantPool().classEntry(className));
    }

    default public CodeBuilder areturn() {
        return this.return_(TypeKind.REFERENCE);
    }

    default public CodeBuilder arraylength() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.ARRAYLENGTH));
    }

    default public CodeBuilder astore(int slot) {
        return this.storeLocal(TypeKind.REFERENCE, slot);
    }

    default public CodeBuilder athrow() {
        return (CodeBuilder)this.with(ThrowInstruction.of());
    }

    default public CodeBuilder baload() {
        return this.arrayLoad(TypeKind.BYTE);
    }

    default public CodeBuilder bastore() {
        return this.arrayStore(TypeKind.BYTE);
    }

    default public CodeBuilder bipush(int b) {
        return (CodeBuilder)this.with(ConstantInstruction.ofArgument(Opcode.BIPUSH, b));
    }

    default public CodeBuilder caload() {
        return this.arrayLoad(TypeKind.CHAR);
    }

    default public CodeBuilder castore() {
        return this.arrayStore(TypeKind.CHAR);
    }

    default public CodeBuilder checkcast(ClassEntry type) {
        return (CodeBuilder)this.with(TypeCheckInstruction.of(Opcode.CHECKCAST, type));
    }

    default public CodeBuilder checkcast(ClassDesc type) {
        return this.checkcast(this.constantPool().classEntry(type));
    }

    default public CodeBuilder d2f() {
        return (CodeBuilder)this.with(ConvertInstruction.of(Opcode.D2F));
    }

    default public CodeBuilder d2i() {
        return (CodeBuilder)this.with(ConvertInstruction.of(Opcode.D2I));
    }

    default public CodeBuilder d2l() {
        return (CodeBuilder)this.with(ConvertInstruction.of(Opcode.D2L));
    }

    default public CodeBuilder dadd() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.DADD));
    }

    default public CodeBuilder daload() {
        return this.arrayLoad(TypeKind.DOUBLE);
    }

    default public CodeBuilder dastore() {
        return this.arrayStore(TypeKind.DOUBLE);
    }

    default public CodeBuilder dcmpg() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.DCMPG));
    }

    default public CodeBuilder dcmpl() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.DCMPL));
    }

    default public CodeBuilder dconst_0() {
        return (CodeBuilder)this.with(ConstantInstruction.ofIntrinsic(Opcode.DCONST_0));
    }

    default public CodeBuilder dconst_1() {
        return (CodeBuilder)this.with(ConstantInstruction.ofIntrinsic(Opcode.DCONST_1));
    }

    default public CodeBuilder ddiv() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.DDIV));
    }

    default public CodeBuilder dload(int slot) {
        return this.loadLocal(TypeKind.DOUBLE, slot);
    }

    default public CodeBuilder dmul() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.DMUL));
    }

    default public CodeBuilder dneg() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.DNEG));
    }

    default public CodeBuilder drem() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.DREM));
    }

    default public CodeBuilder dreturn() {
        return this.return_(TypeKind.DOUBLE);
    }

    default public CodeBuilder dstore(int slot) {
        return this.storeLocal(TypeKind.DOUBLE, slot);
    }

    default public CodeBuilder dsub() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.DSUB));
    }

    default public CodeBuilder dup() {
        return (CodeBuilder)this.with(StackInstruction.of(Opcode.DUP));
    }

    default public CodeBuilder dup2() {
        return (CodeBuilder)this.with(StackInstruction.of(Opcode.DUP2));
    }

    default public CodeBuilder dup2_x1() {
        return (CodeBuilder)this.with(StackInstruction.of(Opcode.DUP2_X1));
    }

    default public CodeBuilder dup2_x2() {
        return (CodeBuilder)this.with(StackInstruction.of(Opcode.DUP2_X2));
    }

    default public CodeBuilder dup_x1() {
        return (CodeBuilder)this.with(StackInstruction.of(Opcode.DUP_X1));
    }

    default public CodeBuilder dup_x2() {
        return (CodeBuilder)this.with(StackInstruction.of(Opcode.DUP_X2));
    }

    default public CodeBuilder f2d() {
        return (CodeBuilder)this.with(ConvertInstruction.of(Opcode.F2D));
    }

    default public CodeBuilder f2i() {
        return (CodeBuilder)this.with(ConvertInstruction.of(Opcode.F2I));
    }

    default public CodeBuilder f2l() {
        return (CodeBuilder)this.with(ConvertInstruction.of(Opcode.F2L));
    }

    default public CodeBuilder fadd() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.FADD));
    }

    default public CodeBuilder faload() {
        return this.arrayLoad(TypeKind.FLOAT);
    }

    default public CodeBuilder fastore() {
        return this.arrayStore(TypeKind.FLOAT);
    }

    default public CodeBuilder fcmpg() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.FCMPG));
    }

    default public CodeBuilder fcmpl() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.FCMPL));
    }

    default public CodeBuilder fconst_0() {
        return (CodeBuilder)this.with(ConstantInstruction.ofIntrinsic(Opcode.FCONST_0));
    }

    default public CodeBuilder fconst_1() {
        return (CodeBuilder)this.with(ConstantInstruction.ofIntrinsic(Opcode.FCONST_1));
    }

    default public CodeBuilder fconst_2() {
        return (CodeBuilder)this.with(ConstantInstruction.ofIntrinsic(Opcode.FCONST_2));
    }

    default public CodeBuilder fdiv() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.FDIV));
    }

    default public CodeBuilder fload(int slot) {
        return this.loadLocal(TypeKind.FLOAT, slot);
    }

    default public CodeBuilder fmul() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.FMUL));
    }

    default public CodeBuilder fneg() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.FNEG));
    }

    default public CodeBuilder frem() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.FREM));
    }

    default public CodeBuilder freturn() {
        return this.return_(TypeKind.FLOAT);
    }

    default public CodeBuilder fstore(int slot) {
        return this.storeLocal(TypeKind.FLOAT, slot);
    }

    default public CodeBuilder fsub() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.FSUB));
    }

    default public CodeBuilder getfield(FieldRefEntry ref) {
        return this.fieldAccess(Opcode.GETFIELD, ref);
    }

    default public CodeBuilder getfield(ClassDesc owner, String name, ClassDesc type) {
        return this.fieldAccess(Opcode.GETFIELD, owner, name, type);
    }

    default public CodeBuilder getstatic(FieldRefEntry ref) {
        return this.fieldAccess(Opcode.GETSTATIC, ref);
    }

    default public CodeBuilder getstatic(ClassDesc owner, String name, ClassDesc type) {
        return this.fieldAccess(Opcode.GETSTATIC, owner, name, type);
    }

    default public CodeBuilder goto_(Label target) {
        return this.branch(Opcode.GOTO, target);
    }

    default public CodeBuilder goto_w(Label target) {
        return this.branch(Opcode.GOTO_W, target);
    }

    default public CodeBuilder i2b() {
        return (CodeBuilder)this.with(ConvertInstruction.of(Opcode.I2B));
    }

    default public CodeBuilder i2c() {
        return (CodeBuilder)this.with(ConvertInstruction.of(Opcode.I2C));
    }

    default public CodeBuilder i2d() {
        return (CodeBuilder)this.with(ConvertInstruction.of(Opcode.I2D));
    }

    default public CodeBuilder i2f() {
        return (CodeBuilder)this.with(ConvertInstruction.of(Opcode.I2F));
    }

    default public CodeBuilder i2l() {
        return (CodeBuilder)this.with(ConvertInstruction.of(Opcode.I2L));
    }

    default public CodeBuilder i2s() {
        return (CodeBuilder)this.with(ConvertInstruction.of(Opcode.I2S));
    }

    default public CodeBuilder iadd() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.IADD));
    }

    default public CodeBuilder iaload() {
        return this.arrayLoad(TypeKind.INT);
    }

    default public CodeBuilder iand() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.IAND));
    }

    default public CodeBuilder iastore() {
        return this.arrayStore(TypeKind.INT);
    }

    default public CodeBuilder iconst_0() {
        return (CodeBuilder)this.with(ConstantInstruction.ofIntrinsic(Opcode.ICONST_0));
    }

    default public CodeBuilder iconst_1() {
        return (CodeBuilder)this.with(ConstantInstruction.ofIntrinsic(Opcode.ICONST_1));
    }

    default public CodeBuilder iconst_2() {
        return (CodeBuilder)this.with(ConstantInstruction.ofIntrinsic(Opcode.ICONST_2));
    }

    default public CodeBuilder iconst_3() {
        return (CodeBuilder)this.with(ConstantInstruction.ofIntrinsic(Opcode.ICONST_3));
    }

    default public CodeBuilder iconst_4() {
        return (CodeBuilder)this.with(ConstantInstruction.ofIntrinsic(Opcode.ICONST_4));
    }

    default public CodeBuilder iconst_5() {
        return (CodeBuilder)this.with(ConstantInstruction.ofIntrinsic(Opcode.ICONST_5));
    }

    default public CodeBuilder iconst_m1() {
        return (CodeBuilder)this.with(ConstantInstruction.ofIntrinsic(Opcode.ICONST_M1));
    }

    default public CodeBuilder idiv() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.IDIV));
    }

    default public CodeBuilder if_acmpeq(Label target) {
        return this.branch(Opcode.IF_ACMPEQ, target);
    }

    default public CodeBuilder if_acmpne(Label target) {
        return this.branch(Opcode.IF_ACMPNE, target);
    }

    default public CodeBuilder if_icmpeq(Label target) {
        return this.branch(Opcode.IF_ICMPEQ, target);
    }

    default public CodeBuilder if_icmpge(Label target) {
        return this.branch(Opcode.IF_ICMPGE, target);
    }

    default public CodeBuilder if_icmpgt(Label target) {
        return this.branch(Opcode.IF_ICMPGT, target);
    }

    default public CodeBuilder if_icmple(Label target) {
        return this.branch(Opcode.IF_ICMPLE, target);
    }

    default public CodeBuilder if_icmplt(Label target) {
        return this.branch(Opcode.IF_ICMPLT, target);
    }

    default public CodeBuilder if_icmpne(Label target) {
        return this.branch(Opcode.IF_ICMPNE, target);
    }

    default public CodeBuilder ifnonnull(Label target) {
        return this.branch(Opcode.IFNONNULL, target);
    }

    default public CodeBuilder ifnull(Label target) {
        return this.branch(Opcode.IFNULL, target);
    }

    default public CodeBuilder ifeq(Label target) {
        return this.branch(Opcode.IFEQ, target);
    }

    default public CodeBuilder ifge(Label target) {
        return this.branch(Opcode.IFGE, target);
    }

    default public CodeBuilder ifgt(Label target) {
        return this.branch(Opcode.IFGT, target);
    }

    default public CodeBuilder ifle(Label target) {
        return this.branch(Opcode.IFLE, target);
    }

    default public CodeBuilder iflt(Label target) {
        return this.branch(Opcode.IFLT, target);
    }

    default public CodeBuilder ifne(Label target) {
        return this.branch(Opcode.IFNE, target);
    }

    default public CodeBuilder iinc(int slot, int val) {
        return (CodeBuilder)this.with(IncrementInstruction.of(slot, val));
    }

    default public CodeBuilder iload(int slot) {
        return this.loadLocal(TypeKind.INT, slot);
    }

    default public CodeBuilder imul() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.IMUL));
    }

    default public CodeBuilder ineg() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.INEG));
    }

    default public CodeBuilder instanceOf(ClassEntry target) {
        return (CodeBuilder)this.with(TypeCheckInstruction.of(Opcode.INSTANCEOF, target));
    }

    default public CodeBuilder instanceOf(ClassDesc target) {
        return this.instanceOf(this.constantPool().classEntry(target));
    }

    default public CodeBuilder invokedynamic(InvokeDynamicEntry ref) {
        return (CodeBuilder)this.with(InvokeDynamicInstruction.of(ref));
    }

    default public CodeBuilder invokedynamic(DynamicCallSiteDesc ref) {
        MethodHandleEntry bsMethod = BytecodeHelpers.handleDescToHandleInfo(this.constantPool(), (DirectMethodHandleDesc)ref.bootstrapMethod());
        ConstantDesc[] cpArgs = ref.bootstrapArgs();
        ArrayList<LoadableConstantEntry> bsArguments = new ArrayList<LoadableConstantEntry>(cpArgs.length);
        for (ConstantDesc constantValue : cpArgs) {
            bsArguments.add(this.constantPool().loadableConstantEntry(Objects.requireNonNull(constantValue)));
        }
        BootstrapMethodEntry bm = this.constantPool().bsmEntry(bsMethod, bsArguments);
        NameAndTypeEntry nameAndType = this.constantPool().nameAndTypeEntry(ref.invocationName(), ref.invocationType());
        return this.invokedynamic(this.constantPool().invokeDynamicEntry(bm, nameAndType));
    }

    default public CodeBuilder invokeinterface(InterfaceMethodRefEntry ref) {
        return this.invoke(Opcode.INVOKEINTERFACE, ref);
    }

    default public CodeBuilder invokeinterface(ClassDesc owner, String name, MethodTypeDesc type) {
        return this.invoke(Opcode.INVOKEINTERFACE, this.constantPool().interfaceMethodRefEntry(owner, name, type));
    }

    default public CodeBuilder invokespecial(InterfaceMethodRefEntry ref) {
        return this.invoke(Opcode.INVOKESPECIAL, ref);
    }

    default public CodeBuilder invokespecial(MethodRefEntry ref) {
        return this.invoke(Opcode.INVOKESPECIAL, ref);
    }

    default public CodeBuilder invokespecial(ClassDesc owner, String name, MethodTypeDesc type) {
        return this.invoke(Opcode.INVOKESPECIAL, owner, name, type, false);
    }

    default public CodeBuilder invokespecial(ClassDesc owner, String name, MethodTypeDesc type, boolean isInterface) {
        return this.invoke(Opcode.INVOKESPECIAL, owner, name, type, isInterface);
    }

    default public CodeBuilder invokestatic(InterfaceMethodRefEntry ref) {
        return this.invoke(Opcode.INVOKESTATIC, ref);
    }

    default public CodeBuilder invokestatic(MethodRefEntry ref) {
        return this.invoke(Opcode.INVOKESTATIC, ref);
    }

    default public CodeBuilder invokestatic(ClassDesc owner, String name, MethodTypeDesc type) {
        return this.invoke(Opcode.INVOKESTATIC, owner, name, type, false);
    }

    default public CodeBuilder invokestatic(ClassDesc owner, String name, MethodTypeDesc type, boolean isInterface) {
        return this.invoke(Opcode.INVOKESTATIC, owner, name, type, isInterface);
    }

    default public CodeBuilder invokevirtual(MethodRefEntry ref) {
        return this.invoke(Opcode.INVOKEVIRTUAL, ref);
    }

    default public CodeBuilder invokevirtual(ClassDesc owner, String name, MethodTypeDesc type) {
        return this.invoke(Opcode.INVOKEVIRTUAL, owner, name, type, false);
    }

    default public CodeBuilder ior() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.IOR));
    }

    default public CodeBuilder irem() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.IREM));
    }

    default public CodeBuilder ireturn() {
        return this.return_(TypeKind.INT);
    }

    default public CodeBuilder ishl() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.ISHL));
    }

    default public CodeBuilder ishr() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.ISHR));
    }

    default public CodeBuilder istore(int slot) {
        return this.storeLocal(TypeKind.INT, slot);
    }

    default public CodeBuilder isub() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.ISUB));
    }

    default public CodeBuilder iushr() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.IUSHR));
    }

    default public CodeBuilder ixor() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.IXOR));
    }

    default public CodeBuilder lookupswitch(Label defaultTarget, List<SwitchCase> cases) {
        return (CodeBuilder)this.with(LookupSwitchInstruction.of(defaultTarget, cases));
    }

    default public CodeBuilder l2d() {
        return (CodeBuilder)this.with(ConvertInstruction.of(Opcode.L2D));
    }

    default public CodeBuilder l2f() {
        return (CodeBuilder)this.with(ConvertInstruction.of(Opcode.L2F));
    }

    default public CodeBuilder l2i() {
        return (CodeBuilder)this.with(ConvertInstruction.of(Opcode.L2I));
    }

    default public CodeBuilder ladd() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.LADD));
    }

    default public CodeBuilder laload() {
        return this.arrayLoad(TypeKind.LONG);
    }

    default public CodeBuilder land() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.LAND));
    }

    default public CodeBuilder lastore() {
        return this.arrayStore(TypeKind.LONG);
    }

    default public CodeBuilder lcmp() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.LCMP));
    }

    default public CodeBuilder lconst_0() {
        return (CodeBuilder)this.with(ConstantInstruction.ofIntrinsic(Opcode.LCONST_0));
    }

    default public CodeBuilder lconst_1() {
        return (CodeBuilder)this.with(ConstantInstruction.ofIntrinsic(Opcode.LCONST_1));
    }

    default public CodeBuilder ldc(ConstantDesc value) {
        return this.ldc(this.constantPool().loadableConstantEntry(Objects.requireNonNull(value)));
    }

    default public CodeBuilder ldc(LoadableConstantEntry entry) {
        return (CodeBuilder)this.with(ConstantInstruction.ofLoad(BytecodeHelpers.ldcOpcode(entry), entry));
    }

    default public CodeBuilder ldiv() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.LDIV));
    }

    default public CodeBuilder lload(int slot) {
        return this.loadLocal(TypeKind.LONG, slot);
    }

    default public CodeBuilder lmul() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.LMUL));
    }

    default public CodeBuilder lneg() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.LNEG));
    }

    default public CodeBuilder lor() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.LOR));
    }

    default public CodeBuilder lrem() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.LREM));
    }

    default public CodeBuilder lreturn() {
        return this.return_(TypeKind.LONG);
    }

    default public CodeBuilder lshl() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.LSHL));
    }

    default public CodeBuilder lshr() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.LSHR));
    }

    default public CodeBuilder lstore(int slot) {
        return this.storeLocal(TypeKind.LONG, slot);
    }

    default public CodeBuilder lsub() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.LSUB));
    }

    default public CodeBuilder lushr() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.LUSHR));
    }

    default public CodeBuilder lxor() {
        return (CodeBuilder)this.with(OperatorInstruction.of(Opcode.LXOR));
    }

    default public CodeBuilder monitorenter() {
        return (CodeBuilder)this.with(MonitorInstruction.of(Opcode.MONITORENTER));
    }

    default public CodeBuilder monitorexit() {
        return (CodeBuilder)this.with(MonitorInstruction.of(Opcode.MONITOREXIT));
    }

    default public CodeBuilder multianewarray(ClassEntry array, int dims) {
        return (CodeBuilder)this.with(NewMultiArrayInstruction.of(array, dims));
    }

    default public CodeBuilder multianewarray(ClassDesc array, int dims) {
        return this.multianewarray(this.constantPool().classEntry(array), dims);
    }

    default public CodeBuilder new_(ClassEntry clazz) {
        return (CodeBuilder)this.with(NewObjectInstruction.of(clazz));
    }

    default public CodeBuilder new_(ClassDesc clazz) {
        return this.new_(this.constantPool().classEntry(clazz));
    }

    default public CodeBuilder newarray(TypeKind typeKind) {
        return (CodeBuilder)this.with(NewPrimitiveArrayInstruction.of(typeKind));
    }

    default public CodeBuilder pop() {
        return (CodeBuilder)this.with(StackInstruction.of(Opcode.POP));
    }

    default public CodeBuilder pop2() {
        return (CodeBuilder)this.with(StackInstruction.of(Opcode.POP2));
    }

    default public CodeBuilder putfield(FieldRefEntry ref) {
        return this.fieldAccess(Opcode.PUTFIELD, ref);
    }

    default public CodeBuilder putfield(ClassDesc owner, String name, ClassDesc type) {
        return this.fieldAccess(Opcode.PUTFIELD, owner, name, type);
    }

    default public CodeBuilder putstatic(FieldRefEntry ref) {
        return this.fieldAccess(Opcode.PUTSTATIC, ref);
    }

    default public CodeBuilder putstatic(ClassDesc owner, String name, ClassDesc type) {
        return this.fieldAccess(Opcode.PUTSTATIC, owner, name, type);
    }

    default public CodeBuilder return_() {
        return this.return_(TypeKind.VOID);
    }

    default public CodeBuilder saload() {
        return this.arrayLoad(TypeKind.SHORT);
    }

    default public CodeBuilder sastore() {
        return this.arrayStore(TypeKind.SHORT);
    }

    default public CodeBuilder sipush(int s) {
        return (CodeBuilder)this.with(ConstantInstruction.ofArgument(Opcode.SIPUSH, s));
    }

    default public CodeBuilder swap() {
        return (CodeBuilder)this.with(StackInstruction.of(Opcode.SWAP));
    }

    default public CodeBuilder tableswitch(int low, int high, Label defaultTarget, List<SwitchCase> cases) {
        return (CodeBuilder)this.with(TableSwitchInstruction.of(low, high, defaultTarget, cases));
    }

    default public CodeBuilder tableswitch(Label defaultTarget, List<SwitchCase> cases) {
        int low = Integer.MAX_VALUE;
        int high = Integer.MIN_VALUE;
        for (SwitchCase c : cases) {
            int i = c.caseValue();
            if (i < low) {
                low = i;
            }
            if (i <= high) continue;
            high = i;
        }
        return this.tableswitch(low, high, defaultTarget, cases);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface CatchBuilder {
        public CatchBuilder catching(ClassDesc var1, Consumer<BlockCodeBuilder> var2);

        public CatchBuilder catchingMulti(List<ClassDesc> var1, Consumer<BlockCodeBuilder> var2);

        public void catchingAll(Consumer<BlockCodeBuilder> var1);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface BlockCodeBuilder
    extends CodeBuilder {
        public Label breakLabel();
    }
}

