/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.beanbag;

import io.smallrye.beanbag.AllBeansResolver;
import io.smallrye.beanbag.AllBeansWithNamesResolver;
import io.smallrye.beanbag.BeanResolver;
import io.smallrye.beanbag.DependencyFilter;
import io.smallrye.beanbag.Scope;
import io.smallrye.common.constraint.Assert;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public interface BeanSupplier<T> {
    public T get(Scope var1);

    public static <T> BeanSupplier<T> of(T instance) {
        return scope -> instance;
    }

    default public <U> BeanSupplier<U> transform(Function<T, U> function) {
        Assert.checkNotNullParam((String)"function", function);
        return scope -> function.apply(this.get(scope));
    }

    public static <T> BeanSupplier<T> resolving(Class<T> type, String name, boolean optional, DependencyFilter filter) {
        Assert.checkNotNullParam((String)"type", type);
        Assert.checkNotNullParam((String)"name", (Object)name);
        Assert.checkNotNullParam((String)"filter", (Object)filter);
        return new BeanResolver<T>(type, name, optional, filter);
    }

    public static <T> BeanSupplier<List<T>> resolvingAll(Class<T> type, String name, DependencyFilter filter) {
        Assert.checkNotNullParam((String)"type", type);
        Assert.checkNotNullParam((String)"name", (Object)name);
        Assert.checkNotNullParam((String)"filter", (Object)filter);
        return new AllBeansResolver<T>(type, name, filter);
    }

    public static <T> BeanSupplier<Map<String, T>> resolvingAllByName(Class<T> type, DependencyFilter filter) {
        Assert.checkNotNullParam((String)"type", type);
        Assert.checkNotNullParam((String)"filter", (Object)filter);
        return new AllBeansWithNamesResolver<T>(type, filter);
    }
}

