/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.util;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jboss.resteasy.reactive.common.headers.MediaTypeHeaderDelegate;

public class MediaTypeHelper {
    public static final MediaTypeComparator Q_COMPARATOR = new MediaTypeComparator("q");
    public static final MediaTypeComparator QS_COMPARATOR = new MediaTypeComparator("qs");
    private static final String MEDIA_TYPE_SUFFIX_DELIM = "+";

    public static MediaType valueOf(String value) {
        return MediaTypeHeaderDelegate.INSTANCE.fromString(value);
    }

    public static String toString(MediaType mediaType) {
        return MediaTypeHeaderDelegate.INSTANCE.toString(mediaType);
    }

    private static float getQTypeWithParamInfo(MediaType type, String parameterName) {
        if (type.getParameters() != null) {
            String val = (String)type.getParameters().get(parameterName);
            try {
                if (val != null) {
                    float rtn = Float.parseFloat(val);
                    if (rtn > 1.0f) {
                        throw new WebApplicationException(String.format("Media type %s greater than 1: %s", parameterName, type), Response.Status.BAD_REQUEST);
                    }
                    return rtn;
                }
            }
            catch (NumberFormatException e) {
                throw new WebApplicationException(String.format("Media type %s value must be a float: %s", parameterName, type), Response.Status.BAD_REQUEST);
            }
        }
        return 2.0f;
    }

    public static float getQWithParamInfo(MediaType type) {
        return MediaTypeHelper.getQTypeWithParamInfo(type, "q");
    }

    public static boolean isCompositeWildcardSubtype(String subtype) {
        return subtype.startsWith("*+");
    }

    public static boolean isWildcardCompositeSubtype(String subtype) {
        return subtype.endsWith("+*");
    }

    public static boolean isComposite(String subtype) {
        return MediaTypeHelper.isCompositeWildcardSubtype(subtype) || MediaTypeHelper.isWildcardCompositeSubtype(subtype);
    }

    public static int compareWeight(MediaType one, MediaType two) {
        return Q_COMPARATOR.compare(one, two);
    }

    public static int compareMatchingMediaTypes(List<MediaType> produces, List<MediaType> mediaTypes1, List<MediaType> mediaTypes2) {
        int countMediaTypes2;
        int countMediaTypes1 = MediaTypeHelper.countMatchingMediaTypes(produces, mediaTypes1);
        return countMediaTypes1 < (countMediaTypes2 = MediaTypeHelper.countMatchingMediaTypes(produces, mediaTypes2)) ? 1 : (countMediaTypes1 == countMediaTypes2 ? 0 : -1);
    }

    public static void sortByWeight(List<MediaType> types) {
        if (MediaTypeHelper.hasAtMostOneItem(types)) {
            return;
        }
        ArrayList<IndexedMediaType> indexed = new ArrayList<IndexedMediaType>(types.size());
        for (int i = 0; i < types.size(); ++i) {
            indexed.add(new IndexedMediaType(types.get(i), i));
        }
        indexed.sort(new Comparator<IndexedMediaType>(){

            @Override
            public int compare(IndexedMediaType a, IndexedMediaType b) {
                int cmp = Q_COMPARATOR.compare(a.mediaType, b.mediaType);
                return cmp != 0 ? cmp : Integer.compare(a.originalIndex, b.originalIndex);
            }
        });
        types.clear();
        for (IndexedMediaType imt : indexed) {
            types.add(imt.mediaType);
        }
    }

    public static void sortByQSWeight(List<MediaType> types) {
        if (MediaTypeHelper.hasAtMostOneItem(types)) {
            return;
        }
        types.sort(QS_COMPARATOR);
    }

    private static boolean hasAtMostOneItem(List<MediaType> types) {
        return types == null || types.size() <= 1;
    }

    public static MediaType getBestMatch(List<MediaType> desired, List<MediaType> provided) {
        if (!MediaTypeHelper.hasAtMostOneItem(desired)) {
            desired = new ArrayList<MediaType>(desired);
            MediaTypeHelper.sortByWeight(desired);
        }
        if (!MediaTypeHelper.hasAtMostOneItem(provided)) {
            provided = new ArrayList<MediaType>(provided);
            MediaTypeHelper.sortByWeight(provided);
        }
        return MediaTypeHelper.getFirstMatch(desired, provided);
    }

    public static MediaType getFirstMatch(List<MediaType> desired, List<MediaType> provided) {
        boolean emptyProvided;
        boolean emptyDesired = desired == null || desired.size() == 0;
        boolean bl = emptyProvided = provided == null || provided.size() == 0;
        if (emptyDesired && emptyProvided) {
            return null;
        }
        if (emptyDesired) {
            return provided.get(0);
        }
        if (emptyProvided) {
            return desired.get(0);
        }
        for (int i = 0; i < desired.size(); ++i) {
            for (int j = 0; j < provided.size(); ++j) {
                MediaType provide = provided.get(j);
                if (!provide.isCompatible(desired.get(i))) continue;
                return provide;
            }
        }
        return null;
    }

    public static List<MediaType> parseHeader(String header) {
        String[] medias;
        ArrayList<MediaType> types = new ArrayList<MediaType>();
        for (String media : medias = header.split(",")) {
            types.add(MediaTypeHelper.valueOf(media.trim()));
        }
        return types;
    }

    public static boolean equivalent(MediaType m1, MediaType m2) {
        if (m1 == m2) {
            return true;
        }
        if (!m1.getType().equals(m2.getType())) {
            return false;
        }
        if (!m1.getSubtype().equals(m2.getSubtype())) {
            return false;
        }
        return MediaTypeHelper.equivalentParams(m1, m2);
    }

    public static boolean equivalentParams(MediaType m1, MediaType m2) {
        Map params2;
        Map params1 = m1.getParameters();
        if (params1 == (params2 = m2.getParameters())) {
            return true;
        }
        if (params1 == null || params2 == null) {
            return false;
        }
        if (params1.size() == 0 && params2.size() == 0) {
            return true;
        }
        int numParams1 = params1.size();
        if (params1.containsKey("q")) {
            --numParams1;
        }
        int numParams2 = params2.size();
        if (params2.containsKey("q")) {
            --numParams2;
        }
        if (numParams1 != numParams2) {
            return false;
        }
        if (numParams1 == 0) {
            return true;
        }
        for (Map.Entry entry : params1.entrySet()) {
            String value2;
            String value;
            String key = (String)entry.getKey();
            if (key.equals("q") || (value = (String)entry.getValue()) == (value2 = (String)params2.get(key))) continue;
            if (value == null || value2 == null) {
                return false;
            }
            if (value.equals(value2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isTextLike(MediaType mediaType) {
        String type = mediaType.getType();
        String subtype = mediaType.getSubtype();
        return type.equals("application") && (subtype.contains("json") || subtype.contains("xml") || subtype.contains("yaml")) || type.equals("text");
    }

    public static boolean isUnsupportedWildcardSubtype(MediaType mediaType) {
        if (mediaType.isWildcardSubtype()) {
            return !mediaType.isWildcardType() && !"application".equals(mediaType.getType());
        }
        return false;
    }

    public static List<MediaType> toListOfMediaType(String[] mediaTypes) {
        if (mediaTypes == null || mediaTypes.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<MediaType> list = new ArrayList<MediaType>(mediaTypes.length);
        for (String mediaType : mediaTypes) {
            list.add(MediaTypeHelper.valueOf(mediaType));
        }
        return Collections.unmodifiableList(list);
    }

    public static List<MediaType> getUngroupedMediaTypes(List<MediaType> mediaTypes) {
        ArrayList<MediaType> effectiveMediaTypes = new ArrayList<MediaType>();
        for (MediaType mediaType : mediaTypes) {
            effectiveMediaTypes.addAll(MediaTypeHelper.getUngroupedMediaTypes(mediaType));
        }
        return Collections.unmodifiableList(effectiveMediaTypes);
    }

    public static List<MediaType> getUngroupedMediaTypes(MediaType mediaType) {
        if (mediaType == null) {
            return Collections.emptyList();
        }
        if (mediaType.getSubtype() == null || !mediaType.getSubtype().contains(MEDIA_TYPE_SUFFIX_DELIM)) {
            return Collections.singletonList(mediaType);
        }
        String[] subTypes = mediaType.getSubtype().split(Pattern.quote(MEDIA_TYPE_SUFFIX_DELIM));
        ArrayList<MediaType> effectiveMediaTypes = new ArrayList<MediaType>(1 + subTypes.length);
        effectiveMediaTypes.add(mediaType);
        for (String subType : subTypes) {
            effectiveMediaTypes.add(new MediaType(mediaType.getType(), subType, mediaType.getParameters()));
        }
        return Collections.unmodifiableList(effectiveMediaTypes);
    }

    private static int countMatchingMediaTypes(List<MediaType> produces, List<MediaType> mediaTypes) {
        int count = 0;
        block0: for (int i = 0; i < mediaTypes.size(); ++i) {
            MediaType mediaType = mediaTypes.get(i);
            for (int j = 0; j < produces.size(); ++j) {
                MediaType produce = produces.get(j);
                if (!mediaType.isCompatible(produce)) continue;
                ++count;
                continue block0;
            }
        }
        return count;
    }

    public static class MediaTypeComparator
    implements Comparator<MediaType>,
    Serializable {
        private static final long serialVersionUID = -5828700121582498092L;
        private final String parameterName;

        public MediaTypeComparator(String parameterName) {
            this.parameterName = parameterName;
        }

        @Override
        public int compare(MediaType mediaType2, MediaType mediaType) {
            float q2;
            boolean wasQ2;
            boolean wasQ;
            float q = MediaTypeHelper.getQTypeWithParamInfo(mediaType, this.parameterName);
            boolean bl = wasQ = q != 2.0f;
            if (q == 2.0f) {
                q = 1.0f;
            }
            boolean bl2 = wasQ2 = (q2 = MediaTypeHelper.getQTypeWithParamInfo(mediaType2, this.parameterName)) != 2.0f;
            if (q2 == 2.0f) {
                q2 = 1.0f;
            }
            if (q < q2) {
                return -1;
            }
            if (q > q2) {
                return 1;
            }
            if (mediaType.isWildcardType() && !mediaType2.isWildcardType()) {
                return -1;
            }
            if (!mediaType.isWildcardType() && mediaType2.isWildcardType()) {
                return 1;
            }
            if (mediaType.isWildcardSubtype() && !mediaType2.isWildcardSubtype()) {
                return -1;
            }
            if (!mediaType.isWildcardSubtype() && mediaType2.isWildcardSubtype()) {
                return 1;
            }
            if (MediaTypeHelper.isComposite(mediaType.getSubtype()) && !MediaTypeHelper.isComposite(mediaType2.getSubtype())) {
                return -1;
            }
            if (!MediaTypeHelper.isComposite(mediaType.getSubtype()) && MediaTypeHelper.isComposite(mediaType2.getSubtype())) {
                return 1;
            }
            if (MediaTypeHelper.isCompositeWildcardSubtype(mediaType.getSubtype()) && !MediaTypeHelper.isCompositeWildcardSubtype(mediaType2.getSubtype())) {
                return -1;
            }
            if (!MediaTypeHelper.isCompositeWildcardSubtype(mediaType.getSubtype()) && MediaTypeHelper.isCompositeWildcardSubtype(mediaType2.getSubtype())) {
                return 1;
            }
            if (MediaTypeHelper.isWildcardCompositeSubtype(mediaType.getSubtype()) && !MediaTypeHelper.isWildcardCompositeSubtype(mediaType2.getSubtype())) {
                return -1;
            }
            if (!MediaTypeHelper.isWildcardCompositeSubtype(mediaType.getSubtype()) && MediaTypeHelper.isWildcardCompositeSubtype(mediaType2.getSubtype())) {
                return 1;
            }
            return 0;
        }
    }

    private record IndexedMediaType(MediaType mediaType, int originalIndex) {
    }
}

