/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.generator;

import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.qute.TemplateGlobal;
import io.quarkus.qute.TemplateInstance;
import io.quarkus.qute.generator.Descriptors;
import io.quarkus.qute.generator.ValueResolverGenerator;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class TemplateGlobalGenerator {
    public static final DotName TEMPLATE_GLOBAL = DotName.createSimple((String)TemplateGlobal.class.getName());
    public static final String NAME = "name";
    public static final String SUFFIX = "_Globals";
    private final Set<String> generatedTypes = new HashSet<String>();
    private final ClassOutput classOutput;

    public TemplateGlobalGenerator(ClassOutput classOutput) {
        this.classOutput = classOutput;
    }

    public void generate(ClassInfo declaringClass, Map<String, AnnotationTarget> targets) {
        Object baseName = declaringClass.enclosingClass() != null ? ValueResolverGenerator.simpleName(declaringClass.enclosingClass()) + "$_" + ValueResolverGenerator.simpleName(declaringClass) : ValueResolverGenerator.simpleName(declaringClass);
        String targetPackage = ValueResolverGenerator.packageName(declaringClass.name());
        String generatedName = ValueResolverGenerator.generatedNameFromTarget(targetPackage, (String)baseName, SUFFIX);
        this.generatedTypes.add(generatedName.replace('/', '.'));
        ClassCreator initializer = ClassCreator.builder().classOutput(this.classOutput).className(generatedName).interfaces(new Class[]{TemplateInstance.Initializer.class}).build();
        MethodCreator accept = (MethodCreator)initializer.getMethodCreator("accept", Void.TYPE, new Class[]{Object.class}).setModifiers(1);
        for (Map.Entry<String, AnnotationTarget> entry : targets.entrySet()) {
            ResultHandle global;
            ResultHandle name = accept.load(entry.getKey());
            switch (entry.getValue().kind()) {
                case FIELD: {
                    FieldInfo field = entry.getValue().asField();
                    TemplateGlobalGenerator.validate(field);
                    global = accept.readStaticField(FieldDescriptor.of((FieldInfo)field));
                    break;
                }
                case METHOD: {
                    MethodInfo method = entry.getValue().asMethod();
                    TemplateGlobalGenerator.validate(method);
                    global = accept.invokeStaticMethod(MethodDescriptor.of((MethodInfo)method), new ResultHandle[0]);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported target: " + entry.getValue());
                }
            }
            accept.invokeInterfaceMethod(Descriptors.TEMPLATE_INSTANCE_DATA, accept.getMethodParam(0), new ResultHandle[]{name, global});
        }
        accept.returnValue(null);
        initializer.close();
    }

    public Set<String> getGeneratedTypes() {
        return this.generatedTypes;
    }

    public static void validate(MethodInfo method) {
        if (!Modifier.isStatic(method.flags())) {
            throw new IllegalStateException("Global variable method declared on " + method.declaringClass().name() + " must be static: " + method);
        }
        if (method.returnType().kind() == Type.Kind.VOID) {
            throw new IllegalStateException("Global variable method declared on " + method.declaringClass().name() + " must not return void: " + method);
        }
        if (!method.parameters().isEmpty()) {
            throw new IllegalStateException("Global variable method declared on " + method.declaringClass().name() + " must not accept any parameter: " + method);
        }
        if (Modifier.isPrivate(method.flags())) {
            throw new IllegalStateException("Global variable method declared on " + method.declaringClass().name() + " must not be private: " + method);
        }
    }

    public static void validate(FieldInfo field) {
        if (!Modifier.isStatic(field.flags())) {
            throw new IllegalStateException("Global variable field declared on " + field.declaringClass().name() + "  must be static: " + field);
        }
        if (Modifier.isPrivate(field.flags())) {
            throw new IllegalStateException("Global variable field declared on " + field.declaringClass().name() + " must not be private: " + field);
        }
    }
}

