/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.generator;

import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FunctionCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.EvaluatedParams;
import io.quarkus.qute.NamespaceResolver;
import io.quarkus.qute.TemplateExtension;
import io.quarkus.qute.ValueResolver;
import io.quarkus.qute.generator.Descriptors;
import io.quarkus.qute.generator.ValueResolverGenerator;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class ExtensionMethodGenerator {
    public static final DotName TEMPLATE_EXTENSION = DotName.createSimple((String)TemplateExtension.class.getName());
    static final DotName STRING = DotName.createSimple((String)String.class.getName());
    public static final String SUFFIX = "_Extension_ValueResolver";
    public static final String MATCH_NAME = "matchName";
    public static final String PRIORITY = "priority";
    public static final String NAMESPACE = "namespace";
    private final Set<String> generatedTypes;
    private final ClassOutput classOutput;

    public ExtensionMethodGenerator(ClassOutput classOutput) {
        this.classOutput = classOutput;
        this.generatedTypes = new HashSet<String>();
    }

    public Set<String> getGeneratedTypes() {
        return this.generatedTypes;
    }

    public static void validate(MethodInfo method, List<Type> parameters, String namespace) {
        if (!Modifier.isStatic(method.flags())) {
            throw new IllegalStateException("Template extension method must be static: " + method);
        }
        if (method.returnType().kind() == Type.Kind.VOID) {
            throw new IllegalStateException("Template extension method must not return void: " + method);
        }
        if ((namespace == null || namespace.isEmpty()) && parameters.isEmpty()) {
            throw new IllegalStateException("Template extension method must declare at least one parameter: " + method);
        }
    }

    public void generate(MethodInfo method, String matchName, Integer priority) {
        AnnotationValue priorityValue;
        AnnotationValue matchNameValue;
        AnnotationInstance extensionAnnotation = method.annotation(TEMPLATE_EXTENSION);
        List parameters = method.parameters();
        ExtensionMethodGenerator.validate(method, parameters, null);
        ClassInfo declaringClass = method.declaringClass();
        if (matchName == null && extensionAnnotation != null && (matchNameValue = extensionAnnotation.value(MATCH_NAME)) != null) {
            matchName = matchNameValue.asString();
        }
        if (matchName == null || matchName.equals("<<method name>>")) {
            matchName = method.name();
        }
        if (matchName.equals("*") && (parameters.size() < 2 || !((Type)parameters.get(1)).name().equals((Object)STRING))) {
            throw new IllegalStateException("Template extension method matching multiple names must declare at least two parameters and the second parameter must be string: " + method);
        }
        if (priority == null && extensionAnnotation != null && (priorityValue = extensionAnnotation.value(PRIORITY)) != null) {
            priority = priorityValue.asInt();
        }
        if (priority == null) {
            priority = 5;
        }
        String baseName = declaringClass.enclosingClass() != null ? ValueResolverGenerator.simpleName(declaringClass.enclosingClass()) + "$_" + ValueResolverGenerator.simpleName(declaringClass) : ValueResolverGenerator.simpleName(declaringClass);
        String targetPackage = ValueResolverGenerator.packageName(declaringClass.name());
        String suffix = "_Extension_ValueResolver_" + method.name() + "_" + ExtensionMethodGenerator.sha1(parameters.toString());
        String generatedName = ValueResolverGenerator.generatedNameFromTarget(targetPackage, baseName, suffix);
        this.generatedTypes.add(generatedName.replace('/', '.'));
        ClassCreator valueResolver = ClassCreator.builder().classOutput(this.classOutput).className(generatedName).interfaces(new Class[]{ValueResolver.class}).build();
        this.implementGetPriority(valueResolver, priority);
        this.implementAppliesTo(valueResolver, method, matchName);
        this.implementResolve(valueResolver, declaringClass, method, matchName);
        valueResolver.close();
    }

    public NamespaceResolverCreator createNamespaceResolver(ClassInfo declaringClass, String namespace) {
        return new NamespaceResolverCreator(declaringClass, namespace);
    }

    private void implementGetNamespace(ClassCreator namespaceResolver, String namespace) {
        MethodCreator getNamespace = (MethodCreator)namespaceResolver.getMethodCreator("getNamespace", String.class, new Class[0]).setModifiers(1);
        getNamespace.returnValue(getNamespace.load(namespace));
    }

    private void implementGetPriority(ClassCreator valueResolver, int priority) {
        MethodCreator getPriority = (MethodCreator)valueResolver.getMethodCreator("getPriority", Integer.TYPE, new Class[0]).setModifiers(1);
        getPriority.returnValue(getPriority.load(priority));
    }

    private void implementResolve(ClassCreator valueResolver, ClassInfo declaringClass, MethodInfo method, String matchName) {
        ResultHandle ret;
        MethodCreator resolve = (MethodCreator)valueResolver.getMethodCreator("resolve", CompletionStage.class, new Class[]{EvalContext.class}).setModifiers(1);
        ResultHandle evalContext = resolve.getMethodParam(0);
        ResultHandle base = resolve.invokeInterfaceMethod(Descriptors.GET_BASE, evalContext, new ResultHandle[0]);
        boolean matchAny = matchName.equals("*");
        List parameters = method.parameters();
        int paramSize = parameters.size();
        if (paramSize == 1 || paramSize == 2 && matchAny) {
            ResultHandle[] args = new ResultHandle[paramSize];
            args[0] = base;
            if (matchAny) {
                args[1] = resolve.invokeInterfaceMethod(Descriptors.GET_NAME, evalContext, new ResultHandle[0]);
            }
            ret = resolve.invokeStaticMethod(Descriptors.COMPLETED_FUTURE, new ResultHandle[]{resolve.invokeStaticMethod(MethodDescriptor.ofMethod((Object)declaringClass.name().toString(), (String)method.name(), (Object)method.returnType().name().toString(), (Object[])parameters.stream().map(p -> p.name().toString()).collect(Collectors.toList()).toArray()), args)});
        } else {
            ret = resolve.newInstance(MethodDescriptor.ofConstructor(CompletableFuture.class, (Class[])new Class[0]), new ResultHandle[0]);
            int realParamSize = paramSize - (matchAny ? 2 : 1);
            ResultHandle name = resolve.invokeInterfaceMethod(Descriptors.GET_NAME, evalContext, new ResultHandle[0]);
            ResultHandle evaluatedParams = resolve.invokeStaticMethod(Descriptors.EVALUATED_PARAMS_EVALUATE, new ResultHandle[]{evalContext});
            ResultHandle paramsReady = resolve.readInstanceField(Descriptors.EVALUATED_PARAMS_STAGE, evaluatedParams);
            FunctionCreator whenCompleteFun = resolve.createFunction(BiConsumer.class);
            resolve.invokeInterfaceMethod(Descriptors.CF_WHEN_COMPLETE, paramsReady, new ResultHandle[]{whenCompleteFun.getInstance()});
            BytecodeCreator whenComplete = whenCompleteFun.getBytecode();
            AssignableResultHandle whenBase = whenComplete.createVariable(Object.class);
            whenComplete.assign(whenBase, base);
            AssignableResultHandle whenName = null;
            if (matchAny) {
                whenName = whenComplete.createVariable(String.class);
                whenComplete.assign(whenName, name);
            }
            AssignableResultHandle whenRet = whenComplete.createVariable(CompletableFuture.class);
            whenComplete.assign(whenRet, ret);
            AssignableResultHandle whenEvaluatedParams = whenComplete.createVariable(EvaluatedParams.class);
            whenComplete.assign(whenEvaluatedParams, evaluatedParams);
            BranchResult throwableIsNull = whenComplete.ifNull(whenComplete.getMethodParam(1));
            BytecodeCreator success = throwableIsNull.trueBranch();
            boolean isVarArgs = ValueResolverGenerator.isVarArgs(method);
            if (realParamSize > 0) {
                ResultHandle paramTypesHandle = success.newArray(Class.class, realParamSize);
                int idx = 0;
                for (Type parameterType : parameters.subList(paramSize - realParamSize, paramSize)) {
                    success.writeArrayValue(paramTypesHandle, idx++, ValueResolverGenerator.loadParamType(success, parameterType));
                }
                BytecodeCreator typeMatchFailed = success.ifNonZero(success.invokeVirtualMethod(Descriptors.EVALUATED_PARAMS_PARAM_TYPES_MATCH, (ResultHandle)whenEvaluatedParams, new ResultHandle[]{success.load(isVarArgs), paramTypesHandle})).falseBranch();
                typeMatchFailed.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE, (ResultHandle)whenRet, new ResultHandle[]{typeMatchFailed.readStaticField(Descriptors.RESULT_NOT_FOUND)});
                typeMatchFailed.returnValue(null);
            }
            TryBlock tryCatch = success.tryBlock();
            CatchBlockCreator exception = tryCatch.addCatch(Throwable.class);
            exception.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (ResultHandle)whenRet, new ResultHandle[]{exception.getCaughtException()});
            ResultHandle[] args = new ResultHandle[paramSize];
            int shift = 0;
            args[shift] = whenBase;
            ++shift;
            if (matchAny) {
                args[shift] = whenName;
                ++shift;
            }
            if (isVarArgs) {
                ResultHandle varargsResults;
                int paramIdx = realParamSize - 1;
                for (int i = 0; i < paramIdx; ++i) {
                    ResultHandle resultHandle;
                    args[i + shift] = resultHandle = tryCatch.invokeVirtualMethod(Descriptors.EVALUATED_PARAMS_GET_RESULT, (ResultHandle)whenEvaluatedParams, new ResultHandle[]{tryCatch.load(i)});
                }
                Type varargsParam = (Type)parameters.get(paramSize - 1);
                ResultHandle componentType = tryCatch.loadClass(varargsParam.asArrayType().component().name().toString());
                args[paramIdx + shift] = varargsResults = tryCatch.invokeVirtualMethod(Descriptors.EVALUATED_PARAMS_GET_VARARGS_RESULTS, evaluatedParams, new ResultHandle[]{tryCatch.load(realParamSize), componentType});
            } else {
                for (int i = 0; i < realParamSize; ++i) {
                    args[i + shift] = tryCatch.invokeVirtualMethod(Descriptors.EVALUATED_PARAMS_GET_RESULT, evaluatedParams, new ResultHandle[]{tryCatch.load(i)});
                }
            }
            ResultHandle invokeRet = tryCatch.invokeStaticMethod(MethodDescriptor.ofMethod((Object)declaringClass.name().toString(), (String)method.name(), (Object)method.returnType().name().toString(), (Object[])method.parameters().stream().map(p -> p.name().toString()).collect(Collectors.toList()).toArray()), args);
            tryCatch.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE, (ResultHandle)whenRet, new ResultHandle[]{invokeRet});
            BytecodeCreator failure = throwableIsNull.falseBranch();
            failure.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (ResultHandle)whenRet, new ResultHandle[]{whenComplete.getMethodParam(1)});
            whenComplete.returnValue(null);
        }
        resolve.returnValue(ret);
    }

    private void implementAppliesTo(ClassCreator valueResolver, MethodInfo method, String matchName) {
        MethodCreator appliesTo = (MethodCreator)valueResolver.getMethodCreator("appliesTo", Boolean.TYPE, new Class[]{EvalContext.class}).setModifiers(1);
        List parameters = method.parameters();
        boolean matchAny = matchName.equals("*");
        boolean isVarArgs = ValueResolverGenerator.isVarArgs(method);
        int realParamSize = parameters.size() - (matchAny ? 2 : 1);
        ResultHandle evalContext = appliesTo.getMethodParam(0);
        ResultHandle base = appliesTo.invokeInterfaceMethod(Descriptors.GET_BASE, evalContext, new ResultHandle[0]);
        ResultHandle name = appliesTo.invokeInterfaceMethod(Descriptors.GET_NAME, evalContext, new ResultHandle[0]);
        BytecodeCreator baseNull = appliesTo.ifNull(base).trueBranch();
        baseNull.returnValue(baseNull.load(false));
        ResultHandle baseClass = appliesTo.invokeVirtualMethod(Descriptors.GET_CLASS, base, new ResultHandle[0]);
        ResultHandle testClass = appliesTo.loadClass(((Type)parameters.get(0)).name().toString());
        ResultHandle baseClassTest = appliesTo.invokeVirtualMethod(Descriptors.IS_ASSIGNABLE_FROM, testClass, new ResultHandle[]{baseClass});
        BytecodeCreator baseNotAssignable = appliesTo.ifTrue(baseClassTest).falseBranch();
        baseNotAssignable.returnValue(baseNotAssignable.load(false));
        if (!matchAny) {
            ResultHandle nameTest = appliesTo.invokeVirtualMethod(Descriptors.EQUALS, name, new ResultHandle[]{appliesTo.load(matchName)});
            BytecodeCreator nameNotMatched = appliesTo.ifTrue(nameTest).falseBranch();
            nameNotMatched.returnValue(nameNotMatched.load(false));
        }
        if (!isVarArgs || realParamSize > 1) {
            ResultHandle params = appliesTo.invokeInterfaceMethod(Descriptors.GET_PARAMS, evalContext, new ResultHandle[0]);
            ResultHandle paramsCount = appliesTo.invokeInterfaceMethod(Descriptors.COLLECTION_SIZE, params, new ResultHandle[0]);
            BytecodeCreator paramsNotMatching = isVarArgs ? appliesTo.ifIntegerGreaterThan(appliesTo.load(realParamSize - 1), paramsCount).trueBranch() : appliesTo.ifIntegerEqual(appliesTo.load(realParamSize), paramsCount).falseBranch();
            paramsNotMatching.returnValue(paramsNotMatching.load(false));
        }
        appliesTo.returnValue(appliesTo.load(true));
    }

    private BytecodeCreator createNamespaceExtensionMatchScope(BytecodeCreator bytecodeCreator, MethodInfo method, int realParamSize, String matchName, ResultHandle name, ResultHandle params, ResultHandle paramsCount) {
        boolean matchAny = matchName.equals("*");
        boolean isVarArgs = ValueResolverGenerator.isVarArgs(method);
        BytecodeCreator matchScope = bytecodeCreator.createScope();
        if (!matchAny) {
            matchScope.ifNonZero(matchScope.invokeVirtualMethod(Descriptors.EQUALS, matchScope.load(matchName), new ResultHandle[]{name})).falseBranch().breakScope(matchScope);
        }
        if (!isVarArgs || realParamSize > 1) {
            if (isVarArgs) {
                matchScope.ifIntegerLessEqual(matchScope.load(realParamSize - 1), paramsCount).falseBranch().breakScope(matchScope);
            } else {
                matchScope.ifIntegerEqual(matchScope.load(realParamSize), paramsCount).falseBranch().breakScope(matchScope);
            }
        }
        return matchScope;
    }

    static String sha1(String value) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] digest = md.digest(value.getBytes(StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder(40);
            for (int i = 0; i < digest.length; ++i) {
                sb.append(Integer.toHexString(digest[i] & 0xFF | 0x100).substring(1, 3));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public class NamespaceResolverCreator
    implements AutoCloseable {
        private final ClassCreator namespaceResolver;

        public NamespaceResolverCreator(ClassInfo declaringClass, String namespace) {
            String baseName = declaringClass.enclosingClass() != null ? ValueResolverGenerator.simpleName(declaringClass.enclosingClass()) + "$_" + ValueResolverGenerator.simpleName(declaringClass) : ValueResolverGenerator.simpleName(declaringClass);
            String targetPackage = ValueResolverGenerator.packageName(declaringClass.name());
            String suffix = "_Namespace_Extension_ValueResolver" + ExtensionMethodGenerator.sha1(namespace);
            String generatedName = ValueResolverGenerator.generatedNameFromTarget(targetPackage, baseName, suffix);
            ExtensionMethodGenerator.this.generatedTypes.add(generatedName.replace('/', '.'));
            this.namespaceResolver = ClassCreator.builder().classOutput(ExtensionMethodGenerator.this.classOutput).className(generatedName).interfaces(new Class[]{NamespaceResolver.class}).build();
            ExtensionMethodGenerator.this.implementGetNamespace(this.namespaceResolver, namespace);
        }

        public ResolveCreator implementResolve() {
            return new ResolveCreator();
        }

        @Override
        public void close() {
            this.namespaceResolver.close();
        }

        public class ResolveCreator
        implements AutoCloseable {
            private final MethodCreator resolve;
            private final ResultHandle evalContext;
            private final ResultHandle name;
            private final ResultHandle params;
            private final ResultHandle paramsCount;

            public ResolveCreator() {
                this.resolve = (MethodCreator)NamespaceResolverCreator.this.namespaceResolver.getMethodCreator("resolve", CompletionStage.class, new Class[]{EvalContext.class}).setModifiers(1);
                this.evalContext = this.resolve.getMethodParam(0);
                this.name = this.resolve.invokeInterfaceMethod(Descriptors.GET_NAME, this.evalContext, new ResultHandle[0]);
                this.params = this.resolve.invokeInterfaceMethod(Descriptors.GET_PARAMS, this.evalContext, new ResultHandle[0]);
                this.paramsCount = this.resolve.invokeInterfaceMethod(Descriptors.COLLECTION_SIZE, this.params, new ResultHandle[0]);
            }

            public void addMethod(MethodInfo method, String matchName) {
                List parameters = method.parameters();
                int paramSize = parameters.size();
                boolean matchAny = matchName.equals("*");
                int realParamSize = paramSize - (matchAny ? 1 : 0);
                BytecodeCreator matchScope = ExtensionMethodGenerator.this.createNamespaceExtensionMatchScope((BytecodeCreator)this.resolve, method, realParamSize, matchName, this.name, this.params, this.paramsCount);
                ResultHandle ret = matchScope.newInstance(MethodDescriptor.ofConstructor(CompletableFuture.class, (Class[])new Class[0]), new ResultHandle[0]);
                if (paramSize == 1 && matchAny) {
                    ResultHandle[] args = new ResultHandle[]{this.name};
                    matchScope.returnValue(matchScope.invokeStaticMethod(Descriptors.COMPLETED_FUTURE, new ResultHandle[]{matchScope.invokeStaticMethod(MethodDescriptor.of((MethodInfo)method), args)}));
                } else {
                    ResultHandle evaluatedParams = matchScope.invokeStaticMethod(Descriptors.EVALUATED_PARAMS_EVALUATE, new ResultHandle[]{this.evalContext});
                    ResultHandle paramsReady = matchScope.readInstanceField(Descriptors.EVALUATED_PARAMS_STAGE, evaluatedParams);
                    FunctionCreator whenCompleteFun = matchScope.createFunction(BiConsumer.class);
                    matchScope.invokeInterfaceMethod(Descriptors.CF_WHEN_COMPLETE, paramsReady, new ResultHandle[]{whenCompleteFun.getInstance()});
                    BytecodeCreator whenComplete = whenCompleteFun.getBytecode();
                    AssignableResultHandle whenName = null;
                    if (matchAny) {
                        whenName = whenComplete.createVariable(String.class);
                        whenComplete.assign(whenName, this.name);
                    }
                    AssignableResultHandle whenRet = whenComplete.createVariable(CompletableFuture.class);
                    whenComplete.assign(whenRet, ret);
                    AssignableResultHandle whenEvaluatedParams = whenComplete.createVariable(EvaluatedParams.class);
                    whenComplete.assign(whenEvaluatedParams, evaluatedParams);
                    BranchResult throwableIsNull = whenComplete.ifNull(whenComplete.getMethodParam(1));
                    BytecodeCreator success = throwableIsNull.trueBranch();
                    boolean isVarArgs = ValueResolverGenerator.isVarArgs(method);
                    if (realParamSize > 0) {
                        ResultHandle paramTypesHandle = success.newArray(Class.class, realParamSize);
                        int idx = 0;
                        for (Type parameterType : parameters.subList(paramSize - realParamSize, paramSize)) {
                            success.writeArrayValue(paramTypesHandle, idx++, ValueResolverGenerator.loadParamType(success, parameterType));
                        }
                        BytecodeCreator typeMatchFailed = success.ifNonZero(success.invokeVirtualMethod(Descriptors.EVALUATED_PARAMS_PARAM_TYPES_MATCH, (ResultHandle)whenEvaluatedParams, new ResultHandle[]{success.load(isVarArgs), paramTypesHandle})).falseBranch();
                        typeMatchFailed.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE, (ResultHandle)whenRet, new ResultHandle[]{typeMatchFailed.readStaticField(Descriptors.RESULT_NOT_FOUND)});
                        typeMatchFailed.returnValue(null);
                    }
                    TryBlock tryCatch = success.tryBlock();
                    CatchBlockCreator exception = tryCatch.addCatch(Throwable.class);
                    exception.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (ResultHandle)whenRet, new ResultHandle[]{exception.getCaughtException()});
                    ResultHandle[] args = new ResultHandle[paramSize];
                    int shift = 0;
                    if (matchAny) {
                        args[shift] = whenName;
                        ++shift;
                    }
                    if (isVarArgs) {
                        ResultHandle varargsResults;
                        int paramIdx = realParamSize - 1;
                        for (int i = 0; i < paramIdx; ++i) {
                            ResultHandle resultHandle;
                            args[i + shift] = resultHandle = tryCatch.invokeVirtualMethod(Descriptors.EVALUATED_PARAMS_GET_RESULT, (ResultHandle)whenEvaluatedParams, new ResultHandle[]{tryCatch.load(i)});
                        }
                        Type varargsParam = (Type)parameters.get(paramSize - 1);
                        ResultHandle componentType = tryCatch.loadClass(varargsParam.asArrayType().component().name().toString());
                        args[paramIdx + shift] = varargsResults = tryCatch.invokeVirtualMethod(Descriptors.EVALUATED_PARAMS_GET_VARARGS_RESULTS, evaluatedParams, new ResultHandle[]{tryCatch.load(realParamSize), componentType});
                    } else {
                        for (int i = 0; i < realParamSize; ++i) {
                            args[i + shift] = tryCatch.invokeVirtualMethod(Descriptors.EVALUATED_PARAMS_GET_RESULT, evaluatedParams, new ResultHandle[]{tryCatch.load(i)});
                        }
                    }
                    ResultHandle invokeRet = tryCatch.invokeStaticMethod(MethodDescriptor.of((MethodInfo)method), args);
                    tryCatch.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE, (ResultHandle)whenRet, new ResultHandle[]{invokeRet});
                    BytecodeCreator failure = throwableIsNull.falseBranch();
                    failure.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (ResultHandle)whenRet, new ResultHandle[]{whenComplete.getMethodParam(1)});
                    whenComplete.returnValue(null);
                    matchScope.returnValue(ret);
                }
            }

            @Override
            public void close() {
                this.resolve.returnValue(this.resolve.readStaticField(Descriptors.RESULTS_NOT_FOUND));
            }
        }
    }
}

