/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.quarkus.vertx.http.runtime.VertxHttpBuildTimeConfig;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.impl.MimeMapping;
import io.vertx.core.net.impl.URIDecoder;
import io.vertx.ext.web.RoutingContext;
import java.util.Objects;
import java.util.Set;
import org.jboss.logging.Logger;

public final class RoutingUtils {
    private static final String CURRENT_CDI_REQUEST_CTX_OWNER = "io.quarkus.vertx.http.runtime#current-cdi-req-ctx-owner";
    private static final Logger LOG = Logger.getLogger(RoutingUtils.class);

    private RoutingUtils() throws IllegalAccessException {
        throw new IllegalAccessException("Avoid direct instantiation");
    }

    public static void assumeCdiRequestContext(RoutingContext ctx, String newOwner) {
        String previousOwner = ctx.data().put(CURRENT_CDI_REQUEST_CTX_OWNER, Objects.requireNonNull(newOwner));
        if (previousOwner != null && LOG.isDebugEnabled()) {
            LOG.debugf("CDI request context owner has changed from '%s' to '%s'", (Object)previousOwner, (Object)newOwner);
        }
    }

    public static boolean isCdiRequestContextOwner(RoutingContext ctx, String owner) {
        return owner.equals(ctx.get(CURRENT_CDI_REQUEST_CTX_OWNER));
    }

    public static String getNormalizedAndDecodedPath(RoutingContext ctx) {
        String normalizedPath = ctx.normalizedPath();
        if (normalizedPath.indexOf(63) != -1) {
            return null;
        }
        if (normalizedPath.indexOf(37) == -1) {
            return normalizedPath;
        }
        return URIDecoder.decodeURIComponent((String)normalizedPath);
    }

    public static String resolvePath(RoutingContext ctx) {
        String path = RoutingUtils.getNormalizedAndDecodedPath(ctx);
        if (path == null) {
            return null;
        }
        return ctx.mountPoint() == null ? path : path.substring(ctx.mountPoint().endsWith("/") ? ctx.mountPoint().length() - 1 : ctx.mountPoint().length());
    }

    public static void compressIfNeeded(VertxHttpBuildTimeConfig config, Set<String> compressMediaTypes, RoutingContext ctx, String path) {
        if (config.enableCompression() && RoutingUtils.isCompressed(compressMediaTypes, path)) {
            ctx.response().headers().remove(HttpHeaders.CONTENT_ENCODING);
        }
    }

    private static boolean isCompressed(Set<String> compressMediaTypes, String path) {
        if (compressMediaTypes.isEmpty()) {
            return false;
        }
        Object resourcePath = path.endsWith("/") ? path + "index.html" : path;
        String contentType = MimeMapping.getMimeTypeForFilename((String)resourcePath);
        return contentType != null && compressMediaTypes.contains(contentType);
    }
}

