/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.security;

import io.quarkus.vertx.http.runtime.cors.CORSConfig;
import io.quarkus.vertx.http.runtime.security.HttpSecurityUtils;
import io.smallrye.common.annotation.Experimental;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Experimental(value="This API is currently experimental and might get changed")
public interface CORS {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder origins(Set<String> origins) {
        return CORS.builder().origins(origins);
    }

    public static final class Builder {
        private Optional<Boolean> accessControlAllowCredentials;
        private Optional<Duration> accessControlMaxAge;
        private Optional<List<String>> exposedHeaders;
        private Optional<List<String>> headers;
        private Optional<List<String>> methods;
        private Optional<List<String>> origins;

        public Builder() {
            this(HttpSecurityUtils.getDefaultAuthConfig().cors());
        }

        public Builder(CORSConfig corsConfig) {
            this.accessControlAllowCredentials = corsConfig.accessControlAllowCredentials();
            this.accessControlMaxAge = corsConfig.accessControlMaxAge();
            this.exposedHeaders = corsConfig.exposedHeaders();
            this.headers = corsConfig.headers();
            this.methods = corsConfig.methods();
            this.origins = corsConfig.origins();
        }

        public Builder accessControlMaxAge(Duration accessControlMaxAge) {
            Objects.requireNonNull(accessControlMaxAge, "accessControlMaxAge argument must not be null");
            this.accessControlMaxAge = Optional.of(accessControlMaxAge);
            return this;
        }

        public Builder accessControlAllowCredentials() {
            return this.accessControlAllowCredentials(true);
        }

        public Builder accessControlAllowCredentials(boolean accessControlAllowCredentials) {
            this.accessControlAllowCredentials = Optional.of(accessControlAllowCredentials);
            return this;
        }

        public Builder exposedHeader(String exposedHeader) {
            if (exposedHeader == null) {
                throw new IllegalArgumentException("Argument 'exposedHeader' cannot be null");
            }
            return this.exposedHeaders(Set.of(exposedHeader));
        }

        public Builder exposedHeaders(Set<String> exposedHeaders) {
            this.exposedHeaders = Builder.merge(this.exposedHeaders, exposedHeaders, "Exposed headers");
            return this;
        }

        public Builder header(String header) {
            if (header == null) {
                throw new IllegalArgumentException("Argument 'header' cannot be null");
            }
            return this.headers(Set.of(header));
        }

        public Builder headers(Set<String> newHeaders) {
            this.headers = Builder.merge(this.headers, newHeaders, "Headers");
            return this;
        }

        public Builder method(String method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 'method' cannot be null");
            }
            return this.methods(Set.of(method));
        }

        public Builder methods(Set<String> newMethods) {
            this.methods = Builder.merge(this.methods, newMethods, "Methods");
            return this;
        }

        public Builder origin(String origin) {
            if (origin == null) {
                throw new IllegalArgumentException("Argument 'origin' cannot be null");
            }
            return this.origins(Set.of(origin));
        }

        public Builder origins(Set<String> newOrigins) {
            this.origins = Builder.merge(this.origins, newOrigins, "Origins");
            return this;
        }

        public CORS build() {
            return new CORSImpl(this.accessControlAllowCredentials, this.accessControlMaxAge, this.exposedHeaders, this.headers, this.methods, this.origins);
        }

        private static Optional<List<String>> merge(Optional<List<String>> optionalOriginalList, Set<String> newSet, String what) {
            if (newSet == null) {
                throw new IllegalArgumentException(what + " must not be null");
            }
            if (newSet.isEmpty()) {
                return optionalOriginalList;
            }
            List<String> result = optionalOriginalList.orElse(List.of()).isEmpty() ? List.copyOf(newSet) : Stream.concat(optionalOriginalList.get().stream(), newSet.stream()).toList();
            return Optional.of(result);
        }

        record CORSImpl(Optional<Boolean> accessControlAllowCredentials, Optional<Duration> accessControlMaxAge, Optional<List<String>> exposedHeaders, Optional<List<String>> headers, Optional<List<String>> methods, Optional<List<String>> origins) implements CORS,
        CORSConfig
        {
            @Override
            public boolean enabled() {
                return true;
            }
        }
    }
}

